/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.sql.DriverManager;
import java.sql.SQLWarning;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLException
extends Exception
implements Iterable<Throwable> {
    private String SQLState;
    private int vendorCode;
    private volatile SQLException next;
    private static final AtomicReferenceFieldUpdater<SQLException, SQLException> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(SQLException.class, SQLException.class, "next");
    private static final long serialVersionUID = 2135244094396331484L;

    public SQLException(String string, String string2, int n) {
        super(string);
        this.SQLState = string2;
        this.vendorCode = n;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            DriverManager.println("SQLState(" + string2 + ") vendor code(" + n + ")");
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException(String string, String string2) {
        super(string);
        this.SQLState = string2;
        this.vendorCode = 0;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
            DriverManager.println("SQLException: SQLState(" + string2 + ")");
        }
    }

    public SQLException(String string) {
        super(string);
        this.SQLState = null;
        this.vendorCode = 0;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException() {
        this.SQLState = null;
        this.vendorCode = 0;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException(Throwable throwable) {
        super(throwable);
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException(String string, Throwable throwable) {
        super(string, throwable);
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException(String string, String string2, Throwable throwable) {
        super(string, throwable);
        this.SQLState = string2;
        this.vendorCode = 0;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
            DriverManager.println("SQLState(" + this.SQLState + ")");
        }
    }

    public SQLException(String string, String string2, int n, Throwable throwable) {
        super(string, throwable);
        this.SQLState = string2;
        this.vendorCode = n;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            DriverManager.println("SQLState(" + this.SQLState + ") vendor code(" + n + ")");
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public String getSQLState() {
        return this.SQLState;
    }

    public int getErrorCode() {
        return this.vendorCode;
    }

    public SQLException getNextException() {
        return this.next;
    }

    public void setNextException(SQLException sQLException) {
        SQLException sQLException2 = this;
        while (true) {
            SQLException sQLException3;
            if ((sQLException3 = sQLException2.next) != null) {
                sQLException2 = sQLException3;
                continue;
            }
            if (nextUpdater.compareAndSet(sQLException2, null, sQLException)) {
                return;
            }
            sQLException2 = sQLException2.next;
        }
    }

    @Override
    public Iterator<Throwable> iterator() {
        return new Iterator<Throwable>(){
            SQLException firstException;
            SQLException nextException;
            Throwable cause;
            {
                this.firstException = SQLException.this;
                this.nextException = this.firstException.getNextException();
                this.cause = this.firstException.getCause();
            }

            @Override
            public boolean hasNext() {
                return this.firstException != null || this.nextException != null || this.cause != null;
            }

            @Override
            public Throwable next() {
                Throwable throwable = null;
                if (this.firstException != null) {
                    throwable = this.firstException;
                    this.firstException = null;
                } else if (this.cause != null) {
                    throwable = this.cause;
                    this.cause = this.cause.getCause();
                } else if (this.nextException != null) {
                    throwable = this.nextException;
                    this.cause = this.nextException.getCause();
                    this.nextException = this.nextException.getNextException();
                } else {
                    throw new NoSuchElementException();
                }
                return throwable;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

