/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public PushbackReader(Reader reader, int n) {
        super(reader);
        if (n <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new char[n];
        this.pos = n;
    }

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos < this.buf.length) {
                return this.buf[this.pos++];
            }
            return super.read();
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            try {
                if (n2 <= 0) {
                    if (n2 < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (n < 0 || n > cArray.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    return 0;
                }
                int n3 = this.buf.length - this.pos;
                if (n3 > 0) {
                    if (n2 < n3) {
                        n3 = n2;
                    }
                    System.arraycopy(this.buf, this.pos, cArray, n, n3);
                    this.pos += n3;
                    n += n3;
                    n2 -= n3;
                }
                if (n2 > 0) {
                    if ((n2 = super.read(cArray, n, n2)) == -1) {
                        return n3 == 0 ? -1 : n3;
                    }
                    return n3 + n2;
                }
                return n3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos == 0) {
                throw new IOException("Pushback buffer overflow");
            }
            this.buf[--this.pos] = (char)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n2 > this.pos) {
                throw new IOException("Pushback buffer overflow");
            }
            this.pos -= n2;
            System.arraycopy(cArray, n, this.buf, this.pos, n2);
        }
    }

    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.pos < this.buf.length || super.ready();
        }
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.buf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n = this.buf.length - this.pos;
            if (n > 0) {
                if (l <= (long)n) {
                    this.pos = (int)((long)this.pos + l);
                    return l;
                }
                this.pos = this.buf.length;
                l -= (long)n;
            }
            return (long)n + super.skip(l);
        }
    }
}

