/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.ServerHandshaker;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private SSLContextImpl sslContext;
    private byte doClientAuth = 0;
    private boolean useServerMode = true;
    private boolean enableSessionCreation = true;
    private CipherSuiteList enabledCipherSuites = null;
    private ProtocolList enabledProtocols = null;
    private boolean checkedEnabled = false;

    SSLServerSocketImpl(int n, int n2, SSLContextImpl sSLContextImpl) throws IOException, SSLException {
        super(n, n2);
        this.initServer(sSLContextImpl);
    }

    SSLServerSocketImpl(int n, int n2, InetAddress inetAddress, SSLContextImpl sSLContextImpl) throws IOException {
        super(n, n2, inetAddress);
        this.initServer(sSLContextImpl);
    }

    SSLServerSocketImpl(SSLContextImpl sSLContextImpl) throws IOException {
        this.initServer(sSLContextImpl);
    }

    private void initServer(SSLContextImpl sSLContextImpl) throws SSLException {
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.sslContext = sSLContextImpl;
        this.enabledCipherSuites = CipherSuiteList.getDefault();
        this.enabledProtocols = ProtocolList.getDefault();
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getSupported().toStringArray();
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = new CipherSuiteList(stringArray);
        this.checkedEnabled = false;
    }

    public String[] getSupportedProtocols() {
        return ProtocolList.getSupported().toStringArray();
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = new ProtocolList(stringArray);
    }

    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    public void setNeedClientAuth(boolean bl) {
        this.doClientAuth = (byte)(bl ? 2 : 0);
    }

    public boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    public void setWantClientAuth(boolean bl) {
        this.doClientAuth = bl ? (byte)1 : 0;
    }

    public boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    public void setUseClientMode(boolean bl) {
        this.useServerMode = !bl;
    }

    public boolean getUseClientMode() {
        return !this.useServerMode;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public Socket accept() throws IOException {
        this.checkEnabledSuites();
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.doneConnect();
        return sSLSocketImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnabledSuites() throws IOException {
        SSLServerSocketImpl sSLServerSocketImpl = this;
        synchronized (sSLServerSocketImpl) {
            if (this.checkedEnabled) {
                return;
            }
            if (!this.useServerMode) {
                return;
            }
            SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols);
            try {
                ServerHandshaker serverHandshaker = sSLSocketImpl.getServerHandshaker();
                Iterator<CipherSuite> iterator = this.enabledCipherSuites.iterator();
                while (true) {
                    if (iterator.hasNext()) {
                        CipherSuite cipherSuite = iterator.next();
                        if (!serverHandshaker.trySetCipherSuite(cipherSuite)) continue;
                        this.checkedEnabled = true;
                        return;
                        continue;
                    }
                    break;
                }
            }
            finally {
                sSLSocketImpl.closeSocket();
            }
            throw new SSLException("No available certificate or key corresponds to the SSL cipher suites which are enabled.");
        }
    }

    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

