/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.Point2D;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.HashMap;
import sun.font.Font2D;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.GlyphLayout;
import sun.font.TextRecord;
import sun.security.action.LoadLibraryAction;

public final class SunLayoutEngine
implements GlyphLayout.LayoutEngine,
GlyphLayout.LayoutEngineFactory {
    private GlyphLayout.LayoutEngineKey key;
    private static GlyphLayout.LayoutEngineFactory instance;
    private SoftReference cacheref = new SoftReference<Object>(null);

    private static native void initGVIDs();

    public static GlyphLayout.LayoutEngineFactory instance() {
        if (instance == null) {
            instance = new SunLayoutEngine();
        }
        return instance;
    }

    private SunLayoutEngine() {
    }

    public GlyphLayout.LayoutEngine getEngine(Font2D font2D, int n, int n2) {
        return this.getEngine(new GlyphLayout.LayoutEngineKey(font2D, n, n2));
    }

    public GlyphLayout.LayoutEngine getEngine(GlyphLayout.LayoutEngineKey layoutEngineKey) {
        GlyphLayout.LayoutEngine layoutEngine;
        HashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine> hashMap = (HashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine>)this.cacheref.get();
        if (hashMap == null) {
            hashMap = new HashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine>();
            this.cacheref = new SoftReference(hashMap);
        }
        if ((layoutEngine = (GlyphLayout.LayoutEngine)hashMap.get(layoutEngineKey)) == null) {
            layoutEngine = new SunLayoutEngine(layoutEngineKey.copy());
            hashMap.put(layoutEngineKey, layoutEngine);
        }
        return layoutEngine;
    }

    private SunLayoutEngine(GlyphLayout.LayoutEngineKey layoutEngineKey) {
        this.key = layoutEngineKey;
    }

    public void layout(FontStrikeDesc fontStrikeDesc, float[] fArray, int n, int n2, TextRecord textRecord, int n3, Point2D.Float float_, GlyphLayout.GVData gVData) {
        Font2D font2D = this.key.font();
        FontStrike fontStrike = font2D.getStrike(fontStrikeDesc);
        SunLayoutEngine.nativeLayout(font2D, fontStrike, fArray, n, n2, textRecord.text, textRecord.start, textRecord.limit, textRecord.min, textRecord.max, this.key.script(), this.key.lang(), n3, float_, gVData);
    }

    private static native void nativeLayout(Font2D var0, FontStrike var1, float[] var2, int var3, int var4, char[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Point2D.Float var13, GlyphLayout.GVData var14);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("fontmanager"));
        SunLayoutEngine.initGVIDs();
    }
}

