/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthTextFieldUI;
import javax.swing.text.JTextComponent;
import sun.swing.plaf.synth.SynthUI;

class SynthTextAreaUI
extends BasicTextAreaUI
implements SynthUI,
FocusListener {
    private SynthStyle style;

    SynthTextAreaUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTextAreaUI();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.getComponent().repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.getComponent().repaint();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this.getComponent());
        this.getComponent().addFocusListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.getComponent(), 1);
        this.getComponent().putClientProperty("caretAspectRatio", null);
        this.getComponent().removeFocusListener(this);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    private void updateStyle(JTextComponent jTextComponent) {
        SynthContext synthContext = this.getContext(jTextComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            SynthTextFieldUI.updateStyle(jTextComponent, synthContext, this.getPropertyPrefix());
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTextAreaBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        super.paint(graphics, this.getComponent());
    }

    protected void paintBackground(Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintTextAreaBorder(synthContext, graphics, n, n2, n3, n4);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTextComponent)propertyChangeEvent.getSource());
        }
        super.propertyChange(propertyChangeEvent);
    }
}

