/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.misc.SoftCache;
import sun.misc.VM;
import sun.nio.ch.Interruptible;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thread
implements Runnable {
    private char[] name;
    private int priority;
    private Thread threadQ;
    private long eetop;
    private boolean single_step;
    private boolean daemon = false;
    private boolean stillborn = false;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private long stackSize;
    private long nativeParkEventPointer;
    private long tid;
    private static long threadSeqNumber;
    private int threadStatus = 0;
    volatile Object parkBlocker;
    private volatile Interruptible blocker;
    private Object blockerLock = new Object();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private boolean stopBeforeStart;
    private Throwable throwableFromStop;
    private volatile Thread me;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;
    private static final RuntimePermission SUBCLASS_IMPLEMENTATION_PERMISSION;
    private static final SoftCache subclassAudits;
    private volatile UncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler defaultUncaughtExceptionHandler;

    private static native void registerNatives();

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockedOn(Interruptible interruptible) {
        Object object = this.blockerLock;
        synchronized (object) {
            this.blocker = interruptible;
        }
    }

    public static native Thread currentThread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        Thread.sleep(l);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        Thread thread = Thread.currentThread();
        SecurityManager securityManager = System.getSecurityManager();
        if (threadGroup == null) {
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.getThreadGroup();
            }
        }
        threadGroup.checkAccess();
        if (securityManager != null && Thread.isCCLOverridden(this.getClass())) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        threadGroup.addUnstarted();
        this.group = threadGroup;
        this.daemon = thread.isDaemon();
        this.priority = thread.getPriority();
        this.name = string.toCharArray();
        this.contextClassLoader = securityManager == null || Thread.isCCLOverridden(thread.getClass()) ? thread.getContextClassLoader() : thread.contextClassLoader;
        this.inheritedAccessControlContext = AccessController.getContext();
        this.target = runnable;
        this.setPriority(this.priority);
        if (thread.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread.inheritableThreadLocals);
        }
        this.stackSize = l;
        this.tid = Thread.nextThreadID();
        this.me = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        Thread thread;
        Thread thread2 = this;
        synchronized (thread2) {
            thread = (Thread)super.clone();
            thread.tid = Thread.nextThreadID();
            thread.parkBlocker = null;
            thread.blocker = null;
            thread.blockerLock = new Object();
            thread.threadLocals = null;
            this.group.checkAccess();
            if (this.threadStatus == 0) {
                this.group.addUnstarted();
            }
            thread.setPriority(this.priority);
            Thread thread3 = Thread.currentThread();
            if (thread3.inheritableThreadLocals != null) {
                thread.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread3.inheritableThreadLocals);
            }
        }
        thread.me = thread;
        return thread;
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(String string) {
        this.init(null, null, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string, 0L);
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this.init(threadGroup, runnable, string, l);
    }

    public synchronized void start() {
        if (this.threadStatus != 0 || this != this.me) {
            throw new IllegalThreadStateException();
        }
        this.group.add(this);
        this.start0();
        if (this.stopBeforeStart) {
            this.stop0(this.throwableFromStop);
        }
    }

    private native void start0();

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        this.target = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        this.inheritedAccessControlContext = null;
        this.blocker = null;
        this.uncaughtExceptionHandler = null;
    }

    @Deprecated
    public final void stop() {
        if (this.threadStatus != 0 && !this.isAlive()) {
            return;
        }
        this.stop1(new ThreadDeath());
    }

    @Deprecated
    public final synchronized void stop(Throwable throwable) {
        this.stop1(throwable);
    }

    private final synchronized void stop1(Throwable throwable) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.checkAccess();
            if (this != Thread.currentThread() || !(throwable instanceof ThreadDeath)) {
                securityManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
            }
        }
        if (this.threadStatus != 0) {
            this.resume();
            this.stop0(throwable);
        } else {
            if (throwable == null) {
                throw new NullPointerException();
            }
            this.stopBeforeStart = true;
            this.throwableFromStop = throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (this != Thread.currentThread()) {
            this.checkAccess();
        }
        Object object = this.blockerLock;
        synchronized (object) {
            Interruptible interruptible = this.blocker;
            if (interruptible != null) {
                this.interrupt0();
                interruptible.interrupt();
                return;
            }
        }
        this.interrupt0();
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.isInterrupted(false);
    }

    private native boolean isInterrupted(boolean var1);

    @Deprecated
    public void destroy() {
        throw new NoSuchMethodError();
    }

    public final native boolean isAlive();

    @Deprecated
    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    @Deprecated
    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            if (n > threadGroup.getMaxPriority()) {
                n = threadGroup.getMaxPriority();
            }
            this.priority = n;
            this.setPriority0(this.priority);
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setName(String string) {
        this.checkAccess();
        this.name = string.toCharArray();
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    @Deprecated
    public native int countStackFrames();

    public final synchronized void join(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (l == 0L) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long l4;
            while (this.isAlive() && (l4 = l - l3) > 0L) {
                this.wait(l4);
                l3 = System.currentTimeMillis() - l2;
            }
        }
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        this.join(l);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = bl;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public String toString() {
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + threadGroup.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "" + "]";
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != this.contextClassLoader && !this.contextClassLoader.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classLoader;
    }

    public static native boolean holdsLock(Object var0);

    public StackTraceElement[] getStackTrace() {
        if (this != Thread.currentThread()) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            }
            if (!this.isAlive()) {
                return EMPTY_STACK_TRACE;
            }
            StackTraceElement[][] stackTraceElementArray = Thread.dumpThreads(new Thread[]{this});
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray[0];
            if (stackTraceElementArray2 == null) {
                stackTraceElementArray2 = EMPTY_STACK_TRACE;
            }
            return stackTraceElementArray2;
        }
        return new Exception().getStackTrace();
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        Thread[] threadArray = Thread.getThreads();
        StackTraceElement[][] stackTraceElementArray = Thread.dumpThreads(threadArray);
        HashMap<Thread, StackTraceElement[]> hashMap = new HashMap<Thread, StackTraceElement[]>(threadArray.length);
        for (int i = 0; i < threadArray.length; ++i) {
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray[i];
            if (stackTraceElementArray2 == null) continue;
            hashMap.put(threadArray[i], stackTraceElementArray2);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCCLOverridden(Class clazz) {
        if (clazz == Thread.class) {
            return false;
        }
        Boolean bl = null;
        SoftCache softCache = subclassAudits;
        synchronized (softCache) {
            bl = (Boolean)subclassAudits.get(clazz);
            if (bl == null) {
                bl = new Boolean(Thread.auditSubclass(clazz));
                subclassAudits.put(clazz, bl);
            }
        }
        return bl;
    }

    private static boolean auditSubclass(final Class clazz) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class clazz2 = clazz; clazz2 != Thread.class; clazz2 = clazz2.getSuperclass()) {
                    try {
                        clazz2.getDeclaredMethod("getContextClassLoader", new Class[0]);
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] classArray = new Class[]{ClassLoader.class};
                            clazz2.getDeclaredMethod("setContextClassLoader", classArray);
                            return Boolean.TRUE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    private static native Thread[] getThreads();

    public long getId() {
        return this.tid;
    }

    public State getState() {
        return VM.toThreadState(this.threadStatus);
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler != null ? this.uncaughtExceptionHandler : this.group;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.checkAccess();
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    private void dispatchUncaughtException(Throwable throwable) {
        this.getUncaughtExceptionHandler().uncaughtException(this, throwable);
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    private native void interrupt0();

    static {
        Thread.registerNatives();
        EMPTY_STACK_TRACE = new StackTraceElement[0];
        SUBCLASS_IMPLEMENTATION_PERMISSION = new RuntimePermission("enableContextClassLoaderOverride");
        subclassAudits = new SoftCache(10);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }
}

