/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.Installer.InstallerFactory;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.Dumper;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.PackageCollector;

public class ModuleCtrl {
    private ModuleCtrl() {
    }

    public static void setModuleSize(PackageDescription packageData) {
        if (!packageData.isLeaf() && !packageData.isHidden()) {
            boolean setNewSize = false;
            int size = packageData.getSize();
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                if (!child.isHidden()) continue;
                setNewSize = true;
                size += child.getSize();
            }
            if (setNewSize) {
                packageData.setSize(size);
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setModuleSize(child);
        }
    }

    public static void setDefaultModuleSettings(PackageDescription data) {
        boolean isInstalled = false;
        InstallData installdata = InstallData.getInstance();
        boolean isUninstall = installdata.isUninstallationMode();
        if (isUninstall) {
            isInstalled = true;
        }
        if (isUninstall) {
            if (isInstalled) {
                data.setSelectionState(3);
            } else {
                data.setSelectionState(6);
                System.err.println("NEVER");
            }
        } else if (isInstalled) {
            data.setSelectionState(6);
            System.err.println("NEVER");
        } else if (data.isDefault()) {
            data.setSelectionState(1);
        } else if (!data.isDefault()) {
            data.setSelectionState(0);
        } else {
            data.setSelectionState(0);
        }
    }

    public static void setParentDefaultModuleSettings(PackageDescription packageData) {
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setParentDefaultModuleSettings(child);
        }
        if (!packageData.isLeaf()) {
            int state = packageData.getSelectionState();
            InstallData installdata = InstallData.getInstance();
            boolean allChildrenIgnored = true;
            boolean atLeastOneInstalled = false;
            boolean allChildrenHidden = true;
            Enumeration e2 = packageData.children();
            while (e2.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e2.nextElement();
                int childState = child.getSelectionState();
                if (childState != 6) {
                    allChildrenIgnored = false;
                }
                if (childState == 1 || childState == 2) {
                    atLeastOneInstalled = true;
                }
                if (!child.isHidden()) {
                    allChildrenHidden = false;
                }
                if (state == 7 || state == 6) {
                    state = childState;
                    continue;
                }
                if (state == childState || childState == 6 || childState == 7) continue;
                if (installdata.isUninstallationMode()) {
                    state = 5;
                    continue;
                }
                state = 2;
            }
            if (allChildrenIgnored) {
                state = 6;
            }
            if (installdata.isInstallationMode() && state == 2 && !atLeastOneInstalled) {
                state = 0;
            }
            if (allChildrenHidden) {
                packageData.setAllChildrenHidden(true);
            }
            if (installdata.olderVersionExists()) {
                if (packageData.getPackageName().equals("")) {
                    packageData.setSelectionState(state);
                }
            } else {
                packageData.setSelectionState(state);
            }
        }
    }

    public static void setHiddenModuleSettingsInstall(PackageDescription packageData) {
        if (packageData.isHidden()) {
            if (packageData.getSelectionState() != 6) {
                PackageDescription parent = (PackageDescription)packageData.getParent();
                if (parent != null) {
                    packageData.setSelectionState(parent.getSelectionState());
                    if (parent.getName() == "") {
                        packageData.setSelectionState(1);
                    }
                }
                if (packageData.getSelectionState() == 2 && packageData.isLeaf()) {
                    packageData.setSelectionState(1);
                }
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setHiddenModuleSettingsInstall(child);
        }
    }

    public static void setHiddenModuleSettingsUninstall(PackageDescription packageData) {
        InstallData data = InstallData.getInstance();
        if (packageData.isHidden()) {
            if (packageData.getSelectionState() != 6) {
                PackageDescription parent = (PackageDescription)packageData.getParent();
                if (parent != null) {
                    packageData.setSelectionState(parent.getSelectionState());
                    if (parent.getName() == "" && data.isTypicalInstallation()) {
                        packageData.setSelectionState(3);
                    }
                    if (!data.isMaskedCompleteUninstallation() && parent.getName() == "" && data.isCustomInstallation()) {
                        packageData.setSelectionState(6);
                    }
                }
                if (packageData.getSelectionState() == 5 && packageData.isLeaf()) {
                    packageData.setSelectionState(3);
                }
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setHiddenModuleSettingsUninstall(child);
        }
    }

    private static boolean checkRequiredCoreModule(PackageDescription packageData) {
        boolean requiredCoreModule = false;
        if (packageData.isHidden()) {
            PackageDescription parent;
            if (packageData.getSelectionState() != 6 && packageData.getPackageName() != null && (parent = (PackageDescription)packageData.getParent()) != null) {
                PackageDescription grandpa;
                if (parent.getName().equals("") || parent.getName() == null) {
                    requiredCoreModule = true;
                } else if (parent.isHidden() && (grandpa = (PackageDescription)parent.getParent()) != null && (grandpa.getName().equals("") || grandpa.getName() == null)) {
                    requiredCoreModule = true;
                }
            }
        }
        return requiredCoreModule;
    }

    public static void setDatabaseSettings(PackageDescription packageData, InstallData installData, Installer installer) {
        boolean isUninstall = installData.isUninstallationMode();
        boolean isInstalled = installer.isPackageInstalled(packageData, installData);
        if (isUninstall) {
            if (isInstalled) {
                packageData.setSelectionState(3);
            } else {
                packageData.setSelectionState(6);
            }
        } else {
            boolean goodDepends = true;
            if (installData.getOSType().equalsIgnoreCase("SunOS") && installData.isRootInstallation() && packageData.getCheckSolaris() != null && !packageData.getCheckSolaris().equals("") && !installer.isPackageNameInstalled(packageData.getCheckSolaris(), installData)) {
                goodDepends = false;
            }
            if (!goodDepends) {
                packageData.setSelectionState(6);
            } else if (isInstalled) {
                if (packageData.isJavaPackage()) {
                    boolean installedPackageIsOlder = installer.isInstalledPackageOlder(packageData, installData);
                    if (!installedPackageIsOlder) {
                        packageData.setSelectionState(6);
                    } else {
                        packageData.setSelectionState(1);
                    }
                } else if (installData.olderVersionExists()) {
                    packageData.setSelectionState(1);
                } else {
                    packageData.setSelectionState(6);
                }
            } else {
                boolean isRequiredCoreModule = ModuleCtrl.checkRequiredCoreModule(packageData);
                if (isRequiredCoreModule) {
                    if (packageData.getSelectionState() != 1) {
                        packageData.setSelectionState(1);
                        LogManager.addLogfileComment("<b>Adding required package:</b> " + packageData.getPackageName() + "</br>");
                    }
                    if (!ModuleCtrl.packageExists(packageData, installData)) {
                        String packagePath = installData.getPackagePath();
                        if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
                            File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
                            packagePath = completePackageFile.getPath();
                        }
                        String packageName = packageData.getPackageName();
                        File packageFile = new File(packagePath, packageName);
                        String log = "<b>Error: Missing required package " + packageFile.getPath() + "</b><br>";
                        System.err.println(log);
                        String message = ResourceManager.getString("String_File_Not_Found") + ": " + packageFile.getPath();
                        String title = ResourceManager.getString("String_Error");
                        Informer.showErrorMessage(message, title);
                        System.exit(1);
                    }
                }
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setDatabaseSettings(child, installData, installer);
        }
    }

    public static void setShowInUserInstallFlags(PackageDescription packageData) {
        if (!packageData.showInUserInstall()) {
            packageData.setSelectionState(6);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setShowInUserInstallFlags(child);
        }
    }

    public static void setForcedUpdateProductSettings(PackageDescription packageData) {
        if (packageData.forceIntoUpdate()) {
            packageData.setSelectionState(1);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setForcedUpdateProductSettings(child);
        }
    }

    public static void setShowInUserInstallOnlyFlags(PackageDescription packageData) {
        if (packageData.showInUserInstallOnly()) {
            packageData.setSelectionState(6);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setShowInUserInstallOnlyFlags(child);
        }
    }

    public static void setIgnoreNonRelocatablePackages(PackageDescription packageData) {
        if (!packageData.isRelocatable()) {
            packageData.setSelectionState(6);
            System.err.println("Ignoring package " + packageData.getName() + " " + packageData.getPackageName());
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setIgnoreNonRelocatablePackages(child);
        }
    }

    public static void setHiddenLanguageModuleDefaultSettings(PackageDescription packageData) {
        if (packageData.showMultiLingualOnly()) {
            packageData.setSelectionState(1);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setHiddenLanguageModuleDefaultSettings(child);
        }
    }

    private static boolean packageExists(PackageDescription packageData, InstallData installData) {
        String packageName;
        File packageFile;
        boolean fileExists = false;
        String packagePath = installData.getPackagePath();
        if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
            File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
            packagePath = completePackageFile.getPath();
        }
        if ((packageFile = new File(packagePath, packageName = packageData.getPackageName())).exists()) {
            fileExists = true;
        }
        return fileExists;
    }

    public static void disableNonExistingPackages(PackageDescription packageData, InstallData installData) {
        if ((packageData.getPackageName() == null || packageData.getPackageName().equals("")) && packageData.isLeaf()) {
            packageData.setSelectionState(6);
        } else if (!ModuleCtrl.packageExists(packageData, installData)) {
            packageData.setSelectionState(6);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.disableNonExistingPackages(child, installData);
        }
    }

    public static void setDontUninstallFlags(PackageDescription packageData) {
        if (packageData.dontUninstall()) {
            packageData.setSelectionState(6);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setDontUninstallFlags(child);
        }
    }

    public static void setDontUninstallUserInstallOnylFlags(PackageDescription packageData) {
        if (packageData.showInUserInstallOnly()) {
            packageData.setSelectionState(6);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setDontUninstallUserInstallOnylFlags(child);
        }
    }

    public static void checkVisibleModulesInstall(PackageDescription packageData, InstallData data) {
        boolean setToTrue = false;
        if (!packageData.isHidden()) {
            if (packageData.getSelectionState() == 1) {
                setToTrue = true;
                data.setVisibleModulesChecked(true);
            }
        }
        if (!setToTrue) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkVisibleModulesInstall(child, data);
            }
        }
    }

    public static void checkApplicationSelection(PackageDescription packageData, InstallData data) {
        boolean setToTrue = false;
        if (packageData.isApplicationPackage() && !packageData.isHidden()) {
            if (packageData.getSelectionState() == 1) {
                setToTrue = true;
                data.setApplicationModulesChecked(true);
            }
        }
        if (!setToTrue) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkApplicationSelection(child, data);
            }
        }
    }

    public static void checkLanguageSelection(PackageDescription packageData, InstallData data) {
        boolean setToTrue = false;
        if (packageData.showMultiLingualOnly() && !packageData.isHidden()) {
            if (packageData.getSelectionState() == 1) {
                setToTrue = true;
                data.setLanguageModulesChecked(true);
            }
        }
        if (!setToTrue) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkLanguageSelection(child, data);
            }
        }
    }

    public static void checkVisibleModulesUninstall(PackageDescription packageData, InstallData data) {
        boolean setToTrue = false;
        if (!packageData.isHidden()) {
            if (packageData.getSelectionState() == 3 && packageData.getName() != null && !packageData.getName().equals("")) {
                setToTrue = true;
                data.setVisibleModulesChecked(true);
            }
        }
        if (!setToTrue) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkVisibleModulesUninstall(child, data);
            }
        }
    }

    public static void checkApplicationModulesUninstall(PackageDescription packageData, InstallData data) {
        boolean setToTrue = false;
        if (packageData.isApplicationPackage() && !packageData.isHidden()) {
            if (packageData.getSelectionState() != 6) {
                if (packageData.getSelectionState() != 3) {
                    setToTrue = true;
                    data.setApplicationModulesChecked(true);
                }
            }
        }
        if (!setToTrue) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkApplicationModulesUninstall(child, data);
            }
        }
    }

    public static void checkLanguageModulesUninstall(PackageDescription packageData, InstallData data) {
        boolean setToTrue = false;
        if (packageData.showMultiLingualOnly() && !packageData.isHidden()) {
            if (packageData.getSelectionState() != 6) {
                if (packageData.getSelectionState() != 3) {
                    setToTrue = true;
                    data.setLanguageModulesChecked(true);
                }
            }
        }
        if (!setToTrue) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkLanguageModulesUninstall(child, data);
            }
        }
    }

    public static void checkMaskedCompleteUninstallation(PackageDescription packageData, InstallData data) {
        boolean setToFalse = false;
        if (!packageData.isHidden()) {
            if (packageData.getSelectionState() != 3) {
                if (packageData.getSelectionState() != 6 && packageData.getName() != null && !packageData.getName().equals("")) {
                    setToFalse = true;
                    data.setMaskedCompleteUninstallation(false);
                }
            }
        }
        if (!setToFalse) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkMaskedCompleteUninstallation(child, data);
            }
        }
    }

    public static void saveTypicalSelectionStates(PackageDescription packageData) {
        packageData.setTypicalSelectionState(packageData.getSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.saveTypicalSelectionStates(child);
        }
    }

    public static void saveCustomSelectionStates(PackageDescription packageData) {
        packageData.setCustomSelectionState(packageData.getSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.saveCustomSelectionStates(child);
        }
    }

    public static void saveStartSelectionStates(PackageDescription packageData) {
        packageData.setStartSelectionState(packageData.getSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.saveStartSelectionStates(child);
        }
    }

    public static void restoreTypicalSelectionStates(PackageDescription packageData) {
        packageData.setSelectionState(packageData.getTypicalSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.restoreTypicalSelectionStates(child);
        }
    }

    public static void restoreCustomSelectionStates(PackageDescription packageData) {
        packageData.setSelectionState(packageData.getCustomSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.restoreCustomSelectionStates(child);
        }
    }

    public static void restoreStartSelectionStates(PackageDescription packageData) {
        packageData.setSelectionState(packageData.getStartSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.restoreStartSelectionStates(child);
        }
    }

    public static void setUpdateOlderProductSettings(PackageDescription packageData, InstallData data, Installer installer) {
        if (packageData.getPackageName() != null && !packageData.getPackageName().equals("")) {
            if (installer.isPackageInstalled(packageData, data)) {
                packageData.setSelectionState(1);
                if (packageData.isJavaPackage() && !installer.isInstalledPackageOlder(packageData, data)) {
                    packageData.setSelectionState(0);
                }
            } else {
                packageData.setSelectionState(0);
                if (data.isMajorUpgrade()) {
                    String basis = "ooobasis3";
                    if (data.getOSType().equalsIgnoreCase("Linux")) {
                        basis = basis + ".";
                    }
                    String search = basis + data.getProductMinor();
                    String replacestring = basis + data.getInstalledProductMinor();
                    int pos = packageData.getPackageName().indexOf(search);
                    if (pos > -1) {
                        PackageDescription localPackage = new PackageDescription();
                        localPackage.setUninstallCanFail(true);
                        localPackage.setIsRelocatable(packageData.isRelocatable());
                        String localName = packageData.getPackageName();
                        localName = localName.replace(search, replacestring);
                        localPackage.setPackageName(localName);
                        if (packageData.getPkgRealName() != null && !packageData.getPkgRealName().equals("")) {
                            localName = packageData.getPkgRealName();
                            localName = localName.replace(search, replacestring);
                            localPackage.setPkgRealName(localName);
                        }
                        if (packageData.getName() != null && !packageData.getName().equals("")) {
                            localName = packageData.getName();
                            localName = localName.replace(search, replacestring);
                            localPackage.setName(localName);
                        }
                        localPackage.setOrder(packageData.getOrder());
                        if (installer.isPackageInstalled(localPackage, data)) {
                            packageData.setSelectionState(1);
                            Vector oldPackages = data.getOldPackages();
                            oldPackages.add(localPackage);
                            data.setOldPackages(oldPackages);
                        }
                    }
                }
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setUpdateOlderProductSettings(child, data, installer);
        }
    }

    public static void checkLanguagesPackages(PackageDescription packageData, InstallData installData) {
        if (packageData.getPkgLanguage() != null && !packageData.getPkgLanguage().equals("")) {
            String allLang = packageData.getPkgLanguage();
            String[] allLangs = allLang.split(",");
            Vector systemLanguages = installData.getSystemLanguages();
            boolean foundLang = false;
            for (int i = 0; i < allLangs.length; ++i) {
                String oneLang = allLangs[i];
                if (!systemLanguages.contains(oneLang = oneLang.trim())) continue;
                foundLang = true;
                int count = installData.getPreselectedLanguages();
                installData.setPreselectedLanguages(++count);
                break;
            }
            if (!foundLang) {
                packageData.setSelectionState(0);
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.checkLanguagesPackages(child, installData);
        }
    }

    public static void setLanguagesPackages(PackageDescription packageData) {
        if (packageData.getPkgLanguage() != null && !packageData.getPkgLanguage().equals("")) {
            packageData.setSelectionState(1);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setLanguagesPackages(child);
        }
    }

    public static void setRequiredNewCoreModules(PackageDescription packageData, InstallData installData) {
        boolean isRequiredCoreModule = ModuleCtrl.checkRequiredCoreModule(packageData);
        if (isRequiredCoreModule) {
            if (packageData.getSelectionState() != 1) {
                packageData.setSelectionState(1);
                LogManager.addLogfileComment("<b>Adding required package:</b> " + packageData.getPackageName() + "</br>");
            }
            if (!ModuleCtrl.packageExists(packageData, installData)) {
                String packagePath = installData.getPackagePath();
                if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
                    File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
                    packagePath = completePackageFile.getPath();
                }
                String packageName = packageData.getPackageName();
                File packageFile = new File(packagePath, packageName);
                String log = "<b>Error: Missing required package " + packageFile.getPath() + "</b><br>";
                System.err.println(log);
                String message = ResourceManager.getString("String_File_Not_Found") + ": " + packageFile.getPath();
                String title = ResourceManager.getString("String_Error");
                Informer.showErrorMessage(message, title);
                System.exit(1);
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setRequiredNewCoreModules(child, installData);
        }
    }

    public static void defaultDatabaseAnalysis(InstallData data) {
        PackageDescription packageData = SetupDataProvider.getPackageDescription();
        Installer installer = InstallerFactory.getInstance();
        if (data.startSelectionStateSaved()) {
            ModuleCtrl.restoreStartSelectionStates(packageData);
        } else {
            ModuleCtrl.saveStartSelectionStates(packageData);
            data.setStartSelectionStateSaved(true);
        }
        if (data.olderVersionExists()) {
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "ChooseDirectory: Before setUpdateOlderProductSettings");
            }
            ModuleCtrl.setUpdateOlderProductSettings(packageData, data, installer);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "ChooseDirectory: After setUpdateOlderProductSettings");
            }
            ModuleCtrl.setForcedUpdateProductSettings(packageData);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "ChooseDirectory: After setForcedUpdateProductSettings");
            }
            ModuleCtrl.setRequiredNewCoreModules(packageData, data);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "ChooseDirectory: After setRequiredNewCoreModules");
            }
            ModuleCtrl.disableNonExistingPackages(packageData, data);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "ChooseDirectory: After disableNonExistingPackages");
            }
            if (data.isUserInstallation()) {
                ModuleCtrl.setShowInUserInstallFlags(packageData);
                if (data.logModuleStates()) {
                    Dumper.logModuleStates(packageData, "ChooseDirectory: After setShowInUserInstallFlags");
                }
            } else {
                ModuleCtrl.setShowInUserInstallOnlyFlags(packageData);
                if (data.logModuleStates()) {
                    Dumper.logModuleStates(packageData, "ChooseDirectory: After setShowInUserInstallOnlyFlags");
                }
            }
            ModuleCtrl.setParentDefaultModuleSettings(packageData);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "ChooseDirectory: After setParentDefaultModuleSettings");
            }
            Vector installPackages = new Vector();
            PackageCollector.collectInstallPackages(packageData, installPackages);
            data.setInstallPackages(installPackages);
        } else {
            data.setTypicalSelectionStateSaved(false);
            data.setCustomSelectionStateSaved(false);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "analyzeDatabase: Start");
            }
            LogManager.setCommandsHeaderLine("Analyzing system database");
            ModuleCtrl.setDatabaseSettings(packageData, data, installer);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "analyzeDatabase: After setDatabaseSettings");
            }
            ModuleCtrl.disableNonExistingPackages(packageData, data);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "ChooseDirectory: After disableNonExistingPackages");
            }
            if (data.isUserInstallation()) {
                ModuleCtrl.setShowInUserInstallFlags(packageData);
                if (data.logModuleStates()) {
                    Dumper.logModuleStates(packageData, "ChooseDirectory: After setShowInUserInstallFlags");
                }
            } else {
                ModuleCtrl.setShowInUserInstallOnlyFlags(packageData);
                if (data.logModuleStates()) {
                    Dumper.logModuleStates(packageData, "ChooseDirectory: After setShowInUserInstallOnlyFlags");
                }
            }
            ModuleCtrl.setParentDefaultModuleSettings(packageData);
            if (data.logModuleStates()) {
                Dumper.logModuleStates(packageData, "ChooseDirectory: After setParentDefaultModuleSettings");
            }
        }
    }
}

