/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import java.io.Serializable;

public class NodeVector
implements Serializable,
Cloneable {
    static final long serialVersionUID = -713473092200731870L;
    private int m_blocksize;
    private int[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeVector() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeVector(int n) {
        this.m_blocksize = n;
        this.m_mapSize = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeVector nodeVector = (NodeVector)super.clone();
        if (null != this.m_map && this.m_map == nodeVector.m_map) {
            nodeVector.m_map = new int[this.m_map.length];
            System.arraycopy(this.m_map, 0, nodeVector.m_map, 0, this.m_map.length);
        }
        return nodeVector;
    }

    public int size() {
        return this.m_firstFree;
    }

    public void addElement(int n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] nArray = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
                this.m_map = nArray;
            }
        }
        this.m_map[this.m_firstFree] = n;
        ++this.m_firstFree;
    }

    public final void push(int n) {
        int n2 = this.m_firstFree;
        if (n2 + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] nArray = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nArray, 0, n2 + 1);
                this.m_map = nArray;
            }
        }
        this.m_map[n2] = n;
        this.m_firstFree = ++n2;
    }

    public final int pop() {
        --this.m_firstFree;
        int n = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = -1;
        return n;
    }

    public final int popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
        return this.m_firstFree == 0 ? -1 : this.m_map[this.m_firstFree - 1];
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
    }

    public final int peepOrNull() {
        return null != this.m_map && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : -1;
    }

    public final void pushPair(int n, int n2) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree);
            this.m_map = nArray;
        }
        this.m_map[this.m_firstFree] = n;
        this.m_map[this.m_firstFree + 1] = n2;
        this.m_firstFree += 2;
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = -1;
        this.m_map[this.m_firstFree + 1] = -1;
    }

    public final void setTail(int n) {
        this.m_map[this.m_firstFree - 1] = n;
    }

    public final void setTailSub1(int n) {
        this.m_map[this.m_firstFree - 2] = n;
    }

    public final int peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final int peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public void insertInOrder(int n) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (n >= this.m_map[i]) continue;
            this.insertElementAt(n, i);
            return;
        }
        this.addElement(n);
    }

    public void insertElementAt(int n, int n2) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (n2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n2, this.m_map, n2 + 1, this.m_firstFree - n2);
        }
        this.m_map[n2] = n;
        ++this.m_firstFree;
    }

    public void appendNodes(NodeVector nodeVector) {
        int n = nodeVector.size();
        if (null == this.m_map) {
            this.m_mapSize = n + this.m_blocksize;
            this.m_map = new int[this.m_mapSize];
        } else if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += n + this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + n);
            this.m_map = nArray;
        }
        System.arraycopy(nodeVector.m_map, 0, this.m_map, this.m_firstFree, n);
        this.m_firstFree += n;
    }

    public void removeAllElements() {
        if (null == this.m_map) {
            return;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            this.m_map[i] = -1;
        }
        this.m_firstFree = 0;
    }

    public void RemoveAllNoClear() {
        if (null == this.m_map) {
            return;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(int n) {
        if (null == this.m_map) {
            return false;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            int n2 = this.m_map[i];
            if (n2 != n) continue;
            if (i > this.m_firstFree) {
                System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
            } else {
                this.m_map[i] = -1;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public void removeElementAt(int n) {
        if (null == this.m_map) {
            return;
        }
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n - 1, this.m_firstFree - n);
        } else {
            this.m_map[n] = -1;
        }
    }

    public void setElementAt(int n, int n2) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        if (n2 == -1) {
            this.addElement(n);
        }
        this.m_map[n2] = n;
    }

    public int elementAt(int n) {
        if (null == this.m_map) {
            return -1;
        }
        return this.m_map[n];
    }

    public boolean contains(int n) {
        if (null == this.m_map) {
            return false;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            int n2 = this.m_map[i];
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int n, int n2) {
        if (null == this.m_map) {
            return -1;
        }
        for (int i = n2; i < this.m_firstFree; ++i) {
            int n3 = this.m_map[i];
            if (n3 != n) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int n) {
        if (null == this.m_map) {
            return -1;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            int n2 = this.m_map[i];
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    public void sort(int[] nArray, int n, int n2) throws Exception {
        int n3 = n;
        int n4 = n2;
        if (n3 >= n4) {
            return;
        }
        if (n3 == n4 - 1) {
            if (nArray[n3] > nArray[n4]) {
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
            }
            return;
        }
        int n6 = nArray[(n3 + n4) / 2];
        nArray[(n3 + n4) / 2] = nArray[n4];
        nArray[n4] = n6;
        while (n3 < n4) {
            while (nArray[n3] <= n6 && n3 < n4) {
                ++n3;
            }
            while (n6 <= nArray[n4] && n3 < n4) {
                --n4;
            }
            if (n3 >= n4) continue;
            int n7 = nArray[n3];
            nArray[n3] = nArray[n4];
            nArray[n4] = n7;
        }
        nArray[n2] = nArray[n4];
        nArray[n4] = n6;
        this.sort(nArray, n, n3 - 1);
        this.sort(nArray, n4 + 1, n2);
    }

    public void sort() throws Exception {
        this.sort(this.m_map, 0, this.m_firstFree - 1);
    }
}

