/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.socket;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.socket.UnixDomainSocketException;
import com.sun.deploy.net.socket.UnixSocketException;
import com.sun.deploy.net.socket.UnixSocketImpl;
import java.io.File;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UnixDomainSocket {
    public static final String pipeFileNamePrefix = ".com.sun.deploy.net.socket.";
    public static final String pipeFileNameSuffix = ".AF_UNIX";
    public static final int STATUS_CLOSE = 0;
    public static final int STATUS_OPEN = 1;
    public static final int STATUS_CONNECT = 2;
    public static final int STATUS_BIND = 3;
    public static final int STATUS_LISTEN = 4;
    public static final int STATUS_ACCEPT = 5;
    private volatile int socketStatus;
    private volatile long socketHandle;
    private volatile boolean unlinkFile;
    private String fileName;
    private boolean abstractNamespace;
    private int protocol;
    private int backlog;
    private static ShutdownHookUnlinkFiles shutdownHookUnlinkFiles;
    private static final boolean isConfigValid;

    public static boolean isSupported() {
        return UnixSocketImpl.unStreamSocketSupported();
    }

    public static UnixDomainSocket CreateClientConnect(String string, boolean bl, int n) throws UnixDomainSocketException, UnsupportedOperationException {
        UnixDomainSocket unixDomainSocket = new UnixDomainSocket(string, bl, n);
        unixDomainSocket.connect();
        return unixDomainSocket;
    }

    public static UnixDomainSocket CreateServerBindListen(String string, boolean bl, int n, int n2) throws UnixDomainSocketException, UnsupportedOperationException {
        UnixDomainSocket unixDomainSocket = new UnixDomainSocket(string, bl, n);
        unixDomainSocket.bind();
        unixDomainSocket.listen(n2);
        return unixDomainSocket;
    }

    public static UnixDomainSocket CreateServerBindListen(int n, int n2) throws UnixDomainSocketException, UnsupportedOperationException {
        UnixDomainSocket unixDomainSocket = new UnixDomainSocket(n);
        unixDomainSocket.bind();
        unixDomainSocket.listen(n2);
        return unixDomainSocket;
    }

    public UnixDomainSocket(String string, boolean bl, int n) throws UnixDomainSocketException, UnsupportedOperationException {
        this.setup(string, false, n);
    }

    public UnixDomainSocket(int n) throws UnixDomainSocketException, UnsupportedOperationException {
        File file;
        long l = Config.getNativePID();
        String string = null;
        try {
            file = File.createTempFile(pipeFileNamePrefix + String.valueOf(l) + ".", pipeFileNameSuffix);
            string = file.getAbsolutePath();
            if (file.exists()) {
                file.delete();
            } else {
                string = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = null;
        }
        if (string == null) {
            try {
                string = new String("/tmp/.com.sun.deploy.net.socket." + String.valueOf(l) + pipeFileNameSuffix);
                file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string = null;
            }
        }
        if (string == null) {
            throw new RuntimeException("could not create a temp pipe filename");
        }
        this.setup(string, false, n);
    }

    public synchronized void open() throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(1);
        this.socketHandle = UnixSocketImpl.unStreamSocketCreate(this.fileName, this.abstractNamespace, this.protocol);
        this.socketStatus = 1;
    }

    public void close() {
        this.socketStatus = 0;
        if (0L != this.socketHandle) {
            long l = this.socketHandle;
            this.socketHandle = 0L;
            try {
                UnixSocketImpl.unStreamSocketClose(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.unlinkFile) {
            try {
                File file = new File(this.fileName);
                if (null != file) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.backlog = 0;
    }

    public void deleteFileOnClose() {
        if (!this.unlinkFile && !this.abstractNamespace) {
            this.unlinkFile = true;
            shutdownHookUnlinkFiles.add(this.fileName);
        }
    }

    public synchronized void bind() throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(3);
        UnixSocketImpl.unStreamSocketBind(this.socketHandle);
        this.socketStatus = 3;
        this.deleteFileOnClose();
    }

    public synchronized void listen(int n) throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(4);
        UnixSocketImpl.unStreamSocketListen(this.socketHandle, n);
        this.backlog = n;
        this.socketStatus = 4;
    }

    public UnixDomainSocket accept() throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(5);
        long l = UnixSocketImpl.unStreamSocketAccept(this.socketHandle);
        this.socketStatus = 5;
        return new UnixDomainSocket(this, l, 2);
    }

    public void connect() throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(2);
        UnixSocketImpl.unStreamSocketConnect(this.socketHandle);
        this.socketStatus = 2;
    }

    public int read(ByteBuffer byteBuffer) throws UnixDomainSocketException, BufferOverflowException, UnsupportedOperationException {
        return this.read(byteBuffer, byteBuffer.remaining());
    }

    public int read(ByteBuffer byteBuffer, int n) throws UnixDomainSocketException, BufferOverflowException, UnsupportedOperationException {
        int n2;
        this.validateSocketStatusForReadWrite();
        if (null == byteBuffer) {
            throw new IllegalArgumentException("Argument buffer is null");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Argument buffer is not direct");
        }
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.position();
        if (n4 >= n3) {
            throw new BufferOverflowException();
        }
        if (n4 + n > n3) {
            n = n3 - n4;
        }
        if ((n2 = UnixSocketImpl.unStreamSocketRead(this.socketHandle, byteBuffer, n4, n)) > 0) {
            byteBuffer.position(n4 + n2);
        }
        return n2;
    }

    public int write(ByteBuffer byteBuffer) throws UnixDomainSocketException, BufferUnderflowException, UnsupportedOperationException {
        return this.write(byteBuffer, byteBuffer.remaining());
    }

    public int write(ByteBuffer byteBuffer, int n) throws UnixDomainSocketException, BufferUnderflowException, UnsupportedOperationException {
        int n2;
        this.validateSocketStatusForReadWrite();
        if (null == byteBuffer) {
            throw new IllegalArgumentException("Argument buffer is null");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Argument buffer is not direct");
        }
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.position();
        if (n4 >= n3) {
            throw new BufferUnderflowException();
        }
        if (n4 + n > n3) {
            n = n3 - n4;
        }
        if ((n2 = UnixSocketImpl.unStreamSocketWrite(this.socketHandle, byteBuffer, n4, n)) > 0) {
            byteBuffer.position(n4 + n2);
        }
        return n2;
    }

    public synchronized boolean isOpenAndValid() throws UnsupportedOperationException {
        boolean bl = false;
        if (0L != this.socketHandle && this.socketStatus != 0) {
            try {
                bl = UnixSocketImpl.unStreamSocketIsValid(this.socketHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.socketStatus = 0;
        }
        return bl;
    }

    public boolean isOpen() {
        return this.socketStatus != 0;
    }

    public boolean isConnected() {
        return this.socketStatus != 2;
    }

    public String getFilename() {
        return this.fileName;
    }

    public boolean getIsAbstractNamespace() {
        return this.abstractNamespace;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getStatus() {
        return this.socketStatus;
    }

    public String getStatusAsString() {
        switch (this.socketStatus) {
            case 0: {
                return "close";
            }
            case 1: {
                return "open";
            }
            case 2: {
                return "connect";
            }
            case 3: {
                return "bind";
            }
            case 4: {
                return "listen";
            }
            case 5: {
                return "accept";
            }
        }
        return "invalid";
    }

    public boolean isServer() {
        switch (this.socketStatus) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public String getNativeInfo() {
        String string = "n.a.";
        if (0L != this.socketHandle) {
            try {
                string = UnixSocketImpl.unStreamSocketGetNativeInfo(this.socketHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public String toString() {
        return "UnixDomainSocket[" + this.getStatusAsString() + ", pipe: " + this.getFilename() + ", ans: " + this.getIsAbstractNamespace() + ", proto: " + this.getProtocol() + ", backlog: " + this.getBacklog() + ", info: " + this.getNativeInfo() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void setup(String string, boolean bl, int n) throws UnixDomainSocketException, UnsupportedOperationException {
        if (null == string) {
            throw new IllegalArgumentException("Argument fileName is null");
        }
        this.socketHandle = 0L;
        this.fileName = string;
        this.abstractNamespace = bl;
        this.protocol = n;
        this.backlog = 0;
        this.socketStatus = 0;
        this.open();
    }

    private UnixDomainSocket(UnixDomainSocket unixDomainSocket, long l, int n) {
        this.socketHandle = l;
        this.fileName = unixDomainSocket.fileName;
        this.abstractNamespace = unixDomainSocket.abstractNamespace;
        this.protocol = unixDomainSocket.protocol;
        this.backlog = 0;
        this.socketStatus = n;
    }

    private void validateSocketStatusTransition(int n) throws UnixDomainSocketException {
        if (0L == this.socketHandle && 0 != this.socketStatus) {
            throw new UnixDomainSocketException(this.toString(), UnixSocketException.EINVAL);
        }
        switch (n) {
            case 1: {
                if (this.socketStatus != 0) break;
                return;
            }
            case 2: 
            case 3: {
                if (this.socketStatus != 1) break;
                return;
            }
            case 4: {
                if (this.socketStatus != 3) break;
                return;
            }
            case 5: {
                if (this.socketStatus != 4 && this.socketStatus != 5) break;
                return;
            }
        }
        throw new UnixDomainSocketException(this.toString(), UnixSocketException.EINVAL);
    }

    private void validateSocketStatusForReadWrite() throws UnixDomainSocketException {
        if (0L != this.socketHandle && 2 == this.socketStatus) {
            return;
        }
        throw new UnixDomainSocketException(this.toString(), UnixSocketException.EINVAL);
    }

    static {
        isConfigValid = Config.isConfigValid();
        shutdownHookUnlinkFiles = new ShutdownHookUnlinkFiles();
        Runtime.getRuntime().addShutdownHook(shutdownHookUnlinkFiles);
    }

    private static class ShutdownHookUnlinkFiles
    extends Thread {
        private List files = new ArrayList();

        public synchronized void add(String string) {
            try {
                File file = new File(string);
                this.files.add(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            Iterator iterator = this.files.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                try {
                    if (null == file) continue;
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

