/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import java.util.NoSuchElementException;
import java.util.Vector;

class LineTokenizer {
    private int currentPosition = 0;
    private int maxPosition;
    private String str;
    private Vector stack = new Vector();
    private static final String singles = "=";

    public LineTokenizer(String string) {
        this.str = string;
        this.maxPosition = string.length();
    }

    private void skipWhiteSpace() {
        while (this.currentPosition < this.maxPosition && Character.isWhitespace(this.str.charAt(this.currentPosition))) {
            ++this.currentPosition;
        }
    }

    public boolean hasMoreTokens() {
        if (this.stack.size() > 0) {
            return true;
        }
        this.skipWhiteSpace();
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() {
        int n;
        char c;
        int n2 = this.stack.size();
        if (n2 > 0) {
            String string = (String)this.stack.elementAt(n2 - 1);
            this.stack.removeElementAt(n2 - 1);
            return string;
        }
        this.skipWhiteSpace();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        if ((c = this.str.charAt(n = this.currentPosition++)) == '\"') {
            boolean bl = false;
            while (this.currentPosition < this.maxPosition) {
                String string;
                if ((c = this.str.charAt(this.currentPosition++)) == '\\') {
                    ++this.currentPosition;
                    bl = true;
                    continue;
                }
                if (c != '\"') continue;
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = n + 1; i < this.currentPosition - 1; ++i) {
                        c = this.str.charAt(i);
                        if (c == '\\') continue;
                        stringBuffer.append(c);
                    }
                    string = stringBuffer.toString();
                } else {
                    string = this.str.substring(n + 1, this.currentPosition - 1);
                }
                return string;
            }
        } else if (singles.indexOf(c) >= 0) {
            ++this.currentPosition;
        } else {
            while (this.currentPosition < this.maxPosition && singles.indexOf(this.str.charAt(this.currentPosition)) < 0 && !Character.isWhitespace(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
        }
        return this.str.substring(n, this.currentPosition);
    }

    public void pushToken(String string) {
        this.stack.addElement(string);
    }
}

