/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.CausedFocusEvent;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.SunToolkit;
import sun.awt.WindowIDProvider;
import sun.awt.motif.GrabbedKey;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MEmbeddedFramePeer;
import sun.awt.motif.MWindowPeer;

public class MEmbedCanvasPeer
extends MCanvasPeer
implements WindowFocusListener,
KeyEventPostProcessor,
ModalityListener,
WindowIDProvider {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.motif.xembed.MEmbedCanvasPeer");
    static final int XEMBED_VERSION = 0;
    static final int XEMBED_MAPPED = 1;
    static final int XEMBED_EMBEDDED_NOTIFY = 0;
    static final int XEMBED_WINDOW_ACTIVATE = 1;
    static final int XEMBED_WINDOW_DEACTIVATE = 2;
    static final int XEMBED_REQUEST_FOCUS = 3;
    static final int XEMBED_FOCUS_IN = 4;
    static final int XEMBED_FOCUS_OUT = 5;
    static final int XEMBED_FOCUS_NEXT = 6;
    static final int XEMBED_FOCUS_PREV = 7;
    static final int XEMBED_GRAB_KEY = 8;
    static final int XEMBED_UNGRAB_KEY = 9;
    static final int XEMBED_MODALITY_ON = 10;
    static final int XEMBED_MODALITY_OFF = 11;
    static final int XEMBED_REGISTER_ACCELERATOR = 12;
    static final int XEMBED_UNREGISTER_ACCELERATOR = 13;
    static final int XEMBED_ACTIVATE_ACCELERATOR = 14;
    static final int NON_STANDARD_XEMBED_GTK_GRAB_KEY = 108;
    static final int NON_STANDARD_XEMBED_GTK_UNGRAB_KEY = 109;
    static final int XEMBED_FOCUS_CURRENT = 0;
    static final int XEMBED_FOCUS_FIRST = 1;
    static final int XEMBED_FOCUS_LAST = 2;
    static final int XEMBED_MODIFIER_SHIFT = 1;
    static final int XEMBED_MODIFIER_CONTROL = 2;
    static final int XEMBED_MODIFIER_ALT = 4;
    static final int XEMBED_MODIFIER_SUPER = 8;
    static final int XEMBED_MODIFIER_HYPER = 16;
    boolean applicationActive;
    Map<Long, AWTKeyStroke> accelerators = new HashMap<Long, AWTKeyStroke>();
    Map<AWTKeyStroke, Long> accel_lookup = new HashMap<AWTKeyStroke, Long>();
    Set<GrabbedKey> grabbed_keys = new HashSet<GrabbedKey>();
    Object ACCEL_LOCK = this.accelerators;
    Object GRAB_LOCK = this.grabbed_keys;

    MEmbedCanvasPeer() {
    }

    MEmbedCanvasPeer(Component component) {
        super(component);
    }

    void initialize() {
        super.initialize();
        this.installActivateListener();
        this.installAcceleratorListener();
        this.installModalityListener();
        this.target.setFocusTraversalKeysEnabled(false);
        this.initXEmbedServer();
    }

    void installModalityListener() {
        ((SunToolkit)Toolkit.getDefaultToolkit()).addModalityListener(this);
    }

    void deinstallModalityListener() {
        ((SunToolkit)Toolkit.getDefaultToolkit()).removeModalityListener(this);
    }

    void installAcceleratorListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this);
    }

    void deinstallAcceleratorListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this);
    }

    void installActivateListener() {
        Window window = this.getTopLevel(this.target);
        if (window != null) {
            window.addWindowFocusListener(this);
            this.applicationActive = window.isFocused();
        }
    }

    void deinstallActivateListener() {
        Window window = this.getTopLevel(this.target);
        if (window != null) {
            window.removeWindowFocusListener(this);
        }
    }

    native boolean isXEmbedActive();

    boolean isApplicationActive() {
        return this.applicationActive;
    }

    native void initDispatching();

    native void endDispatching();

    native void embedChild(long var1);

    native void childDestroyed();

    public void handleEvent(AWTEvent aWTEvent) {
        super.handleEvent(aWTEvent);
        if (this.isXEmbedActive()) {
            switch (aWTEvent.getID()) {
                case 1004: {
                    this.canvasFocusGained((FocusEvent)aWTEvent);
                    break;
                }
                case 1005: {
                    this.canvasFocusLost((FocusEvent)aWTEvent);
                    break;
                }
                case 401: 
                case 402: {
                    if (((InputEvent)aWTEvent).isConsumed()) break;
                    this.forwardKeyEvent((KeyEvent)aWTEvent);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.isXEmbedActive()) {
            Dimension dimension = this.getEmbedPreferredSize();
            if (dimension == null) {
                return super.getPreferredSize();
            }
            return dimension;
        }
        return super.getPreferredSize();
    }

    native Dimension getEmbedPreferredSize();

    public Dimension getMinimumSize() {
        if (this.isXEmbedActive()) {
            Dimension dimension = this.getEmbedMinimumSize();
            if (dimension == null) {
                return super.getMinimumSize();
            }
            return dimension;
        }
        return super.getMinimumSize();
    }

    native Dimension getEmbedMinimumSize();

    protected void disposeImpl() {
        if (this.isXEmbedActive()) {
            this.detachChild();
        }
        this.deinstallActivateListener();
        this.deinstallModalityListener();
        this.deinstallAcceleratorListener();
        this.destroyXEmbedServer();
        super.disposeImpl();
    }

    public boolean isFocusable() {
        return true;
    }

    Window getTopLevel(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    native Rectangle getClientBounds();

    void childResized() {
        if (xembedLog.isLoggable(Level.FINER)) {
            Rectangle rectangle = this.getClientBounds();
            xembedLog.finer("Child resized: " + rectangle);
        }
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    void focusNext() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for the next component after embedder");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                public void run() {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(MEmbedCanvasPeer.this.target);
                }
            }));
        } else {
            xembedLog.fine("Application is not active - denying focus next");
        }
    }

    void focusPrev() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for the next component after embedder");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                public void run() {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(MEmbedCanvasPeer.this.target);
                }
            }));
        } else {
            xembedLog.fine("Application is not active - denying focus prev");
        }
    }

    void requestXEmbedFocus() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for client");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                public void run() {
                    MEmbedCanvasPeer.this.target.requestFocusInWindow();
                }
            }));
        } else {
            xembedLog.fine("Application is not active - denying request focus");
        }
    }

    native void notifyChildEmbedded();

    native void detachChild();

    public void windowGainedFocus(WindowEvent windowEvent) {
        this.applicationActive = true;
        if (this.isXEmbedActive()) {
            xembedLog.fine("Sending WINDOW_ACTIVATE");
            this.sendMessage(1);
        }
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        this.applicationActive = false;
        if (this.isXEmbedActive()) {
            xembedLog.fine("Sending WINDOW_DEACTIVATE");
            this.sendMessage(2);
        }
    }

    void canvasFocusGained(FocusEvent focusEvent) {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Forwarding FOCUS_GAINED");
            int n = 0;
            if (focusEvent instanceof CausedFocusEvent) {
                CausedFocusEvent causedFocusEvent = (CausedFocusEvent)focusEvent;
                if (causedFocusEvent.getCause() == CausedFocusEvent.Cause.TRAVERSAL_FORWARD) {
                    n = 1;
                } else if (causedFocusEvent.getCause() == CausedFocusEvent.Cause.TRAVERSAL_BACKWARD) {
                    n = 2;
                }
            }
            this.sendMessage(4, n, 0L, 0L);
        }
    }

    void canvasFocusLost(FocusEvent focusEvent) {
        if (this.isXEmbedActive() && !focusEvent.isTemporary()) {
            xembedLog.fine("Forwarding FOCUS_LOST");
            Component component = focusEvent.getOppositeComponent();
            int n = 0;
            try {
                n = Integer.parseInt(component.getName());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.sendMessage(5, n, 0L, 0L);
        }
    }

    native void forwardKeyEvent(KeyEvent var1);

    void grabKey(final long l, final long l2) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GrabbedKey grabbedKey = new GrabbedKey(l, l2);
                if (xembedLog.isLoggable(Level.FINE)) {
                    xembedLog.fine("Grabbing key: " + grabbedKey);
                }
                Object object = MEmbedCanvasPeer.this.GRAB_LOCK;
                synchronized (object) {
                    MEmbedCanvasPeer.this.grabbed_keys.add(grabbedKey);
                }
            }
        }));
    }

    void ungrabKey(final long l, final long l2) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GrabbedKey grabbedKey = new GrabbedKey(l, l2);
                if (xembedLog.isLoggable(Level.FINE)) {
                    xembedLog.fine("UnGrabbing key: " + grabbedKey);
                }
                Object object = MEmbedCanvasPeer.this.GRAB_LOCK;
                synchronized (object) {
                    MEmbedCanvasPeer.this.grabbed_keys.remove(grabbedKey);
                }
            }
        }));
    }

    void registerAccelerator(final long l, final long l2, final long l3) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AWTKeyStroke aWTKeyStroke = MEmbedCanvasPeer.this.getKeyStrokeForKeySym(l2, l3);
                if (aWTKeyStroke != null) {
                    if (xembedLog.isLoggable(Level.FINE)) {
                        xembedLog.fine("Registering accelerator " + l + " for " + aWTKeyStroke);
                    }
                    Object object = MEmbedCanvasPeer.this.ACCEL_LOCK;
                    synchronized (object) {
                        MEmbedCanvasPeer.this.accelerators.put(l, aWTKeyStroke);
                        MEmbedCanvasPeer.this.accel_lookup.put(aWTKeyStroke, l);
                    }
                }
                MEmbedCanvasPeer.this.propogateRegisterAccelerator(aWTKeyStroke);
            }
        }));
    }

    void unregisterAccelerator(final long l) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AWTKeyStroke aWTKeyStroke = null;
                Object object = MEmbedCanvasPeer.this.ACCEL_LOCK;
                synchronized (object) {
                    aWTKeyStroke = MEmbedCanvasPeer.this.accelerators.get(l);
                    if (aWTKeyStroke != null) {
                        if (xembedLog.isLoggable(Level.FINE)) {
                            xembedLog.fine("Unregistering accelerator: " + l);
                        }
                        MEmbedCanvasPeer.this.accelerators.remove(l);
                        MEmbedCanvasPeer.this.accel_lookup.remove(aWTKeyStroke);
                    }
                }
                MEmbedCanvasPeer.this.propogateUnRegisterAccelerator(aWTKeyStroke);
            }
        }));
    }

    void propogateRegisterAccelerator(AWTKeyStroke aWTKeyStroke) {
        MWindowPeer mWindowPeer = this.getParentWindow();
        if (mWindowPeer != null && mWindowPeer instanceof MEmbeddedFramePeer) {
            MEmbeddedFramePeer mEmbeddedFramePeer = (MEmbeddedFramePeer)mWindowPeer;
            mEmbeddedFramePeer.registerAccelerator(aWTKeyStroke);
        }
    }

    void propogateUnRegisterAccelerator(AWTKeyStroke aWTKeyStroke) {
        MWindowPeer mWindowPeer = this.getParentWindow();
        if (mWindowPeer != null && mWindowPeer instanceof MEmbeddedFramePeer) {
            MEmbeddedFramePeer mEmbeddedFramePeer = (MEmbeddedFramePeer)mWindowPeer;
            mEmbeddedFramePeer.unregisterAccelerator(aWTKeyStroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        MWindowPeer mWindowPeer = this.getParentWindow();
        if (mWindowPeer == null || !((Window)mWindowPeer.target).isFocused() || this.target.isFocusOwner()) {
            return false;
        }
        boolean bl = false;
        if (xembedLog.isLoggable(Level.FINER)) {
            xembedLog.finer("Post-processing event " + keyEvent);
        }
        AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
        long l = 0L;
        boolean bl2 = false;
        Object object = this.ACCEL_LOCK;
        synchronized (object) {
            bl2 = this.accel_lookup.containsKey(aWTKeyStroke);
            if (bl2) {
                l = this.accel_lookup.get(aWTKeyStroke);
            }
        }
        if (bl2) {
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Activating accelerator " + l);
            }
            this.sendMessage(14, l, 0L, 0L);
            bl = true;
        }
        bl2 = false;
        object = new GrabbedKey(keyEvent);
        Object object2 = this.GRAB_LOCK;
        synchronized (object2) {
            bl2 = this.grabbed_keys.contains(object);
        }
        if (bl2) {
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Forwarding grabbed key " + keyEvent);
            }
            this.forwardKeyEvent(keyEvent);
            bl = true;
        }
        return bl;
    }

    public void modalityPushed(ModalityEvent modalityEvent) {
        this.sendMessage(10);
    }

    public void modalityPopped(ModalityEvent modalityEvent) {
        this.sendMessage(11);
    }

    int getModifiers(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 0x40;
        }
        if ((n & 2) != 0) {
            n2 |= 0x80;
        }
        if ((n & 4) != 0) {
            n2 |= 0x200;
        }
        if ((n & 8) != 0) {
            n2 |= 0x200;
        }
        return n2;
    }

    AWTKeyStroke getKeyStrokeForKeySym(long l, long l2) {
        int n = this.getAWTKeyCodeForKeySym((int)l);
        int n2 = this.getModifiers((int)l2);
        return AWTKeyStroke.getAWTKeyStroke(n, n2);
    }

    native int getAWTKeyCodeForKeySym(int var1);

    native void sendMessage(int var1);

    native void sendMessage(int var1, long var2, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MWindowPeer getParentWindow() {
        Object object = this.target.getTreeLock();
        synchronized (object) {
            Container container;
            for (container = this.target.getParent(); container != null && !(container.getPeer() instanceof MWindowPeer); container = container.getParent()) {
            }
            return container != null ? (MWindowPeer)container.getPeer() : null;
        }
    }

    public void setXEmbedDropTarget() {
        Runnable runnable = new Runnable(){

            public void run() {
                MEmbedCanvasPeer.this.target.setDropTarget(new XEmbedDropTarget());
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, runnable);
    }

    public void removeXEmbedDropTarget() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (MEmbedCanvasPeer.this.target.getDropTarget() instanceof XEmbedDropTarget) {
                    MEmbedCanvasPeer.this.target.setDropTarget(null);
                }
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, runnable);
    }

    public boolean processXEmbedDnDEvent(long l, int n) {
        if (this.target.getDropTarget() instanceof XEmbedDropTarget) {
            this.forwardEventToEmbedded(l, n);
            return true;
        }
        return false;
    }

    native void forwardEventToEmbedded(long var1, int var3);

    native void initXEmbedServer();

    native void destroyXEmbedServer();

    public native long getWindow();

    private static class XEmbedDropTarget
    extends DropTarget {
        private XEmbedDropTarget() {
        }

        public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
            throw new TooManyListenersException();
        }
    }
}

