/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.client;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class RfcDateParser {
    private boolean isGMT = false;
    static final String[] standardFormats = new String[]{"EEEE', 'dd-MMM-yy HH:mm:ss z", "EEEE', 'dd-MMM-yy HH:mm:ss", "EEE', 'dd-MMM-yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy HH:mm:ss z", "EEEE', 'dd MMM yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy hh:mm:ss z", "EEEE', 'dd MMM yyyy hh:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE MMM dd HH:mm:ss yyyy", "EEE', 'dd-MMM-yy HH:mm:ss", "EEE', 'dd-MMM-yyyy HH:mm:ss"};
    static final String[] gmtStandardFormats = new String[]{"EEEE',' dd-MMM-yy HH:mm:ss 'GMT'", "EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy hh:mm:ss 'GMT'", "EEEE',' dd MMM yyyy hh:mm:ss 'GMT'", "EEE MMM dd HH:mm:ss 'GMT' yyyy"};
    String dateString;

    public RfcDateParser(String string) {
        this.dateString = string.trim();
        if (this.dateString.indexOf("GMT") != -1) {
            this.isGMT = true;
        }
    }

    public Date getDate() {
        int n = this.isGMT ? gmtStandardFormats.length : standardFormats.length;
        for (int i = 0; i < n; ++i) {
            Date date = this.isGMT ? this.tryParsing(gmtStandardFormats[i]) : this.tryParsing(standardFormats[i]);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    private Date tryParsing(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.US);
        if (this.isGMT) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        try {
            return simpleDateFormat.parse(this.dateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

