/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class GrayFilter
extends RGBImageFilter {
    private boolean brighter;
    private int percent;

    public static Image createDisabledImage(Image image) {
        GrayFilter grayFilter = new GrayFilter(true, 50);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), grayFilter);
        Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        return image2;
    }

    public GrayFilter(boolean bl, int n) {
        this.brighter = bl;
        this.percent = n;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = (int)((0.3 * (double)(n3 >> 16 & 0xFF) + 0.59 * (double)(n3 >> 8 & 0xFF) + 0.11 * (double)(n3 & 0xFF)) / 3.0);
        n4 = this.brighter ? 255 - (255 - n4) * (100 - this.percent) / 100 : n4 * (100 - this.percent) / 100;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        return n3 & 0xFF000000 | n4 << 16 | n4 << 8 | n4 << 0;
    }
}

