/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = System.nanoTime();

    final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    private void delayedExecute(Runnable runnable) {
        if (this.isShutdown()) {
            this.reject(runnable);
            return;
        }
        if (this.getPoolSize() < this.getCorePoolSize()) {
            this.prestartCoreThread();
        }
        super.getQueue().add(runnable);
    }

    private void cancelUnwantedTasks() {
        boolean bl = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean bl2 = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!bl && !bl2) {
            super.getQueue().clear();
        } else if (bl || bl2) {
            Object[] objectArray = super.getQueue().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                RunnableScheduledFuture runnableScheduledFuture;
                Object object = objectArray[i];
                if (!(object instanceof RunnableScheduledFuture) || !((runnableScheduledFuture = (RunnableScheduledFuture)object).isPeriodic() ? !bl2 : !bl)) continue;
                runnableScheduledFuture.cancel(false);
            }
            objectArray = null;
            this.purge();
        }
    }

    @Override
    public boolean remove(Runnable runnable) {
        if (!(runnable instanceof RunnableScheduledFuture)) {
            return false;
        }
        return this.getQueue().remove(runnable);
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    public ScheduledThreadPoolExecutor(int n) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
    }

    public ScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int n, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), rejectedExecutionHandler);
    }

    private long triggerTime(long l, TimeUnit timeUnit) {
        return this.triggerTime(timeUnit.toNanos(l < 0L ? 0L : l));
    }

    long triggerTime(long l) {
        return this.now() + (l < 0x3FFFFFFFFFFFFFFFL ? l : this.overflowFree(l));
    }

    private long overflowFree(long l) {
        long l2;
        Delayed delayed = (Delayed)super.getQueue().peek();
        if (delayed != null && (l2 = delayed.getDelay(TimeUnit.NANOSECONDS)) < 0L && l - l2 < 0L) {
            l = Long.MAX_VALUE + l2;
        }
        return l;
    }

    public ScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, rejectedExecutionHandler);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, new ScheduledFutureTask<Object>(runnable, null, this.triggerTime(l, timeUnit)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        if (callable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<V> runnableScheduledFuture = this.decorateTask(callable, new ScheduledFutureTask<V>(callable, this.triggerTime(l, timeUnit)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, new ScheduledFutureTask<Object>(runnable, null, this.triggerTime(l, timeUnit), timeUnit.toNanos(l2)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, new ScheduledFutureTask<Object>(runnable, null, this.triggerTime(l, timeUnit), timeUnit.toNanos(-l2)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.schedule(Executors.callable(runnable, t), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.schedule(callable, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean bl) {
        this.continueExistingPeriodicTasksAfterShutdown = bl;
        if (!bl && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean bl) {
        this.executeExistingDelayedTasksAfterShutdown = bl;
        if (!bl && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    @Override
    public void shutdown() {
        this.cancelUnwantedTasks();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelayedWorkQueue
    extends AbstractCollection<Runnable>
    implements BlockingQueue<Runnable> {
        private final DelayQueue<RunnableScheduledFuture> dq = new DelayQueue();

        private DelayedWorkQueue() {
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.dq.poll();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.dq.peek();
        }

        @Override
        public Runnable take() throws InterruptedException {
            return (Runnable)this.dq.take();
        }

        @Override
        public Runnable poll(long l, TimeUnit timeUnit) throws InterruptedException {
            return (Runnable)this.dq.poll(l, timeUnit);
        }

        @Override
        public boolean add(Runnable runnable) {
            return this.dq.add((RunnableScheduledFuture)runnable);
        }

        @Override
        public boolean offer(Runnable runnable) {
            return this.dq.offer((RunnableScheduledFuture)runnable);
        }

        @Override
        public void put(Runnable runnable) {
            this.dq.put((RunnableScheduledFuture)runnable);
        }

        @Override
        public boolean offer(Runnable runnable, long l, TimeUnit timeUnit) {
            return this.dq.offer((RunnableScheduledFuture)runnable, l, timeUnit);
        }

        @Override
        public Runnable remove() {
            return (Runnable)this.dq.remove();
        }

        @Override
        public Runnable element() {
            return (Runnable)this.dq.element();
        }

        @Override
        public void clear() {
            this.dq.clear();
        }

        @Override
        public int drainTo(Collection<? super Runnable> collection) {
            return this.dq.drainTo(collection);
        }

        @Override
        public int drainTo(Collection<? super Runnable> collection, int n) {
            return this.dq.drainTo(collection, n);
        }

        @Override
        public int remainingCapacity() {
            return this.dq.remainingCapacity();
        }

        @Override
        public boolean remove(Object object) {
            return this.dq.remove(object);
        }

        @Override
        public boolean contains(Object object) {
            return this.dq.contains(object);
        }

        @Override
        public int size() {
            return this.dq.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dq.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.dq.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.dq.toArray(TArray);
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Iterator<Runnable>(){
                private Iterator<RunnableScheduledFuture> it;
                {
                    this.it = DelayedWorkQueue.this.dq.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Runnable next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        ScheduledFutureTask(Runnable runnable, V v, long l) {
            super(runnable, v);
            this.time = l;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable runnable, V v, long l, long l2) {
            super(runnable, v);
            this.time = l;
            this.period = l2;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long l) {
            super(callable);
            this.time = l;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (delayed == this) {
                return 0;
            }
            if (delayed instanceof ScheduledFutureTask) {
                ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)delayed;
                long l = this.time - scheduledFutureTask.time;
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < scheduledFutureTask.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long l = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
            return l == 0L ? 0 : (l < 0L ? -1 : 1);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void runPeriodic() {
            boolean bl = ScheduledFutureTask.super.runAndReset();
            boolean bl2 = ScheduledThreadPoolExecutor.this.isShutdown();
            if (bl && (!bl2 || ScheduledThreadPoolExecutor.this.getContinueExistingPeriodicTasksAfterShutdownPolicy() && !ScheduledThreadPoolExecutor.this.isStopped())) {
                long l = this.period;
                this.time = l > 0L ? (this.time += l) : ScheduledThreadPoolExecutor.this.triggerTime(-l);
                ScheduledThreadPoolExecutor.super.getQueue().add(this);
            } else if (bl2) {
                ScheduledThreadPoolExecutor.this.interruptIdleWorkers();
            }
        }

        @Override
        public void run() {
            if (this.isPeriodic()) {
                this.runPeriodic();
            } else {
                ScheduledFutureTask.super.run();
            }
        }
    }
}

