/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.misc.HexDumpEncoder;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.TokenTracker;
import sun.security.jgss.krb5.AcceptSecContextToken;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.InitSecContextToken;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.MessageToken;
import sun.security.jgss.krb5.MessageToken_v2;
import sun.security.jgss.krb5.MicToken;
import sun.security.jgss.krb5.MicToken_v2;
import sun.security.jgss.krb5.WrapToken;
import sun.security.jgss.krb5.WrapToken_v2;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

class Krb5Context
implements GSSContextSpi {
    private static final int STATE_NEW = 1;
    private static final int STATE_IN_PROCESS = 2;
    private static final int STATE_DONE = 3;
    private static final int STATE_DELETED = 4;
    private int state = 1;
    private boolean credDelegState = false;
    private boolean mutualAuthState = true;
    private boolean replayDetState = true;
    private boolean sequenceDetState = true;
    private boolean confState = true;
    private boolean integState = true;
    private int mySeqNumber;
    private int peerSeqNumber;
    private TokenTracker peerTokenTracker;
    private CipherHelper cipherHelper = null;
    private Object mySeqNumberLock = new Object();
    private Object peerSeqNumberLock = new Object();
    private EncryptionKey key;
    private Krb5NameElement myName;
    private Krb5NameElement peerName;
    private int lifetime;
    private boolean initiator;
    private ChannelBinding channelBinding;
    private Krb5CredElement myCred;
    private Krb5CredElement delegatedCred;
    private Cipher desCipher = null;
    private Credentials serviceCreds;
    private KrbApReq apReq;
    private final int caller;
    private static final boolean DEBUG = Krb5Util.DEBUG;

    Krb5Context(int n, Krb5NameElement krb5NameElement, Krb5CredElement krb5CredElement, int n2) throws GSSException {
        if (krb5NameElement == null) {
            throw new IllegalArgumentException("Cannot have null peer name");
        }
        this.caller = n;
        this.peerName = krb5NameElement;
        this.myCred = krb5CredElement;
        this.lifetime = n2;
        this.initiator = true;
    }

    Krb5Context(int n, Krb5CredElement krb5CredElement) throws GSSException {
        this.caller = n;
        this.myCred = krb5CredElement;
        this.initiator = false;
    }

    public Krb5Context(int n, byte[] byArray) throws GSSException {
        throw new GSSException(16, -1, "GSS Import Context not available");
    }

    public final boolean isTransferable() throws GSSException {
        return false;
    }

    public final int getLifetime() {
        return Integer.MAX_VALUE;
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.lifetime = n;
        }
    }

    public final void requestConf(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.confState = bl;
        }
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public final void requestInteg(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.integState = bl;
        }
    }

    public final boolean getIntegState() {
        return this.integState;
    }

    public final void requestCredDeleg(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.credDelegState = bl;
        }
    }

    public final boolean getCredDelegState() {
        return this.credDelegState;
    }

    public final void requestMutualAuth(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.mutualAuthState = bl;
        }
    }

    public final boolean getMutualAuthState() {
        return this.mutualAuthState;
    }

    public final void requestReplayDet(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.replayDetState = bl;
        }
    }

    public final boolean getReplayDetState() {
        return this.replayDetState || this.sequenceDetState;
    }

    public final void requestSequenceDet(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.sequenceDetState = bl;
        }
    }

    public final boolean getSequenceDetState() {
        return this.sequenceDetState || this.replayDetState;
    }

    public final void requestAnonymity(boolean bl) throws GSSException {
    }

    public final boolean getAnonymityState() {
        return false;
    }

    final CipherHelper getCipherHelper(EncryptionKey encryptionKey) throws GSSException {
        EncryptionKey encryptionKey2 = null;
        if (this.cipherHelper == null) {
            encryptionKey2 = this.getKey() == null ? encryptionKey : this.getKey();
            this.cipherHelper = new CipherHelper(encryptionKey2);
        }
        return this.cipherHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int incrementMySequenceNumber() {
        int n;
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            n = this.mySeqNumber;
            this.mySeqNumber = n + 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetMySequenceNumber(int n) {
        if (DEBUG) {
            System.out.println("Krb5Context setting mySeqNumber to: " + n);
        }
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            this.mySeqNumber = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetPeerSequenceNumber(int n) {
        if (DEBUG) {
            System.out.println("Krb5Context setting peerSeqNumber to: " + n);
        }
        Object object = this.peerSeqNumberLock;
        synchronized (object) {
            this.peerSeqNumber = n;
            this.peerTokenTracker = new TokenTracker(this.peerSeqNumber);
        }
    }

    final void setKey(EncryptionKey encryptionKey) throws GSSException {
        this.key = encryptionKey;
        this.cipherHelper = new CipherHelper(encryptionKey);
    }

    private final EncryptionKey getKey() {
        return this.key;
    }

    final void setDelegCred(Krb5CredElement krb5CredElement) {
        this.delegatedCred = krb5CredElement;
    }

    final void setCredDelegState(boolean bl) {
        this.credDelegState = bl;
    }

    final void setMutualAuthState(boolean bl) {
        this.mutualAuthState = bl;
    }

    final void setReplayDetState(boolean bl) {
        this.replayDetState = bl;
    }

    final void setSequenceDetState(boolean bl) {
        this.sequenceDetState = bl;
    }

    final void setConfState(boolean bl) {
        this.confState = bl;
    }

    final void setIntegState(boolean bl) {
        this.integState = bl;
    }

    public final void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.channelBinding = channelBinding;
    }

    final ChannelBinding getChannelBinding() {
        return this.channelBinding;
    }

    public final Oid getMech() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    public final GSSNameSpi getSrcName() throws GSSException {
        return this.isInitiator() ? this.myName : this.peerName;
    }

    public final GSSNameSpi getTargName() throws GSSException {
        return !this.isInitiator() ? this.myName : this.peerName;
    }

    public final GSSCredentialSpi getDelegCred() throws GSSException {
        if (this.state != 2 && this.state != 3) {
            throw new GSSException(12);
        }
        if (this.delegatedCred == null) {
            throw new GSSException(13);
        }
        return this.delegatedCred;
    }

    public final boolean isInitiator() {
        return this.initiator;
    }

    public final boolean isProtReady() {
        return this.state == 3;
    }

    public final byte[] initSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray;
        block27: {
            byArray = null;
            InitSecContextToken initSecContextToken = null;
            int n2 = 11;
            if (DEBUG) {
                System.out.println("Entered Krb5Context.initSecContext with state=" + Krb5Context.printState(this.state));
            }
            if (!this.isInitiator()) {
                throw new GSSException(11, -1, "initSecContext on an acceptor GSSContext");
            }
            try {
                if (this.state == 1) {
                    Serializable serializable;
                    this.state = 2;
                    n2 = 13;
                    if (this.myCred == null) {
                        this.myCred = Krb5InitCredential.getInstance(this.caller, this.myName, 0);
                    } else if (!this.myCred.isInitiatorCredential()) {
                        throw new GSSException(n2, -1, "No TGT available");
                    }
                    this.myName = (Krb5NameElement)this.myCred.getName();
                    Credentials credentials = ((Krb5InitCredential)this.myCred).getKrb5Credentials();
                    this.checkPermission(this.peerName.getKrb5PrincipalName().getName(), "initiate");
                    final AccessControlContext accessControlContext = AccessController.getContext();
                    if (GSSUtil.useSubjectCredsOnly()) {
                        block26: {
                            serializable = null;
                            try {
                                serializable = (KerberosTicket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        return Krb5Util.getTicket(-1, Krb5Context.this.myName.getKrb5PrincipalName().getName(), Krb5Context.this.peerName.getKrb5PrincipalName().getName(), accessControlContext);
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (!DEBUG) break block26;
                                System.out.println("Attempt to obtain service ticket from the subject failed!");
                            }
                        }
                        if (serializable != null) {
                            if (DEBUG) {
                                System.out.println("Found service ticket in the subject" + serializable);
                            }
                            this.serviceCreds = Krb5Util.ticketToCreds((KerberosTicket)serializable);
                        }
                    }
                    if (this.serviceCreds == null) {
                        if (DEBUG) {
                            System.out.println("Service ticket not found in the subject");
                        }
                        this.serviceCreds = Credentials.acquireServiceCreds(this.peerName.getKrb5PrincipalName().getName(), credentials);
                        if (GSSUtil.useSubjectCredsOnly()) {
                            serializable = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return Subject.getSubject(accessControlContext);
                                }
                            });
                            if (serializable != null && !((Subject)serializable).isReadOnly()) {
                                KerberosTicket kerberosTicket = Krb5Util.credsToTicket(this.serviceCreds);
                                AccessController.doPrivileged(new PrivilegedAction((Subject)serializable, kerberosTicket){
                                    final /* synthetic */ Subject val$subject;
                                    final /* synthetic */ KerberosTicket val$kt;
                                    {
                                        this.val$subject = subject;
                                        this.val$kt = kerberosTicket;
                                    }

                                    public Object run() {
                                        this.val$subject.getPrivateCredentials().add(this.val$kt);
                                        return null;
                                    }
                                });
                            } else if (DEBUG) {
                                System.out.println("Subject is readOnly;Kerberos Service ticket not stored");
                            }
                        }
                    }
                    n2 = 11;
                    initSecContextToken = new InitSecContextToken(this, credentials, this.serviceCreds);
                    this.apReq = initSecContextToken.getKrbApReq();
                    byArray = ((InitialToken)initSecContextToken).encode();
                    this.myCred = null;
                    if (!this.getMutualAuthState()) {
                        this.state = 3;
                    }
                    if (DEBUG) {
                        System.out.println("Created InitSecContextToken:\n" + new HexDumpEncoder().encodeBuffer(byArray));
                    }
                    break block27;
                }
                if (this.state == 2) {
                    new AcceptSecContextToken(this, this.serviceCreds, this.apReq, inputStream);
                    this.serviceCreds = null;
                    this.apReq = null;
                    this.state = 3;
                } else if (DEBUG) {
                    System.out.println(this.state);
                }
            }
            catch (KrbException krbException) {
                if (DEBUG) {
                    krbException.printStackTrace();
                }
                GSSException gSSException = new GSSException(n2, -1, krbException.getMessage());
                gSSException.initCause(krbException);
                throw gSSException;
            }
            catch (IOException iOException) {
                GSSException gSSException = new GSSException(n2, -1, iOException.getMessage());
                gSSException.initCause(iOException);
                throw gSSException;
            }
        }
        return byArray;
    }

    public final boolean isEstablished() {
        return this.state == 3;
    }

    public final byte[] acceptSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray = null;
        if (DEBUG) {
            System.out.println("Entered Krb5Context.acceptSecContext with state=" + Krb5Context.printState(this.state));
        }
        if (this.isInitiator()) {
            throw new GSSException(11, -1, "acceptSecContext on an initiator GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                if (this.myCred == null) {
                    this.myCred = Krb5AcceptCredential.getInstance(this.caller, this.myName);
                } else if (!this.myCred.isAcceptorCredential()) {
                    throw new GSSException(13, -1, "No Secret Key available");
                }
                this.myName = (Krb5NameElement)this.myCred.getName();
                this.checkPermission(this.myName.getKrb5PrincipalName().getName(), "accept");
                EncryptionKey[] encryptionKeyArray = ((Krb5AcceptCredential)this.myCred).getKrb5EncryptionKeys();
                InitSecContextToken initSecContextToken = new InitSecContextToken(this, encryptionKeyArray, inputStream);
                PrincipalName principalName = initSecContextToken.getKrbApReq().getClient();
                this.peerName = Krb5NameElement.getInstance(principalName);
                if (this.getMutualAuthState()) {
                    byArray = new AcceptSecContextToken(this, initSecContextToken.getKrbApReq()).encode();
                }
                this.myCred = null;
                this.state = 3;
            } else if (DEBUG) {
                System.out.println(this.state);
            }
        }
        catch (KrbException krbException) {
            GSSException gSSException = new GSSException(11, -1, krbException.getMessage());
            gSSException.initCause(krbException);
            throw gSSException;
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        return byArray;
    }

    public final int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        int n3 = 0;
        if (this.cipherHelper.getProto() == 0) {
            n3 = WrapToken.getSizeLimit(n, bl, n2, this.getCipherHelper(null));
        } else if (this.cipherHelper.getProto() == 1) {
            n3 = WrapToken_v2.getSizeLimit(n, bl, n2, this.getCipherHelper(null));
        }
        return n3;
    }

    public final byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (DEBUG) {
            System.out.println("Krb5Context.wrap: data=[" + Krb5Context.getHexBytes(byArray, n, n2) + "]");
        }
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        byte[] byArray2 = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n, n2);
                byArray2 = wrapToken.encode();
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, messageProp, byArray, n, n2);
                byArray2 = wrapToken_v2.encode();
            }
            if (DEBUG) {
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, 0, byArray2.length) + "]");
            }
            return byArray2;
        }
        catch (IOException iOException) {
            byArray2 = null;
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    public final int wrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        int n4 = 0;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n, n2);
                n4 = wrapToken.encode(byArray2, n3);
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, messageProp, byArray, n, n2);
                n4 = wrapToken_v2.encode(byArray2, n3);
            }
            if (DEBUG) {
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, n3, n4) + "]");
            }
            return n4;
        }
        catch (IOException iOException) {
            n4 = 0;
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    public final void wrap(byte[] byArray, int n, int n2, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        byte[] byArray2 = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n, n2);
                wrapToken.encode(outputStream);
                if (DEBUG) {
                    byArray2 = wrapToken.encode();
                }
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, messageProp, byArray, n, n2);
                wrapToken_v2.encode(outputStream);
                if (DEBUG) {
                    byArray2 = wrapToken_v2.encode();
                }
            }
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        if (DEBUG) {
            System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, 0, byArray2.length) + "]");
        }
    }

    public final void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        this.wrap(byArray, 0, byArray.length, outputStream, messageProp);
    }

    public final byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (DEBUG) {
            System.out.println("Krb5Context.unwrap: token=[" + Krb5Context.getHexBytes(byArray, n, n2) + "]");
        }
        if (this.state != 3) {
            throw new GSSException(12, -1, " Unwrap called in invalid state!");
        }
        byte[] byArray2 = null;
        if (this.cipherHelper.getProto() == 0) {
            WrapToken wrapToken = new WrapToken(this, byArray, n, n2, messageProp);
            byArray2 = wrapToken.getData();
            this.setSequencingAndReplayProps(wrapToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, byArray, n, n2, messageProp);
            byArray2 = wrapToken_v2.getData();
            this.setSequencingAndReplayProps(wrapToken_v2, messageProp);
        }
        if (DEBUG) {
            System.out.println("Krb5Context.unwrap: data=[" + Krb5Context.getHexBytes(byArray2, 0, byArray2.length) + "]");
        }
        return byArray2;
    }

    public final int unwrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        if (this.cipherHelper.getProto() == 0) {
            WrapToken wrapToken = new WrapToken(this, byArray, n, n2, messageProp);
            n2 = wrapToken.getData(byArray2, n3);
            this.setSequencingAndReplayProps(wrapToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, byArray, n, n2, messageProp);
            n2 = wrapToken_v2.getData(byArray2, n3);
            this.setSequencingAndReplayProps(wrapToken_v2, messageProp);
        }
        return n2;
    }

    public final int unwrap(InputStream inputStream, byte[] byArray, int n, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        int n2 = 0;
        if (this.cipherHelper.getProto() == 0) {
            WrapToken wrapToken = new WrapToken(this, inputStream, messageProp);
            n2 = wrapToken.getData(byArray, n);
            this.setSequencingAndReplayProps(wrapToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, inputStream, messageProp);
            n2 = wrapToken_v2.getData(byArray, n);
            this.setSequencingAndReplayProps(wrapToken_v2, messageProp);
        }
        return n2;
    }

    public final void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        Krb5Token krb5Token;
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        byte[] byArray = null;
        if (this.cipherHelper.getProto() == 0) {
            krb5Token = new WrapToken(this, inputStream, messageProp);
            byArray = ((WrapToken)krb5Token).getData();
            this.setSequencingAndReplayProps((MessageToken)krb5Token, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            krb5Token = new WrapToken_v2(this, inputStream, messageProp);
            byArray = ((WrapToken_v2)krb5Token).getData();
            this.setSequencingAndReplayProps((MessageToken_v2)krb5Token, messageProp);
        }
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    public final byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2 = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken micToken = new MicToken(this, messageProp, byArray, n, n2);
                byArray2 = micToken.encode();
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 micToken_v2 = new MicToken_v2(this, messageProp, byArray, n, n2);
                byArray2 = micToken_v2.encode();
            }
            return byArray2;
        }
        catch (IOException iOException) {
            byArray2 = null;
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    private int getMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        int n4 = 0;
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken micToken = new MicToken(this, messageProp, byArray, n, n2);
                n4 = micToken.encode(byArray2, n3);
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 micToken_v2 = new MicToken_v2(this, messageProp, byArray, n, n2);
                n4 = micToken_v2.encode(byArray2, n3);
            }
            return n4;
        }
        catch (IOException iOException) {
            n4 = 0;
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    private void getMIC(byte[] byArray, int n, int n2, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken micToken = new MicToken(this, messageProp, byArray, n, n2);
                micToken.encode(outputStream);
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 micToken_v2 = new MicToken_v2(this, messageProp, byArray, n, n2);
                micToken_v2.encode(outputStream);
            }
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    public final void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        this.getMIC(byArray, 0, byArray.length, outputStream, messageProp);
    }

    public final void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (this.cipherHelper.getProto() == 0) {
            MicToken micToken = new MicToken(this, byArray, n, n2, messageProp);
            micToken.verify(byArray2, n3, n4);
            this.setSequencingAndReplayProps(micToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            MicToken_v2 micToken_v2 = new MicToken_v2(this, byArray, n, n2, messageProp);
            micToken_v2.verify(byArray2, n3, n4);
            this.setSequencingAndReplayProps(micToken_v2, messageProp);
        }
    }

    private void verifyMIC(InputStream inputStream, byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.cipherHelper.getProto() == 0) {
            MicToken micToken = new MicToken(this, inputStream, messageProp);
            micToken.verify(byArray, n, n2);
            this.setSequencingAndReplayProps(micToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            MicToken_v2 micToken_v2 = new MicToken_v2(this, inputStream, messageProp);
            micToken_v2.verify(byArray, n, n2);
            this.setSequencingAndReplayProps(micToken_v2, messageProp);
        }
    }

    public final void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream2.available()];
            inputStream2.read(byArray);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        this.verifyMIC(inputStream, byArray, 0, byArray.length, messageProp);
    }

    public final byte[] export() throws GSSException {
        throw new GSSException(16, -1, "GSS Export Context not available");
    }

    public final void dispose() throws GSSException {
        this.state = 4;
        this.delegatedCred = null;
    }

    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    private void setSequencingAndReplayProps(MessageToken messageToken, MessageProp messageProp) {
        if (this.replayDetState || this.sequenceDetState) {
            int n = messageToken.getSequenceNumber();
            this.peerTokenTracker.getProps(n, messageProp);
        }
    }

    private void setSequencingAndReplayProps(MessageToken_v2 messageToken_v2, MessageProp messageProp) {
        if (this.replayDetState || this.sequenceDetState) {
            int n = messageToken_v2.getSequenceNumber();
            this.peerTokenTracker.getProps(n, messageProp);
        }
    }

    private void checkPermission(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ServicePermission servicePermission = new ServicePermission(string, string2);
            securityManager.checkPermission(servicePermission);
        }
    }

    private static String getHexBytes(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[i] >> 4 & 0xF;
            int n4 = byArray[i] & 0xF;
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static String printState(int n) {
        switch (n) {
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_IN_PROCESS";
            }
            case 3: {
                return "STATE_DONE";
            }
            case 4: {
                return "STATE_DELETED";
            }
        }
        return "Unknown state " + n;
    }

    int getCaller() {
        return this.caller;
    }
}

