/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.Position;
import sun.awt.AppContext;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicComboBoxUI
extends ComboBoxUI {
    protected JComboBox comboBox;
    protected boolean hasFocus = false;
    private boolean isTableCellEditor = false;
    private static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    protected JList listBox;
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected ComboPopup popup;
    protected Component editor;
    protected JButton arrowButton;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ItemListener itemListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected KeyListener popupKeyListener;
    protected ListDataListener listDataListener;
    private Handler handler;
    private long timeFactor = 1000L;
    private long lastTime = 0L;
    private long time = 0L;
    JComboBox.KeySelectionManager keySelectionManager;
    protected boolean isMinimumSizeDirty = true;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);
    private boolean isDisplaySizeDirty = true;
    private Dimension cachedDisplaySize = new Dimension(0, 0);
    private static final Object COMBO_UI_LIST_CELL_RENDERER_KEY = new Object();
    static final Object HIDE_POPUP_KEY = new Object();
    private boolean sameBaseline;
    private boolean squareButton = true;
    private Insets padding;

    private static ListCellRenderer getDefaultListCellRenderer() {
        ListCellRenderer listCellRenderer = (ListCellRenderer)AppContext.getAppContext().get(COMBO_UI_LIST_CELL_RENDERER_KEY);
        if (listCellRenderer == null) {
            listCellRenderer = new DefaultListCellRenderer();
            AppContext.getAppContext().put(COMBO_UI_LIST_CELL_RENDERER_KEY, new DefaultListCellRenderer());
        }
        return listCellRenderer;
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("hidePopup"));
        lazyActionMap.put(new Actions("pageDownPassThrough"));
        lazyActionMap.put(new Actions("pageUpPassThrough"));
        lazyActionMap.put(new Actions("homePassThrough"));
        lazyActionMap.put(new Actions("endPassThrough"));
        lazyActionMap.put(new Actions("selectNext"));
        lazyActionMap.put(new Actions("selectNext2"));
        lazyActionMap.put(new Actions("togglePopup"));
        lazyActionMap.put(new Actions("spacePopup"));
        lazyActionMap.put(new Actions("selectPrevious"));
        lazyActionMap.put(new Actions("selectPrevious2"));
        lazyActionMap.put(new Actions("enterPressed"));
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        this.isMinimumSizeDirty = true;
        this.comboBox = (JComboBox)jComponent;
        this.installDefaults();
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        Boolean bl = (Boolean)jComponent.getClientProperty(IS_TABLE_CELL_EDITOR);
        if (bl != null) {
            boolean bl2 = this.isTableCellEditor = bl.equals(Boolean.TRUE);
        }
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(this.createRenderer());
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(this.createEditor());
        }
        this.installListeners();
        this.installComponents();
        this.comboBox.setLayout(this.createLayoutManager());
        this.comboBox.setRequestFocusEnabled(true);
        this.installKeyboardActions();
        this.comboBox.putClientProperty("doNotCancelPopup", HIDE_POPUP_KEY);
        if (this.keySelectionManager == null || this.keySelectionManager instanceof UIResource) {
            this.keySelectionManager = new DefaultKeySelectionManager();
        }
        this.comboBox.setKeySelectionManager(this.keySelectionManager);
    }

    public void uninstallUI(JComponent jComponent) {
        ComboBoxEditor comboBoxEditor;
        this.setPopupVisible(this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        if ((comboBoxEditor = this.comboBox.getEditor()) instanceof UIResource) {
            if (comboBoxEditor.getEditorComponent().hasFocus()) {
                this.comboBox.requestFocusInWindow();
            }
            this.comboBox.setEditor(null);
        }
        if (this.keySelectionManager instanceof UIResource) {
            this.comboBox.setKeySelectionManager(null);
        }
        this.handler = null;
        this.keyListener = null;
        this.focusListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.popup = null;
        this.listBox = null;
        this.comboBox = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.installBorder(this.comboBox, "ComboBox.border");
        LookAndFeel.installProperty(this.comboBox, "opaque", Boolean.TRUE);
        Long l = (Long)UIManager.get("ComboBox.timeFactor");
        this.timeFactor = l == null ? 1000L : l;
        Boolean bl = (Boolean)UIManager.get("ComboBox.squareButton");
        this.squareButton = bl == null ? true : bl;
        this.padding = UIManager.getInsets("ComboBox.padding");
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    protected void uninstallListeners() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener(this.keyListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
    }

    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected ListDataListener createListDataListener() {
        return this.getHandler();
    }

    protected ItemListener createItemListener() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    private void updateToolTipTextForChildren() {
        Component[] componentArray = this.comboBox.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            ((JComponent)componentArray[i]).setToolTipText(this.comboBox.getToolTipText());
        }
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void uninstallComponents() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
        }
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.comboBox.removeAll();
        this.arrowButton = null;
    }

    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        if (this.editor != null) {
            this.configureEditor();
            this.comboBox.add(this.editor);
            if (this.comboBox.isFocusOwner()) {
                this.editor.requestFocusInWindow();
            }
        }
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
            this.editor = null;
        }
    }

    protected void configureEditor() {
        this.editor.setEnabled(this.comboBox.isEnabled());
        this.editor.setFocusable(this.comboBox.isFocusable());
        this.editor.setFont(this.comboBox.getFont());
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
        this.editor.addFocusListener(this.getHandler());
        this.comboBox.getEditor().addActionListener(this.getHandler());
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).putClientProperty("doNotCancelPopup", HIDE_POPUP_KEY);
            ((JComponent)this.editor).setInheritsPopupMenu(true);
        }
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
        this.editor.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void unconfigureEditor() {
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
        this.editor.removePropertyChangeListener(this.propertyChangeListener);
        this.editor.removeFocusListener(this.getHandler());
        this.comboBox.getEditor().removeActionListener(this.getHandler());
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setEnabled(this.comboBox.isEnabled());
            this.arrowButton.setFocusable(this.comboBox.isFocusable());
            this.arrowButton.setRequestFocusEnabled(false);
            this.arrowButton.addMouseListener(this.popup.getMouseListener());
            this.arrowButton.addMouseMotionListener(this.popup.getMouseMotionListener());
            this.arrowButton.resetKeyboardActions();
            this.arrowButton.putClientProperty("doNotCancelPopup", HIDE_POPUP_KEY);
            this.arrowButton.setInheritsPopupMenu(true);
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.popup.getMouseListener());
            this.arrowButton.removeMouseMotionListener(this.popup.getMouseMotionListener());
        }
    }

    protected JButton createArrowButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(5, UIManager.getColor("ComboBox.buttonBackground"), UIManager.getColor("ComboBox.buttonShadow"), UIManager.getColor("ComboBox.buttonDarkShadow"), UIManager.getColor("ComboBox.buttonHighlight"));
        basicArrowButton.setName("ComboBox.arrowButton");
        return basicArrowButton;
    }

    public boolean isPopupVisible(JComboBox jComboBox) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox jComboBox, boolean bl) {
        if (bl) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return !this.comboBox.isEditable();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        int n = dimension.height;
        int n2 = this.squareButton ? n : this.arrowButton.getPreferredSize().width;
        dimension.height += insets.top + insets.bottom;
        dimension.width += insets.left + insets.right + n2;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        int n3 = -1;
        this.getDisplaySize();
        if (this.sameBaseline) {
            Insets insets = jComponent.getInsets();
            n2 = n2 - insets.top - insets.bottom;
            if (!this.comboBox.isEditable()) {
                ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
                if (listCellRenderer == null) {
                    listCellRenderer = new DefaultListCellRenderer();
                }
                Object object = null;
                Object object2 = this.comboBox.getPrototypeDisplayValue();
                if (object2 != null) {
                    object = object2;
                } else if (this.comboBox.getModel().getSize() > 0) {
                    object = this.comboBox.getModel().getElementAt(0);
                }
                if (object == null) {
                    object = " ";
                } else if (object instanceof String && "".equals(object)) {
                    object = " ";
                }
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, object, -1, false, false);
                if (component instanceof JComponent) {
                    component.setFont(this.comboBox.getFont());
                }
                n3 = component.getBaseline(n, n2);
            } else {
                n3 = this.editor.getBaseline(n, n2);
            }
            if (n3 > 0) {
                n3 += insets.top;
            }
        }
        return n3;
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        this.getDisplaySize();
        if (this.comboBox.isEditable()) {
            return this.editor.getBaselineResizeBehavior();
        }
        if (this.sameBaseline) {
            ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
            if (listCellRenderer == null) {
                listCellRenderer = new DefaultListCellRenderer();
            }
            Object object = null;
            Object object2 = this.comboBox.getPrototypeDisplayValue();
            if (object2 != null) {
                object = object2;
            } else if (this.comboBox.getModel().getSize() > 0) {
                object = this.comboBox.getModel().getElementAt(0);
            }
            if (object != null) {
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, object, -1, false, false);
                return component.getBaselineResizeBehavior();
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        if (this.comboBox.isEditable()) {
            return 2;
        }
        return 1;
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        switch (n) {
            case 0: {
                if (!(this.popup instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.popup)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.popup);
            }
            case 1: {
                if (!this.comboBox.isEditable() || !(this.editor instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.editor)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.editor);
            }
        }
        return null;
    }

    protected boolean isNavigationKey(int n) {
        return n == 38 || n == 40 || n == 224 || n == 225;
    }

    private boolean isNavigationKey(int n, int n2) {
        InputMap inputMap = this.comboBox.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        return inputMap != null && inputMap.get(keyStroke) != null;
    }

    protected void selectNextPossibleValue() {
        int n = this.isTableCellEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (n < this.comboBox.getModel().getSize() - 1) {
            if (this.isTableCellEditor) {
                this.listBox.setSelectedIndex(n + 1);
                this.listBox.ensureIndexIsVisible(n + 1);
            } else {
                this.comboBox.setSelectedIndex(n + 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.isTableCellEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (n > 0) {
            if (this.isTableCellEditor) {
                this.listBox.setSelectedIndex(n - 1);
                this.listBox.ensureIndexIsVisible(n - 1);
            } else {
                this.comboBox.setSelectedIndex(n - 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, !this.isPopupVisible(this.comboBox));
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        if (BasicGraphicsUtils.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n3, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        component.setFont(this.comboBox.getFont());
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
            component.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        boolean bl2 = false;
        if (component instanceof JPanel) {
            bl2 = true;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.padding != null) {
            n = rectangle.x + this.padding.left;
            n2 = rectangle.y + this.padding.top;
            n3 = rectangle.width - (this.padding.left + this.padding.right);
            n4 = rectangle.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, n, n2, n3, n4, bl2);
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = graphics.getColor();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(DefaultLookup.getColor(this.comboBox, this, "ComboBox.background", null));
        } else {
            graphics.setColor(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    void repaintCurrentValue() {
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.comboBox.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Dimension getDefaultSize() {
        Dimension dimension = this.getSizeForComponent(BasicComboBoxUI.getDefaultListCellRenderer().getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(dimension.width, dimension.height);
    }

    protected Dimension getDisplaySize() {
        Object object;
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer == null) {
            listCellRenderer = new DefaultListCellRenderer();
        }
        this.sameBaseline = true;
        Object object2 = this.comboBox.getPrototypeDisplayValue();
        if (object2 != null) {
            dimension = this.getSizeForComponent(listCellRenderer.getListCellRendererComponent(this.listBox, object2, -1, false, false));
        } else {
            object = this.comboBox.getModel();
            int n = object.getSize();
            int n2 = -1;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    Object object3 = object.getElementAt(i);
                    Component component = listCellRenderer.getListCellRendererComponent(this.listBox, object3, -1, false, false);
                    Dimension dimension2 = this.getSizeForComponent(component);
                    if (!(!this.sameBaseline || object3 == null || object3 instanceof String && "".equals(object3))) {
                        int n3 = component.getBaseline(dimension2.width, dimension2.height);
                        if (n3 == -1) {
                            this.sameBaseline = false;
                        } else if (n2 == -1) {
                            n2 = n3;
                        } else if (n2 != n3) {
                            this.sameBaseline = false;
                        }
                    }
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    dimension.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            object = this.editor.getPreferredSize();
            dimension.width = Math.max(dimension.width, ((Dimension)object).width);
            dimension.height = Math.max(dimension.height, ((Dimension)object).height);
        }
        if (this.padding != null) {
            dimension.width += this.padding.left + this.padding.right;
            dimension.height += this.padding.top + this.padding.bottom;
        }
        this.cachedDisplaySize.setSize(dimension.width, dimension.height);
        this.isDisplaySizeDirty = false;
        return dimension;
    }

    private Dimension getSizeForComponent(Component component) {
        this.currentValuePane.add(component);
        component.setFont(this.comboBox.getFont());
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.remove(component);
        return dimension;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.comboBox, BasicComboBoxUI.class, "ComboBox.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)DefaultLookup.get(this.comboBox, this, "ComboBox.ancestorInputMap");
        }
        return null;
    }

    boolean isTableCellEditor() {
        return this.isTableCellEditor;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, null);
        SwingUtilities.replaceUIActionMap(this.comboBox, null);
    }

    private static class Actions
    extends UIAction {
        private static final String HIDE = "hidePopup";
        private static final String DOWN = "selectNext";
        private static final String DOWN_2 = "selectNext2";
        private static final String TOGGLE = "togglePopup";
        private static final String TOGGLE_2 = "spacePopup";
        private static final String UP = "selectPrevious";
        private static final String UP_2 = "selectPrevious2";
        private static final String ENTER = "enterPressed";
        private static final String PAGE_DOWN = "pageDownPassThrough";
        private static final String PAGE_UP = "pageUpPassThrough";
        private static final String HOME = "homePassThrough";
        private static final String END = "endPassThrough";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            BasicComboBoxUI basicComboBoxUI = (BasicComboBoxUI)BasicLookAndFeel.getUIOfType(jComboBox.getUI(), BasicComboBoxUI.class);
            if (string == HIDE) {
                jComboBox.firePopupMenuCanceled();
                jComboBox.setPopupVisible(false);
            } else if (string == PAGE_DOWN || string == PAGE_UP || string == HOME || string == END) {
                int n = this.getNextIndex(jComboBox, string);
                if (n >= 0 && n < jComboBox.getItemCount()) {
                    jComboBox.setSelectedIndex(n);
                }
            } else if (string == DOWN) {
                if (jComboBox.isShowing()) {
                    if (jComboBox.isPopupVisible()) {
                        if (basicComboBoxUI != null) {
                            basicComboBoxUI.selectNextPossibleValue();
                        }
                    } else {
                        jComboBox.setPopupVisible(true);
                    }
                }
            } else if (string == DOWN_2) {
                if (jComboBox.isShowing()) {
                    if ((jComboBox.isEditable() || basicComboBoxUI != null && basicComboBoxUI.isTableCellEditor()) && !jComboBox.isPopupVisible()) {
                        jComboBox.setPopupVisible(true);
                    } else if (basicComboBoxUI != null) {
                        basicComboBoxUI.selectNextPossibleValue();
                    }
                }
            } else if (string == TOGGLE || string == TOGGLE_2) {
                if (!(basicComboBoxUI == null || string != TOGGLE && jComboBox.isEditable())) {
                    if (basicComboBoxUI.isTableCellEditor()) {
                        jComboBox.setSelectedIndex(basicComboBoxUI.popup.getList().getSelectedIndex());
                    } else {
                        jComboBox.setPopupVisible(!jComboBox.isPopupVisible());
                    }
                }
            } else if (string == UP) {
                if (basicComboBoxUI != null) {
                    if (basicComboBoxUI.isPopupVisible(jComboBox)) {
                        basicComboBoxUI.selectPreviousPossibleValue();
                    } else if (DefaultLookup.getBoolean(jComboBox, basicComboBoxUI, "ComboBox.showPopupOnNavigation", false)) {
                        basicComboBoxUI.setPopupVisible(jComboBox, true);
                    }
                }
            } else if (string == UP_2) {
                if (jComboBox.isShowing() && basicComboBoxUI != null) {
                    if (jComboBox.isEditable() && !jComboBox.isPopupVisible()) {
                        jComboBox.setPopupVisible(true);
                    } else {
                        basicComboBoxUI.selectPreviousPossibleValue();
                    }
                }
            } else if (string == ENTER) {
                boolean bl;
                boolean bl2 = bl = basicComboBoxUI != null && basicComboBoxUI.isTableCellEditor;
                if (jComboBox.isPopupVisible()) {
                    boolean bl3 = UIManager.getBoolean("ComboBox.isEnterSelectablePopup");
                    if (!jComboBox.isEditable() || bl3 || bl) {
                        Object object;
                        Object object2 = object = basicComboBoxUI == null ? null : basicComboBoxUI.popup.getList().getSelectedValue();
                        if (object != null) {
                            jComboBox.getModel().setSelectedItem(object);
                            jComboBox.getEditor().setItem(object);
                        }
                    }
                    jComboBox.setPopupVisible(false);
                } else if (bl && !jComboBox.isEditable()) {
                    jComboBox.setSelectedIndex(basicComboBoxUI.popup.getList().getSelectedIndex());
                } else {
                    JRootPane jRootPane = SwingUtilities.getRootPane(jComboBox);
                    if (jRootPane != null) {
                        Action action;
                        Object object;
                        InputMap inputMap = jRootPane.getInputMap(2);
                        ActionMap actionMap = jRootPane.getActionMap();
                        if (inputMap != null && actionMap != null && (object = inputMap.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = actionMap.get(object)) != null) {
                            action.actionPerformed(new ActionEvent(jRootPane, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
                        }
                    }
                }
            }
        }

        private int getNextIndex(JComboBox jComboBox, String string) {
            if (string == PAGE_UP) {
                int n = jComboBox.getMaximumRowCount();
                int n2 = jComboBox.getSelectedIndex() - n;
                return n2 < 0 ? 0 : n2;
            }
            if (string == PAGE_DOWN) {
                int n;
                int n3 = jComboBox.getMaximumRowCount();
                int n4 = jComboBox.getSelectedIndex() + n3;
                return n4 < (n = jComboBox.getItemCount()) ? n4 : n - 1;
            }
            if (string == HOME) {
                return 0;
            }
            if (string == END) {
                return jComboBox.getItemCount() - 1;
            }
            return jComboBox.getSelectedIndex();
        }

        public boolean isEnabled(Object object) {
            if (this.getName() == HIDE) {
                return object != null && ((JComboBox)object).isPopupVisible();
            }
            return true;
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return BasicComboBoxUI.this.getHandler().preferredLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            return BasicComboBoxUI.this.getHandler().minimumLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            BasicComboBoxUI.this.getHandler().layoutContainer(container);
        }
    }

    class DefaultKeySelectionManager
    implements JComboBox.KeySelectionManager,
    UIResource {
        private String prefix = "";
        private String typedString = "";

        DefaultKeySelectionManager() {
        }

        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            int n;
            if (BasicComboBoxUI.this.lastTime == 0L) {
                this.prefix = "";
                this.typedString = "";
            }
            boolean bl = true;
            int n2 = BasicComboBoxUI.this.comboBox.getSelectedIndex();
            if (BasicComboBoxUI.this.time - BasicComboBoxUI.this.lastTime < BasicComboBoxUI.this.timeFactor) {
                this.typedString = this.typedString + c;
                if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                    ++n2;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++n2;
                this.prefix = this.typedString = "" + c;
            }
            BasicComboBoxUI.this.lastTime = BasicComboBoxUI.this.time;
            if (n2 < 0 || n2 >= comboBoxModel.getSize()) {
                bl = false;
                n2 = 0;
            }
            if ((n = BasicComboBoxUI.this.listBox.getNextMatch(this.prefix, n2, Position.Bias.Forward)) < 0 && bl) {
                n = BasicComboBoxUI.this.listBox.getNextMatch(this.prefix, 0, Position.Bias.Forward);
            }
            return n;
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicComboBoxUI.this.getHandler().focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicComboBoxUI.this.getHandler().focusLost(focusEvent);
        }
    }

    private class Handler
    implements ActionListener,
    FocusListener,
    KeyListener,
    LayoutManager,
    ListDataListener,
    PropertyChangeListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getSource() == BasicComboBoxUI.this.editor) {
                if ("border".equals(string)) {
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    BasicComboBoxUI.this.comboBox.revalidate();
                }
            } else {
                JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
                if (string == "model") {
                    ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getNewValue();
                    ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getOldValue();
                    if (comboBoxModel2 != null && BasicComboBoxUI.this.listDataListener != null) {
                        comboBoxModel2.removeListDataListener(BasicComboBoxUI.this.listDataListener);
                    }
                    if (comboBoxModel != null && BasicComboBoxUI.this.listDataListener != null) {
                        comboBoxModel.addListDataListener(BasicComboBoxUI.this.listDataListener);
                    }
                    if (BasicComboBoxUI.this.editor != null) {
                        jComboBox.configureEditor(jComboBox.getEditor(), jComboBox.getSelectedItem());
                    }
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    jComboBox.revalidate();
                    jComboBox.repaint();
                } else if (string == "editor" && jComboBox.isEditable()) {
                    BasicComboBoxUI.this.addEditor();
                    jComboBox.revalidate();
                } else if (string == "editable") {
                    if (jComboBox.isEditable()) {
                        jComboBox.setRequestFocusEnabled(false);
                        BasicComboBoxUI.this.addEditor();
                    } else {
                        jComboBox.setRequestFocusEnabled(true);
                        BasicComboBoxUI.this.removeEditor();
                    }
                    BasicComboBoxUI.this.updateToolTipTextForChildren();
                    jComboBox.revalidate();
                } else if (string == "enabled") {
                    boolean bl = jComboBox.isEnabled();
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setEnabled(bl);
                    }
                    if (BasicComboBoxUI.this.arrowButton != null) {
                        BasicComboBoxUI.this.arrowButton.setEnabled(bl);
                    }
                    jComboBox.repaint();
                } else if (string == "focusable") {
                    boolean bl = jComboBox.isFocusable();
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setFocusable(bl);
                    }
                    if (BasicComboBoxUI.this.arrowButton != null) {
                        BasicComboBoxUI.this.arrowButton.setFocusable(bl);
                    }
                    jComboBox.repaint();
                } else if (string == "maximumRowCount") {
                    if (BasicComboBoxUI.this.isPopupVisible(jComboBox)) {
                        BasicComboBoxUI.this.setPopupVisible(jComboBox, false);
                        BasicComboBoxUI.this.setPopupVisible(jComboBox, true);
                    }
                } else if (string == "font") {
                    BasicComboBoxUI.this.listBox.setFont(jComboBox.getFont());
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setFont(jComboBox.getFont());
                    }
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    jComboBox.validate();
                } else if (string == "ToolTipText") {
                    BasicComboBoxUI.this.updateToolTipTextForChildren();
                } else if (string == BasicComboBoxUI.IS_TABLE_CELL_EDITOR) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    BasicComboBoxUI.this.isTableCellEditor = bl.equals(Boolean.TRUE);
                } else if (string == "prototypeDisplayValue") {
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    jComboBox.revalidate();
                } else if (string == "renderer") {
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    jComboBox.revalidate();
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (BasicComboBoxUI.this.isNavigationKey(keyEvent.getKeyCode(), keyEvent.getModifiers())) {
                BasicComboBoxUI.this.lastTime = 0L;
            } else if (BasicComboBoxUI.this.comboBox.isEnabled() && BasicComboBoxUI.this.comboBox.getModel().getSize() != 0 && this.isTypeAheadKey(keyEvent) && keyEvent.getKeyChar() != '\uffff') {
                BasicComboBoxUI.this.time = keyEvent.getWhen();
                if (BasicComboBoxUI.this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        private boolean isTypeAheadKey(KeyEvent keyEvent) {
            return !keyEvent.isAltDown() && !BasicGraphicsUtils.isMenuShortcutKeyDown(keyEvent);
        }

        public void focusGained(FocusEvent focusEvent) {
            ComboBoxEditor comboBoxEditor = BasicComboBoxUI.this.comboBox.getEditor();
            if (comboBoxEditor != null && focusEvent.getSource() == comboBoxEditor.getEditorComponent()) {
                return;
            }
            BasicComboBoxUI.this.hasFocus = true;
            BasicComboBoxUI.this.comboBox.repaint();
            if (BasicComboBoxUI.this.comboBox.isEditable() && BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.editor.requestFocus();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            ComboBoxEditor comboBoxEditor = BasicComboBoxUI.this.comboBox.getEditor();
            if (comboBoxEditor != null && focusEvent.getSource() == comboBoxEditor.getEditorComponent()) {
                Object object = comboBoxEditor.getItem();
                Object object2 = BasicComboBoxUI.this.comboBox.getSelectedItem();
                if (!focusEvent.isTemporary() && object != null && !object.equals(object2 == null ? "" : object2)) {
                    BasicComboBoxUI.this.comboBox.actionPerformed(new ActionEvent(comboBoxEditor, 0, "", EventQueue.getMostRecentEventTime(), 0));
                }
            }
            BasicComboBoxUI.this.hasFocus = false;
            if (!focusEvent.isTemporary()) {
                BasicComboBoxUI.this.setPopupVisible(BasicComboBoxUI.this.comboBox, false);
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
            }
            if (BasicComboBoxUI.this.comboBox.isEditable() && BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), BasicComboBoxUI.this.comboBox.getSelectedItem());
            }
            BasicComboBoxUI.this.isDisplaySizeDirty = true;
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            Cloneable cloneable;
            int n;
            JComboBox jComboBox = (JComboBox)container;
            int n2 = jComboBox.getWidth();
            int n3 = jComboBox.getHeight();
            Insets insets = BasicComboBoxUI.this.getInsets();
            int n4 = n = n3 - (insets.top + insets.bottom);
            if (BasicComboBoxUI.this.arrowButton != null) {
                cloneable = BasicComboBoxUI.this.arrowButton.getInsets();
                int n5 = n4 = BasicComboBoxUI.this.squareButton ? n : BasicComboBoxUI.this.arrowButton.getPreferredSize().width + cloneable.left + cloneable.right;
            }
            if (BasicComboBoxUI.this.arrowButton != null) {
                if (BasicGraphicsUtils.isLeftToRight(jComboBox)) {
                    BasicComboBoxUI.this.arrowButton.setBounds(n2 - (insets.right + n4), insets.top, n4, n);
                } else {
                    BasicComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n4, n);
                }
            }
            if (BasicComboBoxUI.this.editor != null) {
                cloneable = BasicComboBoxUI.this.rectangleForCurrentValue();
                BasicComboBoxUI.this.editor.setBounds((Rectangle)cloneable);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = BasicComboBoxUI.this.comboBox.getEditor().getItem();
            if (object != null) {
                Action action;
                ActionMap actionMap;
                if (!BasicComboBoxUI.this.comboBox.isPopupVisible() && !object.equals(BasicComboBoxUI.this.comboBox.getSelectedItem())) {
                    BasicComboBoxUI.this.comboBox.setSelectedItem(BasicComboBoxUI.this.comboBox.getEditor().getItem());
                }
                if ((actionMap = BasicComboBoxUI.this.comboBox.getActionMap()) != null && (action = actionMap.get("enterPressed")) != null) {
                    action.actionPerformed(new ActionEvent(BasicComboBoxUI.this.comboBox, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers()));
                }
            }
        }
    }

    public class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            BasicComboBoxUI.this.getHandler().keyPressed(keyEvent);
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent listDataEvent) {
            BasicComboBoxUI.this.getHandler().contentsChanged(listDataEvent);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicComboBoxUI.this.getHandler().intervalAdded(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicComboBoxUI.this.getHandler().intervalRemoved(listDataEvent);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicComboBoxUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }
}

