/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.text.CharacterIterator;

class CharArrayIterator
implements CharacterIterator {
    private char[] chars;
    private int pos;
    private int begin;

    CharArrayIterator(char[] cArray) {
        this.reset(cArray, 0);
    }

    CharArrayIterator(char[] cArray, int n) {
        this.reset(cArray, n);
    }

    public char first() {
        this.pos = 0;
        return this.current();
    }

    public char last() {
        this.pos = this.chars.length > 0 ? this.chars.length - 1 : 0;
        return this.current();
    }

    public char current() {
        if (this.pos >= 0 && this.pos < this.chars.length) {
            return this.chars[this.pos];
        }
        return '\uffff';
    }

    public char next() {
        if (this.pos < this.chars.length - 1) {
            ++this.pos;
            return this.chars[this.pos];
        }
        this.pos = this.chars.length;
        return '\uffff';
    }

    public char previous() {
        if (this.pos > 0) {
            --this.pos;
            return this.chars[this.pos];
        }
        this.pos = 0;
        return '\uffff';
    }

    public char setIndex(int n) {
        if ((n -= this.begin) < 0 || n > this.chars.length) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.pos = n;
        return this.current();
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.begin + this.chars.length;
    }

    public int getIndex() {
        return this.begin + this.pos;
    }

    public Object clone() {
        CharArrayIterator charArrayIterator = new CharArrayIterator(this.chars, this.begin);
        charArrayIterator.pos = this.pos;
        return charArrayIterator;
    }

    void reset(char[] cArray) {
        this.reset(cArray, 0);
    }

    void reset(char[] cArray, int n) {
        this.chars = cArray;
        this.begin = n;
        this.pos = 0;
    }
}

