/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SessionRef;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.Debug;

final class SessionManager {
    private static final int DEFAULT_MAX_SESSIONS = 32;
    private static final Debug debug = Debug.getInstance("pkcs11");
    private final Token token;
    private final int maxSessions;
    private final Pool objSessions;
    private final Pool opSessions;
    private int maxActiveSessions;
    private final long openSessionFlags;

    SessionManager(Token token) {
        long l;
        if (token.isWriteProtected()) {
            this.openSessionFlags = 4L;
            l = token.tokenInfo.ulMaxSessionCount;
        } else {
            this.openSessionFlags = 6L;
            l = token.tokenInfo.ulMaxRwSessionCount;
        }
        if (l == 0L) {
            l = Integer.MAX_VALUE;
        } else if (l == -1L || l < 0L) {
            l = 32L;
        }
        this.maxSessions = (int)Math.min(l, Integer.MAX_VALUE);
        this.token = token;
        this.objSessions = new Pool(this);
        this.opSessions = new Pool(this);
    }

    boolean lowMaxSessions() {
        return this.maxSessions <= 32;
    }

    int totalSessionCount() {
        return SessionRef.totalCount();
    }

    synchronized Session getObjSession() throws PKCS11Exception {
        Session session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.openSession();
        return this.ensureValid(session);
    }

    synchronized Session getOpSession() throws PKCS11Exception {
        Session session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        if (this.maxSessions == Integer.MAX_VALUE || this.totalSessionCount() < this.maxSessions) {
            session = this.openSession();
            return this.ensureValid(session);
        }
        session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        throw new ProviderException("Could not obtain session");
    }

    private Session ensureValid(Session session) {
        session.id();
        return session;
    }

    synchronized Session killSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (debug != null) {
            String string = new Exception().getStackTrace()[2].toString();
            System.out.println("Killing session (" + string + ") active: " + this.totalSessionCount());
        }
        this.closeSession(session);
        return null;
    }

    synchronized Session releaseSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (session.hasObjects()) {
            this.objSessions.release(session);
        } else {
            this.opSessions.release(session);
        }
        return null;
    }

    synchronized void demoteObjSession(Session session) {
        boolean bl;
        if (!this.token.isValid()) {
            return;
        }
        if (debug != null) {
            System.out.println("Demoting session, active: " + this.totalSessionCount());
        }
        if (!(bl = this.objSessions.remove(session))) {
            return;
        }
        this.opSessions.release(session);
    }

    private Session openSession() throws PKCS11Exception {
        int n;
        if (this.maxSessions != Integer.MAX_VALUE && this.totalSessionCount() >= this.maxSessions) {
            throw new ProviderException("No more sessions available");
        }
        long l = this.token.p11.C_OpenSession(this.token.provider.slotID, this.openSessionFlags, null, null);
        Session session = new Session(this.token, l);
        if (debug != null && (n = this.totalSessionCount()) > this.maxActiveSessions) {
            this.maxActiveSessions = n;
            if (this.maxActiveSessions % 10 == 0) {
                System.out.println("Open sessions: " + this.maxActiveSessions);
            }
        }
        return session;
    }

    private void closeSession(Session session) {
        session.close();
    }

    private static final class Pool {
        private final SessionManager mgr;
        private final List<Session> pool;

        Pool(SessionManager sessionManager) {
            this.mgr = sessionManager;
            this.pool = new ArrayList<Session>();
        }

        boolean remove(Session session) {
            return this.pool.remove(session);
        }

        Session poll() {
            int n = this.pool.size();
            if (n == 0) {
                return null;
            }
            Session session = this.pool.remove(n - 1);
            return session;
        }

        void release(Session session) {
            int n;
            this.pool.add(session);
            if (session.hasObjects()) {
                return;
            }
            int n2 = this.pool.size();
            if (n2 < 5) {
                return;
            }
            Session session2 = this.pool.get(0);
            long l = System.currentTimeMillis();
            if (session.isLive(l) && session2.isLive(l)) {
                return;
            }
            Collections.sort(this.pool);
            for (n = 0; n < n2 - 1 && !(session2 = this.pool.get(n)).isLive(l); ++n) {
                this.mgr.closeSession(session2);
            }
            if (debug != null) {
                System.out.println("Closing " + n + " idle sessions, active: " + this.mgr.totalSessionCount());
            }
            List<Session> list = this.pool.subList(0, n);
            list.clear();
        }
    }
}

