/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.snmp.IPAcl.AclEntryImpl;
import com.sun.jmx.snmp.IPAcl.OwnerImpl;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclImpl
extends OwnerImpl
implements Acl,
Serializable {
    private Vector entryList = new Vector();
    private String aclName = null;

    public AclImpl(PrincipalImpl principalImpl, String string) {
        super(principalImpl);
        this.aclName = string;
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.aclName = string;
    }

    public String getName() {
        return this.aclName;
    }

    public boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        if (this.entryList.contains(aclEntry)) {
            return false;
        }
        this.entryList.addElement(aclEntry);
        return true;
    }

    public boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        return this.entryList.removeElement(aclEntry);
    }

    public void removeAll(Principal principal) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.entryList.removeAllElements();
    }

    public Enumeration getPermissions(Principal principal) {
        Vector vector = new Vector();
        Enumeration enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = (AclEntry)enumeration.nextElement();
            if (!((Object)aclEntry.getPrincipal()).equals(principal)) continue;
            return aclEntry.permissions();
        }
        return vector.elements();
    }

    public Enumeration entries() {
        return this.entryList.elements();
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        Enumeration enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = (AclEntry)enumeration.nextElement();
            if (!((Object)aclEntry.getPrincipal()).equals(principal) || !aclEntry.checkPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPermission(Principal principal, String string, Permission permission) {
        Enumeration enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
            if (!((Object)aclEntryImpl.getPrincipal()).equals(principal) || !aclEntryImpl.checkPermission(permission) || !aclEntryImpl.checkCommunity(string)) continue;
            return true;
        }
        return false;
    }

    public boolean checkCommunity(String string) {
        Enumeration enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
            if (!aclEntryImpl.checkCommunity(string)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AclImpl: " + this.getName();
    }
}

