/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.io.InputStreamHook;
import com.sun.corba.se.impl.io.ObjectStreamClass;
import com.sun.corba.se.impl.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.impl.io.ObjectStreamField;
import com.sun.corba.se.impl.io.ValueHandlerImpl;
import com.sun.corba.se.impl.io.ValueUtility;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.UtilSystemException;
import com.sun.corba.se.impl.util.Utility;
import com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;
import sun.corba.Bridge;

public class IIOPInputStream
extends InputStreamHook {
    private static Bridge bridge = (Bridge)AccessController.doPrivileged(new PrivilegedAction(){

        public java.lang.Object run() {
            return Bridge.get();
        }
    });
    private static OMGSystemException omgWrapper = OMGSystemException.get("rpc.encoding");
    private static UtilSystemException utilWrapper = UtilSystemException.get("rpc.encoding");
    private ValueMember[] defaultReadObjectFVDMembers = null;
    private InputStream orbStream;
    private CodeBase cbSender;
    private ValueHandlerImpl vhandler;
    private java.lang.Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private Class currentClass = null;
    private int recursionDepth = 0;
    private int simpleReadDepth = 0;
    ActiveRecursionManager activeRecursionMgr = new ActiveRecursionManager();
    private IOException abortIOException = null;
    private ClassNotFoundException abortClassNotFoundException = null;
    private Vector callbacks;
    ObjectStreamClass[] classdesc;
    Class[] classes;
    int spClass;
    private static final String kEmptyStr = "";
    public static final TypeCode kRemoteTypeCode = ORB.init().get_primitive_tc(TCKind.tk_objref);
    public static final TypeCode kValueTypeCode = ORB.init().get_primitive_tc(TCKind.tk_value);
    private static final boolean useFVDOnly = false;
    private byte streamFormatVersion;
    private static final Constructor OPT_DATA_EXCEPTION_CTOR = IIOPInputStream.getOptDataExceptionCtor();
    private java.lang.Object[] readObjectArgList = new java.lang.Object[]{this};

    private static Constructor getOptDataExceptionCtor() {
        try {
            Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException, SecurityException {
                    Constructor constructor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
                    constructor.setAccessible(true);
                    return constructor;
                }
            });
            if (constructor == null) {
                throw new Error("Unable to find OptionalDataException constructor");
            }
            return constructor;
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    private OptionalDataException createOptionalDataException() {
        try {
            OptionalDataException optionalDataException = (OptionalDataException)OPT_DATA_EXCEPTION_CTOR.newInstance(Boolean.TRUE);
            if (optionalDataException == null) {
                throw new Error("Created null OptionalDataException");
            }
            return optionalDataException;
        }
        catch (Exception exception) {
            throw new Error("Couldn't create OptionalDataException", exception);
        }
    }

    protected byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    private void readFormatVersion() throws IOException {
        this.streamFormatVersion = this.orbStream.read_octet();
        if (this.streamFormatVersion < 1 || this.streamFormatVersion > this.vhandler.getMaximumStreamFormatVersion()) {
            MARSHAL mARSHAL = omgWrapper.unsupportedFormatVersion(CompletionStatus.COMPLETED_MAYBE);
            IOException iOException = new IOException("Unsupported format version: " + this.streamFormatVersion);
            iOException.initCause(mARSHAL);
            throw iOException;
        }
        if (this.streamFormatVersion == 2 && !(this.orbStream instanceof ValueInputStream)) {
            BAD_PARAM bAD_PARAM = omgWrapper.notAValueinputstream(CompletionStatus.COMPLETED_MAYBE);
            IOException iOException = new IOException("Not a ValueInputStream");
            iOException.initCause(bAD_PARAM);
            throw iOException;
        }
    }

    public static void setTestFVDFlag(boolean bl) {
    }

    public IIOPInputStream() throws IOException {
        this.resetStream();
    }

    public final void setOrbStream(InputStream inputStream) {
        this.orbStream = inputStream;
    }

    public final InputStream getOrbStream() {
        return this.orbStream;
    }

    public final void setSender(CodeBase codeBase) {
        this.cbSender = codeBase;
    }

    public final CodeBase getSender() {
        return this.cbSender;
    }

    public final void setValueHandler(ValueHandler valueHandler) {
        this.vhandler = (ValueHandlerImpl)valueHandler;
    }

    public final ValueHandler getValueHandler() {
        return this.vhandler;
    }

    public final void increaseRecursionDepth() {
        ++this.recursionDepth;
    }

    public final int decreaseRecursionDepth() {
        return --this.recursionDepth;
    }

    public final java.lang.Object readObjectDelegate() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_abstract_interface();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, true);
            throw mARSHAL;
        }
        catch (IndirectionException indirectionException) {
            return this.activeRecursionMgr.getObject(indirectionException.offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final java.lang.Object simpleReadObject(Class clazz, String string, CodeBase codeBase, int n) {
        java.lang.Object object = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        Class clazz2 = this.currentClass;
        byte by = this.streamFormatVersion;
        ++this.simpleReadDepth;
        java.lang.Object object2 = null;
        try {
            object2 = this.vhandler.useFullValueDescription(clazz, string) ? this.inputObjectUsingFVD(clazz, string, codeBase, n) : this.inputObject(clazz, string, codeBase, n);
            object2 = this.currentClassDesc.readResolve(object2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            bridge.throwException(classNotFoundException);
            java.lang.Object var11_13 = null;
            return var11_13;
        }
        catch (IOException iOException) {
            bridge.throwException(iOException);
            java.lang.Object var11_14 = null;
            return var11_14;
        }
        finally {
            --this.simpleReadDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
            this.currentClass = clazz2;
            this.streamFormatVersion = by;
        }
        IOException iOException = this.abortIOException;
        if (this.simpleReadDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            bridge.throwException(iOException);
            return null;
        }
        ClassNotFoundException classNotFoundException = this.abortClassNotFoundException;
        if (this.simpleReadDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (classNotFoundException != null) {
            bridge.throwException(classNotFoundException);
            return null;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void simpleSkipObject(String string, CodeBase codeBase) {
        java.lang.Object object = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        Class clazz = this.currentClass;
        byte by = this.streamFormatVersion;
        ++this.simpleReadDepth;
        java.lang.Object var7_7 = null;
        try {
            this.skipObjectUsingFVD(string, codeBase);
        }
        catch (ClassNotFoundException classNotFoundException) {
            bridge.throwException(classNotFoundException);
            return;
        }
        catch (IOException iOException) {
            bridge.throwException(iOException);
            return;
        }
        finally {
            --this.simpleReadDepth;
            this.streamFormatVersion = by;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
            this.currentClass = clazz;
        }
        IOException iOException = this.abortIOException;
        if (this.simpleReadDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            bridge.throwException(iOException);
            return;
        }
        ClassNotFoundException classNotFoundException = this.abortClassNotFoundException;
        if (this.simpleReadDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (classNotFoundException != null) {
            bridge.throwException(classNotFoundException);
            return;
        }
    }

    protected final java.lang.Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        return this.readObjectDelegate();
    }

    public final void defaultReadObjectDelegate() {
        try {
            if (this.currentObject == null || this.currentClassDesc == null) {
                throw new NotActiveException("defaultReadObjectDelegate");
            }
            if (this.defaultReadObjectFVDMembers != null && this.defaultReadObjectFVDMembers.length > 0) {
                ValueMember[] valueMemberArray = this.defaultReadObjectFVDMembers;
                this.defaultReadObjectFVDMembers = null;
                this.inputClassFields(this.currentObject, this.currentClass, this.currentClassDesc, valueMemberArray, this.cbSender);
            } else {
                ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
                if (objectStreamFieldArray.length > 0) {
                    this.inputClassFields(this.currentObject, this.currentClass, objectStreamFieldArray, this.cbSender);
                }
            }
        }
        catch (NotActiveException notActiveException) {
            bridge.throwException(notActiveException);
        }
        catch (IOException iOException) {
            bridge.throwException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            bridge.throwException(classNotFoundException);
        }
    }

    public final boolean enableResolveObjectDelegate(boolean bl) {
        return false;
    }

    public final void mark(int n) {
        this.orbStream.mark(n);
    }

    public final boolean markSupported() {
        return this.orbStream.markSupported();
    }

    public final void reset() throws IOException {
        try {
            this.orbStream.reset();
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final int available() throws IOException {
        return 0;
    }

    public final void close() throws IOException {
    }

    public final int read() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_octet() << 0 & 0xFF;
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                this.setState(IN_READ_OBJECT_NO_MORE_OPT_DATA);
                return -1;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.readObjectState.readData(this);
            this.orbStream.read_octet_array(byArray, n, n2);
            return n2;
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                this.setState(IN_READ_OBJECT_NO_MORE_OPT_DATA);
                return -1;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final boolean readBoolean() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_boolean();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final byte readByte() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_octet();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final char readChar() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_wchar();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final double readDouble() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_double();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final float readFloat() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_float();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.readObjectState.readData(this);
            this.orbStream.read_octet_array(byArray, n, n2);
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final int readInt() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_long();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final String readLine() throws IOException {
        throw new IOException("Method readLine not supported");
    }

    public final long readLong() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_longlong();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final short readShort() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_short();
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    protected final void readStreamHeader() throws IOException, StreamCorruptedException {
    }

    public final int readUnsignedByte() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_octet() << 0 & 0xFF;
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    public final int readUnsignedShort() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_ushort() << 0 & 0xFFFF;
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    protected String internalReadUTF(org.omg.CORBA.portable.InputStream inputStream) {
        return inputStream.read_wstring();
    }

    public final String readUTF() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.internalReadUTF(this.orbStream);
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    private void handleOptionalDataMarshalException(MARSHAL mARSHAL, boolean bl) throws IOException {
        if (mARSHAL.minor == 1330446344) {
            IOException iOException = !bl ? new EOFException("No more optional data") : this.createOptionalDataException();
            iOException.initCause(mARSHAL);
            this.setState(IN_READ_OBJECT_NO_MORE_OPT_DATA);
            throw iOException;
        }
    }

    public final synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        throw new Error("Method registerValidation not supported");
    }

    protected final Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        throw new IOException("Method resolveClass not supported");
    }

    protected final java.lang.Object resolveObject(java.lang.Object object) throws IOException {
        throw new IOException("Method resolveObject not supported");
    }

    public final int skipBytes(int n) throws IOException {
        try {
            this.readObjectState.readData(this);
            byte[] byArray = new byte[n];
            this.orbStream.read_octet_array(byArray, 0, n);
            return n;
        }
        catch (MARSHAL mARSHAL) {
            this.handleOptionalDataMarshalException(mARSHAL, false);
            throw mARSHAL;
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private java.lang.Object inputObject(Class var1_1, String var2_2, CodeBase var3_3, int var4_4) throws IOException, ClassNotFoundException {
        block34: {
            this.currentClassDesc = ObjectStreamClass.lookup(var1_1);
            this.currentClass = this.currentClassDesc.forClass();
            if (this.currentClass == null) {
                throw new ClassNotFoundException(this.currentClassDesc.getName());
            }
            try {
                if (Enum.class.isAssignableFrom(var1_1)) {
                    var5_5 = this.orbStream.read_long();
                    var6_11 = (String)this.orbStream.read_value(String.class);
                    var7_16 = Enum.valueOf(var1_1, var6_11);
                    return var7_16;
                }
                if (this.currentClassDesc.isExternalizable()) {
                    try {
                        v0 = this.currentObject = this.currentClass == null ? null : this.currentClassDesc.newInstance();
                        if (this.currentObject != null) {
                            this.activeRecursionMgr.addObject(var4_4, this.currentObject);
                            this.readFormatVersion();
                            var5_6 = (Externalizable)this.currentObject;
                            var5_6.readExternal(this);
                        }
                        break block34;
                    }
                    catch (InvocationTargetException var5_7) {
                        var6_12 = new InvalidClassException(this.currentClass.getName(), "InvocationTargetException accessing no-arg constructor");
                        var6_12.initCause(var5_7);
                        throw var6_12;
                    }
                    catch (UnsupportedOperationException var5_8) {
                        var6_13 = new InvalidClassException(this.currentClass.getName(), "UnsupportedOperationException accessing no-arg constructor");
                        var6_13.initCause(var5_8);
                        throw var6_13;
                    }
                    catch (InstantiationException var5_9) {
                        var6_14 = new InvalidClassException(this.currentClass.getName(), "InstantiationException accessing no-arg constructor");
                        var6_14.initCause(var5_9);
                        throw var6_14;
                    }
                }
                var5_10 = this.currentClassDesc;
                var6_15 = this.currentClass;
                var7_17 = this.spClass;
                var6_15 = this.currentClass;
                for (var5_10 = this.currentClassDesc; var5_10 != null && var5_10.isSerializable(); var5_10 = var5_10.getSuperclass()) {
                    var8_18 = var5_10.forClass();
                    for (var9_22 = var6_15; var9_22 != null && var8_18 != var9_22; var9_22 = var9_22.getSuperclass()) {
                    }
                    ++this.spClass;
                    if (this.spClass >= this.classes.length) {
                        var10_26 = this.classes.length * 2;
                        var11_27 = new Class[var10_26];
                        var12_28 = new ObjectStreamClass[var10_26];
                        System.arraycopy(this.classes, 0, var11_27, 0, this.classes.length);
                        System.arraycopy(this.classdesc, 0, var12_28, 0, this.classes.length);
                        this.classes = var11_27;
                        this.classdesc = var12_28;
                    }
                    if (var9_22 == null) {
                        this.classdesc[this.spClass] = var5_10;
                        this.classes[this.spClass] = null;
                        continue;
                    }
                    this.classdesc[this.spClass] = var5_10;
                    this.classes[this.spClass] = var9_22;
                    var6_15 = var9_22.getSuperclass();
                }
                try {
                    this.currentObject = this.currentClass == null ? null : this.currentClassDesc.newInstance();
                    this.activeRecursionMgr.addObject(var4_4, this.currentObject);
                }
                catch (InvocationTargetException var8_19) {
                    var9_22 = new InvalidClassException(this.currentClass.getName(), "InvocationTargetException accessing no-arg constructor");
                    var9_22.initCause(var8_19);
                    throw var9_22;
                }
                catch (UnsupportedOperationException var8_20) {
                    var9_22 = new InvalidClassException(this.currentClass.getName(), "UnsupportedOperationException accessing no-arg constructor");
                    var9_22.initCause(var8_20);
                    throw var9_22;
                }
                catch (InstantiationException var8_21) {
                    var9_22 = new InvalidClassException(this.currentClass.getName(), "InstantiationException accessing no-arg constructor");
                    var9_22.initCause(var8_21);
                    throw var9_22;
                }
                try {
                    this.spClass = this.spClass;
                    while (this.spClass > var7_17) {
                        this.currentClassDesc = this.classdesc[this.spClass];
                        this.currentClass = this.classes[this.spClass];
                        if (this.classes[this.spClass] != null) {
                            var8_18 = this.readObjectState;
                            this.setState(IIOPInputStream.DEFAULT_STATE);
                            try {
                                if (this.currentClassDesc.hasWriteObject()) {
                                    this.readFormatVersion();
                                    var9_24 = this.readBoolean();
                                    this.readObjectState.beginUnmarshalCustomValue(this, var9_24, this.currentClassDesc.readObjectMethod != null);
                                } else if (this.currentClassDesc.hasReadObject()) {
                                    this.setState(IIOPInputStream.IN_READ_OBJECT_REMOTE_NOT_CUSTOM_MARSHALED);
                                }
                                if (!(this.invokeObjectReader(this.currentClassDesc, this.currentObject, this.currentClass) && this.readObjectState != IIOPInputStream.IN_READ_OBJECT_DEFAULTS_SENT || (var9_25 = this.currentClassDesc.getFieldsNoCopy()).length <= 0)) {
                                    this.inputClassFields(this.currentObject, this.currentClass, var9_25, var3_3);
                                }
                                if (!this.currentClassDesc.hasWriteObject()) ** GOTO lbl106
                                this.readObjectState.endUnmarshalCustomValue(this);
                            }
                            finally {
                                this.setState((InputStreamHook.ReadObjectState)var8_18);
                            }
                        } else {
                            var8_18 = this.currentClassDesc.getFieldsNoCopy();
                            if (var8_18.length > 0) {
                                this.inputClassFields(null, this.currentClass, var8_18, var3_3);
                            }
                        }
lbl106:
                        // 5 sources

                        --this.spClass;
                    }
                }
                finally {
                    this.spClass = var7_17;
                }
            }
            finally {
                this.activeRecursionMgr.removeObject(var4_4);
            }
        }
        return this.currentObject;
    }

    private Vector getOrderedDescriptions(String string, CodeBase codeBase) {
        Vector<FullValueDescription> vector = new Vector<FullValueDescription>();
        if (codeBase == null) {
            return vector;
        }
        FullValueDescription fullValueDescription = codeBase.meta(string);
        while (fullValueDescription != null) {
            vector.insertElementAt(fullValueDescription, 0);
            if (fullValueDescription.base_value != null && !kEmptyStr.equals(fullValueDescription.base_value)) {
                fullValueDescription = codeBase.meta(fullValueDescription.base_value);
                continue;
            }
            return vector;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private java.lang.Object inputObjectUsingFVD(Class var1_1, String var2_2, CodeBase var3_3, int var4_4) throws IOException, ClassNotFoundException {
        var5_5 = this.spClass;
        try {
            var6_6 = this.currentClassDesc = ObjectStreamClass.lookup(var1_1);
            var7_7 = this.currentClass = var1_1;
            if (this.currentClassDesc.isExternalizable()) {
                try {
                    v0 = this.currentObject = this.currentClass == null ? null : this.currentClassDesc.newInstance();
                    if (this.currentObject == null) ** GOTO lbl145
                    this.activeRecursionMgr.addObject(var4_4, this.currentObject);
                    this.readFormatVersion();
                    var8_8 = (Externalizable)this.currentObject;
                    var8_8.readExternal(this);
                }
                catch (InvocationTargetException var8_9) {
                    var9_15 = new InvalidClassException(this.currentClass.getName(), "InvocationTargetException accessing no-arg constructor");
                    var9_15.initCause(var8_9);
                    throw var9_15;
                }
                catch (UnsupportedOperationException var8_10) {
                    var9_16 = new InvalidClassException(this.currentClass.getName(), "UnsupportedOperationException accessing no-arg constructor");
                    var9_16.initCause(var8_10);
                    throw var9_16;
                }
                catch (InstantiationException var8_11) {
                    var9_17 = new InvalidClassException(this.currentClass.getName(), "InstantiationException accessing no-arg constructor");
                    var9_17.initCause(var8_11);
                    throw var9_17;
                }
            } else {
                var7_7 = this.currentClass;
                for (var6_6 = this.currentClassDesc; var6_6 != null && var6_6.isSerializable(); var6_6 = var6_6.getSuperclass()) {
                    var8_8 = var6_6.forClass();
                    for (var9_18 = var7_7; var9_18 != null && var8_8 != var9_18; var9_18 = var9_18.getSuperclass()) {
                    }
                    ++this.spClass;
                    if (this.spClass >= this.classes.length) {
                        var10_19 = this.classes.length * 2;
                        var11_21 = new Class[var10_19];
                        var12_22 = new ObjectStreamClass[var10_19];
                        System.arraycopy(this.classes, 0, var11_21, 0, this.classes.length);
                        System.arraycopy(this.classdesc, 0, var12_22, 0, this.classes.length);
                        this.classes = var11_21;
                        this.classdesc = var12_22;
                    }
                    if (var9_18 == null) {
                        this.classdesc[this.spClass] = var6_6;
                        this.classes[this.spClass] = null;
                        continue;
                    }
                    this.classdesc[this.spClass] = var6_6;
                    this.classes[this.spClass] = var9_18;
                    var7_7 = var9_18.getSuperclass();
                }
                try {
                    this.currentObject = this.currentClass == null ? null : this.currentClassDesc.newInstance();
                    this.activeRecursionMgr.addObject(var4_4, this.currentObject);
                }
                catch (InvocationTargetException var8_12) {
                    var9_18 = new InvalidClassException(this.currentClass.getName(), "InvocationTargetException accessing no-arg constructor");
                    var9_18.initCause(var8_12);
                    throw var9_18;
                }
                catch (UnsupportedOperationException var8_13) {
                    var9_18 = new InvalidClassException(this.currentClass.getName(), "UnsupportedOperationException accessing no-arg constructor");
                    var9_18.initCause(var8_13);
                    throw var9_18;
                }
                catch (InstantiationException var8_14) {
                    var9_18 = new InvalidClassException(this.currentClass.getName(), "InstantiationException accessing no-arg constructor");
                    var9_18.initCause(var8_14);
                    throw var9_18;
                }
                var8_8 = this.getOrderedDescriptions(var2_2, var3_3).elements();
                while (var8_8.hasMoreElements() && this.spClass > var5_5) {
                    var9_18 = (FullValueDescription)var8_8.nextElement();
                    var10_20 = this.vhandler.getClassName(var9_18.id);
                    var11_21 = this.vhandler.getClassName(this.vhandler.getRMIRepositoryID(this.currentClass));
                    while (this.spClass > var5_5 && !var10_20.equals(var11_21)) {
                        var12_23 = this.findNextClass(var10_20, this.classes, this.spClass, var5_5);
                        if (var12_23 != -1) {
                            this.spClass = var12_23;
                            var7_7 = this.currentClass = this.classes[this.spClass];
                            var11_21 = this.vhandler.getClassName(this.vhandler.getRMIRepositoryID(this.currentClass));
                            continue;
                        }
                        if (var9_18.is_custom) {
                            this.readFormatVersion();
                            var13_25 = this.readBoolean();
                            if (var13_25) {
                                this.inputClassFields(null, null, null, var9_18.members, var3_3);
                            }
                            if (this.getStreamFormatVersion() == 2) {
                                ((ValueInputStream)this.getOrbStream()).start_value();
                                ((ValueInputStream)this.getOrbStream()).end_value();
                            }
                        } else {
                            this.inputClassFields(null, this.currentClass, null, var9_18.members, var3_3);
                        }
                        if (var8_8.hasMoreElements()) {
                            var9_18 = (FullValueDescription)var8_8.nextElement();
                            var10_20 = this.vhandler.getClassName(var9_18.id);
                            continue;
                        }
                        var13_26 = this.currentObject;
                        return var13_26;
                    }
                    var6_6 = this.currentClassDesc = ObjectStreamClass.lookup(this.currentClass);
                    if (!var11_21.equals("java.lang.Object")) {
                        var12_24 = this.readObjectState;
                        this.setState(IIOPInputStream.DEFAULT_STATE);
                        try {
                            if (var9_18.is_custom) {
                                this.readFormatVersion();
                                var13_25 = this.readBoolean();
                                this.readObjectState.beginUnmarshalCustomValue(this, var13_25, this.currentClassDesc.readObjectMethod != null);
                            }
                            var13_25 = false;
                            try {
                                if (!var9_18.is_custom && this.currentClassDesc.hasReadObject()) {
                                    this.setState(IIOPInputStream.IN_READ_OBJECT_REMOTE_NOT_CUSTOM_MARSHALED);
                                }
                                this.defaultReadObjectFVDMembers = var9_18.members;
                                var13_25 = this.invokeObjectReader(this.currentClassDesc, this.currentObject, this.currentClass);
                            }
                            finally {
                                this.defaultReadObjectFVDMembers = null;
                            }
                            if (!var13_25 || this.readObjectState == IIOPInputStream.IN_READ_OBJECT_DEFAULTS_SENT) {
                                this.inputClassFields(this.currentObject, this.currentClass, var6_6, var9_18.members, var3_3);
                            }
                            if (var9_18.is_custom) {
                                this.readObjectState.endUnmarshalCustomValue(this);
                            }
                        }
                        finally {
                            this.setState(var12_24);
                        }
                        var7_7 = this.currentClass = this.classes[--this.spClass];
                        continue;
                    }
                    this.inputClassFields(null, this.currentClass, null, var9_18.members, var3_3);
                    while (var8_8.hasMoreElements()) {
                        var9_18 = (FullValueDescription)var8_8.nextElement();
                        if (var9_18.is_custom) {
                            this.skipCustomUsingFVD(var9_18.members, var3_3);
                            continue;
                        }
                        this.inputClassFields(null, this.currentClass, null, var9_18.members, var3_3);
                    }
                }
                while (var8_8.hasMoreElements()) {
                    var9_18 = (FullValueDescription)var8_8.nextElement();
                    if (var9_18.is_custom) {
                        this.skipCustomUsingFVD(var9_18.members, var3_3);
                        continue;
                    }
                    this.throwAwayData(var9_18.members, var3_3);
                }
            }
lbl145:
            // 3 sources

            var8_8 = this.currentObject;
            return var8_8;
        }
        finally {
            this.spClass = var5_5;
            this.activeRecursionMgr.removeObject(var4_4);
        }
    }

    private java.lang.Object skipObjectUsingFVD(String string, CodeBase codeBase) throws IOException, ClassNotFoundException {
        Enumeration enumeration = this.getOrderedDescriptions(string, codeBase).elements();
        while (enumeration.hasMoreElements()) {
            FullValueDescription fullValueDescription = (FullValueDescription)enumeration.nextElement();
            String string2 = this.vhandler.getClassName(fullValueDescription.id);
            if (string2.equals("java.lang.Object")) continue;
            if (fullValueDescription.is_custom) {
                this.readFormatVersion();
                boolean bl = this.readBoolean();
                if (bl) {
                    this.inputClassFields(null, null, null, fullValueDescription.members, codeBase);
                }
                if (this.getStreamFormatVersion() != 2) continue;
                ((ValueInputStream)((java.lang.Object)this.getOrbStream())).start_value();
                ((ValueInputStream)((java.lang.Object)this.getOrbStream())).end_value();
                continue;
            }
            this.inputClassFields(null, null, null, fullValueDescription.members, codeBase);
        }
        return null;
    }

    private int findNextClass(String string, Class[] classArray, int n, int n2) {
        for (int i = n; i > n2; --i) {
            if (!string.equals(classArray[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private boolean invokeObjectReader(ObjectStreamClass objectStreamClass, java.lang.Object object, Class clazz) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (objectStreamClass.readObjectMethod == null) {
            return false;
        }
        try {
            objectStreamClass.readObjectMethod.invoke(object, this.readObjectArgList);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("internal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    private void resetStream() throws IOException {
        int n;
        if (this.classes == null) {
            this.classes = new Class[20];
        } else {
            for (n = 0; n < this.classes.length; ++n) {
                this.classes[n] = null;
            }
        }
        if (this.classdesc == null) {
            this.classdesc = new ObjectStreamClass[20];
        } else {
            for (n = 0; n < this.classdesc.length; ++n) {
                this.classdesc[n] = null;
            }
        }
        this.spClass = 0;
        if (this.callbacks != null) {
            this.callbacks.setSize(0);
        }
    }

    private void inputPrimitiveField(java.lang.Object object, Class clazz, ObjectStreamField objectStreamField) throws InvalidClassException, IOException {
        try {
            switch (objectStreamField.getTypeCode()) {
                case 'B': {
                    byte by = this.orbStream.read_octet();
                    bridge.putByte(object, objectStreamField.getFieldID(), by);
                    break;
                }
                case 'Z': {
                    boolean bl = this.orbStream.read_boolean();
                    bridge.putBoolean(object, objectStreamField.getFieldID(), bl);
                    break;
                }
                case 'C': {
                    char c = this.orbStream.read_wchar();
                    bridge.putChar(object, objectStreamField.getFieldID(), c);
                    break;
                }
                case 'S': {
                    short s = this.orbStream.read_short();
                    bridge.putShort(object, objectStreamField.getFieldID(), s);
                    break;
                }
                case 'I': {
                    int n = this.orbStream.read_long();
                    bridge.putInt(object, objectStreamField.getFieldID(), n);
                    break;
                }
                case 'J': {
                    long l = this.orbStream.read_longlong();
                    bridge.putLong(object, objectStreamField.getFieldID(), l);
                    break;
                }
                case 'F': {
                    float f = this.orbStream.read_float();
                    bridge.putFloat(object, objectStreamField.getFieldID(), f);
                    break;
                }
                case 'D': {
                    double d = this.orbStream.read_double();
                    bridge.putDouble(object, objectStreamField.getFieldID(), d);
                    break;
                }
                default: {
                    throw new InvalidClassException(clazz.getName());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ClassCastException classCastException = new ClassCastException("Assigning instance of class " + objectStreamField.getType().getName() + " to field " + this.currentClassDesc.getName() + '#' + objectStreamField.getField().getName());
            classCastException.initCause(illegalArgumentException);
            throw classCastException;
        }
    }

    private java.lang.Object inputObjectField(ValueMember valueMember, CodeBase codeBase) throws IndirectionException, ClassNotFoundException, IOException, StreamCorruptedException {
        java.lang.Object object = null;
        Class clazz = null;
        String string = valueMember.id;
        try {
            clazz = this.vhandler.getClassFromType(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        String string2 = null;
        if (clazz != null) {
            string2 = ValueUtility.getSignature(valueMember);
        }
        if (string2 != null && (string2.equals("Ljava/lang/Object;") || string2.equals("Ljava/io/Serializable;") || string2.equals("Ljava/io/Externalizable;"))) {
            object = Util.readAny(this.orbStream);
        } else {
            int n = 2;
            if (!this.vhandler.isSequence(string)) {
                if (valueMember.type.kind().value() == kRemoteTypeCode.kind().value()) {
                    n = 0;
                } else if (clazz != null && clazz.isInterface() && (this.vhandler.isAbstractBase(clazz) || ObjectStreamClassCorbaExt.isAbstractInterface(clazz))) {
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    if (clazz != null) {
                        object = Utility.readObjectAndNarrow(this.orbStream, clazz);
                        break;
                    }
                    object = this.orbStream.read_Object();
                    break;
                }
                case 1: {
                    if (clazz != null) {
                        object = Utility.readAbstractAndNarrow(this.orbStream, clazz);
                        break;
                    }
                    object = this.orbStream.read_abstract_interface();
                    break;
                }
                case 2: {
                    if (clazz != null) {
                        object = this.orbStream.read_value(clazz);
                        break;
                    }
                    object = this.orbStream.read_value();
                    break;
                }
                default: {
                    throw new StreamCorruptedException("Unknown callType: " + n);
                }
            }
        }
        return object;
    }

    private java.lang.Object inputObjectField(ObjectStreamField objectStreamField) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IndirectionException, IOException {
        Class clazz;
        if (ObjectStreamClassCorbaExt.isAny(objectStreamField.getTypeString())) {
            return Util.readAny(this.orbStream);
        }
        java.lang.Object object = null;
        Class clazz2 = clazz = objectStreamField.getType();
        int n = 2;
        boolean bl = false;
        if (clazz.isInterface()) {
            boolean bl2 = false;
            if (Remote.class.isAssignableFrom(clazz)) {
                n = 0;
            } else if (Object.class.isAssignableFrom(clazz)) {
                n = 0;
                bl2 = true;
            } else if (this.vhandler.isAbstractBase(clazz)) {
                n = 1;
                bl2 = true;
            } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                n = 1;
            }
            if (bl2) {
                try {
                    Class clazz3;
                    String string = Util.getCodebase(clazz);
                    String string2 = this.vhandler.createForAnyType(clazz);
                    clazz2 = clazz3 = Utility.loadStubClass(string2, string, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        switch (n) {
            case 0: {
                if (!bl) {
                    object = this.orbStream.read_Object(clazz2);
                    break;
                }
                object = Utility.readObjectAndNarrow(this.orbStream, clazz2);
                break;
            }
            case 1: {
                if (!bl) {
                    object = this.orbStream.read_abstract_interface(clazz2);
                    break;
                }
                object = Utility.readAbstractAndNarrow(this.orbStream, clazz2);
                break;
            }
            case 2: {
                object = this.orbStream.read_value(clazz2);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown callType: " + n);
            }
        }
        return object;
    }

    private final boolean mustUseRemoteValueMembers() {
        return this.defaultReadObjectFVDMembers != null;
    }

    void readFields(Map map) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (this.mustUseRemoteValueMembers()) {
            this.inputRemoteMembersForReadFields(map);
        } else {
            this.inputCurrentClassFieldsForReadFields(map);
        }
    }

    private final void inputRemoteMembersForReadFields(Map map) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        ValueMember[] valueMemberArray = this.defaultReadObjectFVDMembers;
        this.defaultReadObjectFVDMembers = null;
        try {
            block15: for (int i = 0; i < valueMemberArray.length; ++i) {
                switch (valueMemberArray[i].type.kind().value()) {
                    case 10: {
                        byte by = this.orbStream.read_octet();
                        map.put(valueMemberArray[i].name, new Byte(by));
                        continue block15;
                    }
                    case 8: {
                        boolean bl = this.orbStream.read_boolean();
                        map.put(valueMemberArray[i].name, new Boolean(bl));
                        continue block15;
                    }
                    case 9: 
                    case 26: {
                        char c = this.orbStream.read_wchar();
                        map.put(valueMemberArray[i].name, new Character(c));
                        continue block15;
                    }
                    case 2: {
                        short s = this.orbStream.read_short();
                        map.put(valueMemberArray[i].name, new Short(s));
                        continue block15;
                    }
                    case 3: {
                        int n = this.orbStream.read_long();
                        map.put(valueMemberArray[i].name, new Integer(n));
                        continue block15;
                    }
                    case 23: {
                        long l = this.orbStream.read_longlong();
                        map.put(valueMemberArray[i].name, new Long(l));
                        continue block15;
                    }
                    case 6: {
                        float f = this.orbStream.read_float();
                        map.put(valueMemberArray[i].name, new Float(f));
                        continue block15;
                    }
                    case 7: {
                        double d = this.orbStream.read_double();
                        map.put(valueMemberArray[i].name, new Double(d));
                        continue block15;
                    }
                    case 14: 
                    case 29: 
                    case 30: {
                        java.lang.Object object = null;
                        try {
                            object = this.inputObjectField(valueMemberArray[i], this.cbSender);
                        }
                        catch (IndirectionException indirectionException) {
                            object = this.activeRecursionMgr.getObject(indirectionException.offset);
                        }
                        map.put(valueMemberArray[i].name, object);
                        continue block15;
                    }
                    default: {
                        throw new StreamCorruptedException("Unknown kind: " + valueMemberArray[i].type.kind().value());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(throwable.getMessage());
            streamCorruptedException.initCause(throwable);
            throw streamCorruptedException;
        }
    }

    private final void inputCurrentClassFieldsForReadFields(Map map) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        int n;
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        int n2 = objectStreamFieldArray.length - this.currentClassDesc.objFields;
        block12: for (n = 0; n < n2; ++n) {
            switch (objectStreamFieldArray[n].getTypeCode()) {
                case 'B': {
                    byte by = this.orbStream.read_octet();
                    map.put(objectStreamFieldArray[n].getName(), new Byte(by));
                    continue block12;
                }
                case 'Z': {
                    boolean bl = this.orbStream.read_boolean();
                    map.put(objectStreamFieldArray[n].getName(), new Boolean(bl));
                    continue block12;
                }
                case 'C': {
                    char c = this.orbStream.read_wchar();
                    map.put(objectStreamFieldArray[n].getName(), new Character(c));
                    continue block12;
                }
                case 'S': {
                    short s = this.orbStream.read_short();
                    map.put(objectStreamFieldArray[n].getName(), new Short(s));
                    continue block12;
                }
                case 'I': {
                    int n3 = this.orbStream.read_long();
                    map.put(objectStreamFieldArray[n].getName(), new Integer(n3));
                    continue block12;
                }
                case 'J': {
                    long l = this.orbStream.read_longlong();
                    map.put(objectStreamFieldArray[n].getName(), new Long(l));
                    continue block12;
                }
                case 'F': {
                    float f = this.orbStream.read_float();
                    map.put(objectStreamFieldArray[n].getName(), new Float(f));
                    continue block12;
                }
                case 'D': {
                    double d = this.orbStream.read_double();
                    map.put(objectStreamFieldArray[n].getName(), new Double(d));
                    continue block12;
                }
                default: {
                    throw new InvalidClassException(this.currentClassDesc.getName());
                }
            }
        }
        if (this.currentClassDesc.objFields > 0) {
            for (n = n2; n < objectStreamFieldArray.length; ++n) {
                java.lang.Object object = null;
                try {
                    object = this.inputObjectField(objectStreamFieldArray[n]);
                }
                catch (IndirectionException indirectionException) {
                    object = this.activeRecursionMgr.getObject(indirectionException.offset);
                }
                map.put(objectStreamFieldArray[n].getName(), object);
            }
        }
    }

    private void inputClassFields(java.lang.Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray, CodeBase codeBase) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        int n;
        int n2 = objectStreamFieldArray.length - this.currentClassDesc.objFields;
        if (object != null) {
            for (n = 0; n < n2; ++n) {
                if (objectStreamFieldArray[n].getField() == null) continue;
                this.inputPrimitiveField(object, clazz, objectStreamFieldArray[n]);
            }
        }
        if (this.currentClassDesc.objFields > 0) {
            for (n = n2; n < objectStreamFieldArray.length; ++n) {
                java.lang.Object object2 = null;
                try {
                    object2 = this.inputObjectField(objectStreamFieldArray[n]);
                }
                catch (IndirectionException indirectionException) {
                    object2 = this.activeRecursionMgr.getObject(indirectionException.offset);
                }
                if (object == null || objectStreamFieldArray[n].getField() == null) continue;
                try {
                    bridge.putObject(object, objectStreamFieldArray[n].getFieldID(), object2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ClassCastException classCastException = new ClassCastException("Assigning instance of class " + object2.getClass().getName() + " to field " + this.currentClassDesc.getName() + '#' + objectStreamFieldArray[n].getField().getName());
                    classCastException.initCause(illegalArgumentException);
                    throw classCastException;
                }
            }
        }
    }

    private void inputClassFields(java.lang.Object object, Class clazz, ObjectStreamClass objectStreamClass, ValueMember[] valueMemberArray, CodeBase codeBase) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        try {
            block19: for (int i = 0; i < valueMemberArray.length; ++i) {
                try {
                    switch (valueMemberArray[i].type.kind().value()) {
                        case 10: {
                            byte by = this.orbStream.read_octet();
                            if (object == null || !objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                            IIOPInputStream.setByteField(object, clazz, valueMemberArray[i].name, by);
                            break;
                        }
                        case 8: {
                            boolean bl = this.orbStream.read_boolean();
                            if (object == null || !objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                            IIOPInputStream.setBooleanField(object, clazz, valueMemberArray[i].name, bl);
                            break;
                        }
                        case 9: 
                        case 26: {
                            char c = this.orbStream.read_wchar();
                            if (object == null || !objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                            IIOPInputStream.setCharField(object, clazz, valueMemberArray[i].name, c);
                            break;
                        }
                        case 2: {
                            short s = this.orbStream.read_short();
                            if (object == null || !objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                            IIOPInputStream.setShortField(object, clazz, valueMemberArray[i].name, s);
                            break;
                        }
                        case 3: {
                            int n = this.orbStream.read_long();
                            if (object == null || !objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                            IIOPInputStream.setIntField(object, clazz, valueMemberArray[i].name, n);
                            break;
                        }
                        case 23: {
                            long l = this.orbStream.read_longlong();
                            if (object == null || !objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                            IIOPInputStream.setLongField(object, clazz, valueMemberArray[i].name, l);
                            break;
                        }
                        case 6: {
                            float f = this.orbStream.read_float();
                            if (object == null || !objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                            IIOPInputStream.setFloatField(object, clazz, valueMemberArray[i].name, f);
                            break;
                        }
                        case 7: {
                            double d = this.orbStream.read_double();
                            if (object == null || !objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                            IIOPInputStream.setDoubleField(object, clazz, valueMemberArray[i].name, d);
                            break;
                        }
                        case 14: 
                        case 29: 
                        case 30: {
                            java.lang.Object object2 = null;
                            try {
                                object2 = this.inputObjectField(valueMemberArray[i], codeBase);
                            }
                            catch (IndirectionException indirectionException) {
                                object2 = this.activeRecursionMgr.getObject(indirectionException.offset);
                            }
                            if (object == null) continue block19;
                            try {
                                if (!objectStreamClass.hasField(valueMemberArray[i])) continue block19;
                                IIOPInputStream.setObjectField(object, clazz, valueMemberArray[i].name, object2);
                                break;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                ClassCastException classCastException = new ClassCastException("Assigning instance of class " + object2.getClass().getName() + " to field " + valueMemberArray[i].name);
                                classCastException.initCause(illegalArgumentException);
                                throw classCastException;
                            }
                        }
                        default: {
                            throw new StreamCorruptedException("Unknown kind: " + valueMemberArray[i].type.kind().value());
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ClassCastException classCastException = new ClassCastException("Assigning instance of class " + valueMemberArray[i].id + " to field " + this.currentClassDesc.getName() + '#' + valueMemberArray[i].name);
                    classCastException.initCause(illegalArgumentException);
                    throw classCastException;
                }
            }
        }
        catch (Throwable throwable) {
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(throwable.getMessage());
            streamCorruptedException.initCause(throwable);
            throw streamCorruptedException;
        }
    }

    private void skipCustomUsingFVD(ValueMember[] valueMemberArray, CodeBase codeBase) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        this.readFormatVersion();
        boolean bl = this.readBoolean();
        if (bl) {
            this.throwAwayData(valueMemberArray, codeBase);
        }
        if (this.getStreamFormatVersion() == 2) {
            ((ValueInputStream)((java.lang.Object)this.getOrbStream())).start_value();
            ((ValueInputStream)((java.lang.Object)this.getOrbStream())).end_value();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void throwAwayData(ValueMember[] var1_1, CodeBase var2_2) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        block22: for (var3_3 = 0; var3_3 < var1_1.length; ++var3_3) {
            try {
                switch (var1_1[var3_3].type.kind().value()) {
                    case 10: {
                        this.orbStream.read_octet();
                        break;
                    }
                    case 8: {
                        this.orbStream.read_boolean();
                        break;
                    }
                    case 9: 
                    case 26: {
                        this.orbStream.read_wchar();
                        break;
                    }
                    case 2: {
                        this.orbStream.read_short();
                        break;
                    }
                    case 3: {
                        this.orbStream.read_long();
                        break;
                    }
                    case 23: {
                        this.orbStream.read_longlong();
                        break;
                    }
                    case 6: {
                        this.orbStream.read_float();
                        break;
                    }
                    case 7: {
                        this.orbStream.read_double();
                        break;
                    }
                    case 14: 
                    case 29: 
                    case 30: {
                        var4_4 = null;
                        var5_6 = var1_1[var3_3].id;
                        try {
                            var4_4 = this.vhandler.getClassFromType((String)var5_6);
                        }
                        catch (ClassNotFoundException var6_8) {
                            var4_4 = null;
                        }
                        var6_7 = null;
                        if (var4_4 != null) {
                            var6_7 = ValueUtility.getSignature(var1_1[var3_3]);
                        }
                        try {
                            if (var6_7 != null && (var6_7.equals("Ljava/lang/Object;") || var6_7.equals("Ljava/io/Serializable;") || var6_7.equals("Ljava/io/Externalizable;"))) {
                                Util.readAny(this.orbStream);
                                ** break;
                            }
                            var7_9 = 2;
                            if (!this.vhandler.isSequence((String)var5_6)) {
                                var8_11 = var2_2.meta(var1_1[var3_3].id);
                                if (IIOPInputStream.kRemoteTypeCode == var1_1[var3_3].type) {
                                    var7_9 = 0;
                                } else if (var8_11.is_abstract) {
                                    var7_9 = 1;
                                }
                            }
                            switch (var7_9) {
                                case 0: {
                                    this.orbStream.read_Object();
                                    ** break;
                                }
                                case 1: {
                                    this.orbStream.read_abstract_interface();
                                    ** break;
                                }
                                case 2: {
                                    if (var4_4 != null) {
                                        this.orbStream.read_value(var4_4);
                                        ** break;
                                    }
                                    this.orbStream.read_value();
                                    ** break;
                                }
                            }
                            throw new StreamCorruptedException("Unknown callType: " + var7_9);
lbl78:
                            // 5 sources

                            break;
                        }
                        catch (IndirectionException var7_10) {
                            continue block22;
                        }
                    }
                    default: {
                        throw new StreamCorruptedException("Unknown kind: " + var1_1[var3_3].type.kind().value());
                    }
                }
                continue;
            }
            catch (IllegalArgumentException var4_5) {
                var5_6 = new ClassCastException("Assigning instance of class " + var1_1[var3_3].id + " to field " + this.currentClassDesc.getName() + '#' + var1_1[var3_3].name);
                var5_6.initCause(var4_5);
                throw var5_6;
            }
        }
    }

    private static void setObjectField(java.lang.Object object, Class clazz, String string, java.lang.Object object2) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l = bridge.objectFieldOffset(field);
            bridge.putObject(object, l, object2);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetObjectField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)object2.toString());
        }
    }

    private static void setBooleanField(java.lang.Object object, Class clazz, String string, boolean bl) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l = bridge.objectFieldOffset(field);
            bridge.putBoolean(object, l, bl);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetBooleanField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)new Boolean(bl));
        }
    }

    private static void setByteField(java.lang.Object object, Class clazz, String string, byte by) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l = bridge.objectFieldOffset(field);
            bridge.putByte(object, l, by);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetByteField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)new Byte(by));
        }
    }

    private static void setCharField(java.lang.Object object, Class clazz, String string, char c) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l = bridge.objectFieldOffset(field);
            bridge.putChar(object, l, c);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetCharField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)new Character(c));
        }
    }

    private static void setShortField(java.lang.Object object, Class clazz, String string, short s) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l = bridge.objectFieldOffset(field);
            bridge.putShort(object, l, s);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetShortField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)new Short(s));
        }
    }

    private static void setIntField(java.lang.Object object, Class clazz, String string, int n) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l = bridge.objectFieldOffset(field);
            bridge.putInt(object, l, n);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetIntField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)new Integer(n));
        }
    }

    private static void setLongField(java.lang.Object object, Class clazz, String string, long l) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l2 = bridge.objectFieldOffset(field);
            bridge.putLong(object, l2, l);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetLongField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)new Long(l));
        }
    }

    private static void setFloatField(java.lang.Object object, Class clazz, String string, float f) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l = bridge.objectFieldOffset(field);
            bridge.putFloat(object, l, f);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetFloatField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)new Float(f));
        }
    }

    private static void setDoubleField(java.lang.Object object, Class clazz, String string, double d) {
        try {
            Field field = clazz.getDeclaredField(string);
            long l = bridge.objectFieldOffset(field);
            bridge.putDouble(object, l, d);
        }
        catch (Exception exception) {
            throw utilWrapper.errorSetDoubleField(exception, (java.lang.Object)string, (java.lang.Object)object.toString(), (java.lang.Object)new Double(d));
        }
    }

    static class ActiveRecursionManager {
        private Map offsetToObjectMap = new HashMap();

        public void addObject(int n, java.lang.Object object) {
            this.offsetToObjectMap.put(new Integer(n), object);
        }

        public java.lang.Object getObject(int n) throws IOException {
            Integer n2 = new Integer(n);
            if (!this.offsetToObjectMap.containsKey(n2)) {
                throw new IOException("Invalid indirection to offset " + n);
            }
            return this.offsetToObjectMap.get(n2);
        }

        public void removeObject(int n) {
            this.offsetToObjectMap.remove(new Integer(n));
        }

        public boolean containsObject(int n) {
            return this.offsetToObjectMap.containsKey(new Integer(n));
        }
    }
}

