/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import com.sun.rmi.rmid.ExecOptionPermission;
import com.sun.rmi.rmid.ExecPermission;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import sun.rmi.log.LogHandler;
import sun.rmi.log.ReliableLog;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.ActivationGroupImpl;
import sun.rmi.server.InactiveGroupException;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.server.PipeWriter;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;
import sun.security.provider.PolicyFile;

public class Activation
implements Serializable {
    private static final long serialVersionUID = 2921265612698155191L;
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 0;
    private static Object execPolicy;
    private static Method execPolicyMethod;
    private static boolean debugExec;
    private Map<ActivationID, ActivationGroupID> idTable = new HashMap<ActivationID, ActivationGroupID>();
    private Map<ActivationGroupID, GroupEntry> groupTable = new HashMap<ActivationGroupID, GroupEntry>();
    private byte majorVersion = 1;
    private byte minorVersion = 0;
    private transient int groupSemaphore;
    private transient int groupCounter;
    private transient ReliableLog log;
    private transient int numUpdates;
    private transient String[] command;
    private static final long groupTimeout;
    private static final int snapshotInterval;
    private static final long execTimeout;
    private static final Object initLock;
    private static boolean initDone;
    private transient Activator activator;
    private transient Activator activatorStub;
    private transient ActivationSystem system;
    private transient ActivationSystem systemStub;
    private transient ActivationMonitor monitor;
    private transient Registry registry;
    private volatile transient boolean shuttingDown = false;
    private volatile transient Object startupLock;
    private transient Thread shutdownHook;
    private static ResourceBundle resources;

    private static int getInt(String string, int n) {
        return AccessController.doPrivileged(new GetIntegerAction(string, n));
    }

    private Activation() {
    }

    private static void startActivation(int n, RMIServerSocketFactory rMIServerSocketFactory, String string, String[] stringArray) throws Exception {
        ReliableLog reliableLog = new ReliableLog(string, new ActLogHandler());
        Activation activation = (Activation)reliableLog.recover();
        activation.init(n, rMIServerSocketFactory, reliableLog, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(int n, RMIServerSocketFactory rMIServerSocketFactory, ReliableLog reliableLog, String[] stringArray) throws Exception {
        this.log = reliableLog;
        this.numUpdates = 0;
        this.shutdownHook = new ShutdownHook();
        this.groupSemaphore = Activation.getInt("sun.rmi.activation.groupThrottle", 3);
        this.groupCounter = 0;
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        ActivationGroupID[] activationGroupIDArray = this.groupTable.keySet().toArray(new ActivationGroupID[this.groupTable.size()]);
        Object object = this.startupLock = new Object();
        synchronized (this.startupLock) {
            this.activator = new ActivatorImpl(n, rMIServerSocketFactory);
            this.activatorStub = (Activator)RemoteObject.toStub(this.activator);
            this.system = new ActivationSystemImpl(n, rMIServerSocketFactory);
            this.systemStub = (ActivationSystem)RemoteObject.toStub(this.system);
            this.monitor = new ActivationMonitorImpl(n, rMIServerSocketFactory);
            this.initCommand(stringArray);
            this.registry = new SystemRegistryImpl(n, null, rMIServerSocketFactory, this.systemStub);
            if (rMIServerSocketFactory != null) {
                Object object2 = initLock;
                synchronized (object2) {
                    initDone = true;
                    initLock.notifyAll();
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.startupLock = null;
            int n2 = activationGroupIDArray.length;
            while (--n2 >= 0) {
                try {
                    this.getGroupEntry(activationGroupIDArray[n2]).restartServices();
                }
                catch (UnknownGroupException unknownGroupException) {
                    System.err.println(Activation.getTextResource("rmid.restart.group.warning"));
                    unknownGroupException.printStackTrace();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdown() throws ActivationException {
        Object object = this.startupLock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
            }
        }
        if (this.shuttingDown) {
            throw new ActivationException("activation system shutting down");
        }
    }

    private static void unexport(Remote remote) {
        while (true) {
            try {
                while (!UnicastRemoteObject.unexportObject(remote, false)) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivationGroupID getGroupID(ActivationID activationID) throws UnknownObjectException {
        Map<ActivationID, ActivationGroupID> map = this.idTable;
        synchronized (map) {
            ActivationGroupID activationGroupID = this.idTable.get(activationID);
            if (activationGroupID != null) {
                return activationGroupID;
            }
        }
        throw new UnknownObjectException("unknown object: " + activationID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupEntry getGroupEntry(ActivationGroupID activationGroupID) throws UnknownGroupException {
        if (activationGroupID.getClass() == ActivationGroupID.class) {
            Map<ActivationGroupID, GroupEntry> map = this.groupTable;
            synchronized (map) {
                GroupEntry groupEntry = this.groupTable.get(activationGroupID);
                if (groupEntry != null && !groupEntry.removed) {
                    return groupEntry;
                }
            }
        }
        throw new UnknownGroupException("group unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupEntry getGroupEntry(ActivationID activationID) throws UnknownObjectException {
        ActivationGroupID activationGroupID = this.getGroupID(activationID);
        Map<ActivationGroupID, GroupEntry> map = this.groupTable;
        synchronized (map) {
            GroupEntry groupEntry = this.groupTable.get(activationGroupID);
            if (groupEntry != null) {
                return groupEntry;
            }
        }
        throw new UnknownObjectException("object's group removed");
    }

    private String[] activationArgs(ActivationGroupDesc activationGroupDesc) {
        Properties properties;
        ActivationGroupDesc.CommandEnvironment commandEnvironment = activationGroupDesc.getCommandEnvironment();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(commandEnvironment != null && commandEnvironment.getCommandPath() != null ? commandEnvironment.getCommandPath() : this.command[0]);
        if (commandEnvironment != null && commandEnvironment.getCommandOptions() != null) {
            arrayList.addAll(Arrays.asList(commandEnvironment.getCommandOptions()));
        }
        if ((properties = activationGroupDesc.getPropertyOverrides()) != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                arrayList.add("-D" + string + "=" + properties.getProperty(string));
            }
        }
        for (int i = 1; i < this.command.length; ++i) {
            arrayList.add(this.command[i]);
        }
        String[] stringArray = new String[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    private void checkArgs(ActivationGroupDesc activationGroupDesc, String[] stringArray) throws SecurityException, ActivationException {
        if (execPolicyMethod != null) {
            if (stringArray == null) {
                stringArray = this.activationArgs(activationGroupDesc);
            }
            try {
                execPolicyMethod.invoke(execPolicy, activationGroupDesc, stringArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SecurityException) {
                    throw (SecurityException)throwable;
                }
                throw new ActivationException(execPolicyMethod.getName() + ": unexpected exception", invocationTargetException);
            }
            catch (Exception exception) {
                throw new ActivationException(execPolicyMethod.getName() + ": unexpected exception", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogRecord(LogRecord logRecord) throws ActivationException {
        ReliableLog reliableLog = this.log;
        synchronized (reliableLog) {
            this.checkShutdown();
            try {
                this.log.update(logRecord, true);
            }
            catch (Exception exception) {
                this.numUpdates = snapshotInterval;
                System.err.println(Activation.getTextResource("rmid.log.update.warning"));
                exception.printStackTrace();
            }
            if (++this.numUpdates < snapshotInterval) {
                return;
            }
            try {
                this.log.snapshot(this);
                this.numUpdates = 0;
            }
            catch (Exception exception) {
                System.err.println(Activation.getTextResource("rmid.log.snapshot.warning"));
                exception.printStackTrace();
                try {
                    this.system.shutdown();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                throw new ActivationException("log snapshot failed", exception);
            }
        }
    }

    private void initCommand(String[] stringArray) {
        this.command = new String[stringArray.length + 2];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    ((Activation)Activation.this).command[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                }
                catch (Exception exception) {
                    System.err.println(Activation.getTextResource("rmid.unfound.java.home.property"));
                    ((Activation)Activation.this).command[0] = "java";
                }
                return null;
            }
        });
        System.arraycopy(stringArray, 0, this.command, 1, stringArray.length);
        this.command[this.command.length - 1] = "sun.rmi.server.ActivationGroupInit";
    }

    private static void bomb(String string) {
        System.err.println("rmid: " + string);
        System.err.println(MessageFormat.format(Activation.getTextResource("rmid.usage"), "rmid"));
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            Object object;
            int n = 1098;
            ActivationServerSocketFactory activationServerSocketFactory = null;
            Channel channel = AccessController.doPrivileged(new PrivilegedExceptionAction<Channel>(){

                @Override
                public Channel run() throws IOException {
                    return System.inheritedChannel();
                }
            });
            if (channel != null && channel instanceof ServerSocketChannel) {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        File file = File.createTempFile("rmid-err", null, null);
                        PrintStream printStream = new PrintStream(new FileOutputStream(file));
                        System.setErr(printStream);
                        return null;
                    }
                });
                object = ((ServerSocketChannel)channel).socket();
                n = ((ServerSocket)object).getLocalPort();
                activationServerSocketFactory = new ActivationServerSocketFactory((ServerSocket)object);
                System.err.println(new Date());
                System.err.println(Activation.getTextResource("rmid.inherited.channel.info") + ": " + channel);
            }
            object = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-port")) {
                    if (activationServerSocketFactory != null) {
                        Activation.bomb(Activation.getTextResource("rmid.syntax.port.badarg"));
                    }
                    if (i + 1 < stringArray.length) {
                        try {
                            n = Integer.parseInt(stringArray[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Activation.bomb(Activation.getTextResource("rmid.syntax.port.badnumber"));
                        }
                        continue;
                    }
                    Activation.bomb(Activation.getTextResource("rmid.syntax.port.missing"));
                    continue;
                }
                if (stringArray[i].equals("-log")) {
                    if (i + 1 < stringArray.length) {
                        object = stringArray[++i];
                        continue;
                    }
                    Activation.bomb(Activation.getTextResource("rmid.syntax.log.missing"));
                    continue;
                }
                if (stringArray[i].equals("-stop")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].startsWith("-C")) {
                    arrayList.add(stringArray[i].substring(2));
                    continue;
                }
                Activation.bomb(MessageFormat.format(Activation.getTextResource("rmid.syntax.illegal.option"), stringArray[i]));
            }
            if (object == null) {
                if (activationServerSocketFactory != null) {
                    Activation.bomb(Activation.getTextResource("rmid.syntax.log.required"));
                } else {
                    object = "log";
                }
            }
            debugExec = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.activation.debugExec"));
            String string = AccessController.doPrivileged(new GetPropertyAction("sun.rmi.activation.execPolicy", null));
            if (string == null) {
                if (!bl) {
                    DefaultExecPolicy.checkConfiguration();
                }
                string = "default";
            }
            if (!string.equals("none")) {
                if (string.equals("") || string.equals("default")) {
                    string = DefaultExecPolicy.class.getName();
                }
                try {
                    Class<?> clazz = RMIClassLoader.loadClass(string);
                    execPolicy = clazz.newInstance();
                    execPolicyMethod = clazz.getMethod("checkExecCommand", ActivationGroupDesc.class, String[].class);
                }
                catch (Exception exception) {
                    if (debugExec) {
                        System.err.println(Activation.getTextResource("rmid.exec.policy.exception"));
                        exception.printStackTrace();
                    }
                    Activation.bomb(Activation.getTextResource("rmid.exec.policy.invalid"));
                }
            }
            if (bl) {
                final int n2 = n;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        System.setProperty("java.rmi.activation.port", Integer.toString(n2));
                        return null;
                    }
                });
                ActivationSystem activationSystem = ActivationGroup.getSystem();
                activationSystem.shutdown();
                System.exit(0);
            }
            Activation.startActivation(n, activationServerSocketFactory, (String)object, arrayList.toArray(new String[arrayList.size()]));
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println(MessageFormat.format(Activation.getTextResource("rmid.unexpected.exception"), exception));
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private static String getTextResource(String string) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.rmid.resources.rmid");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resources == null) {
                return "[missing resource file: " + string + "]";
            }
        }
        String string2 = null;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == null) {
            return "[missing resource: " + string + "]";
        }
        return string2;
    }

    private synchronized String Pstartgroup() throws ActivationException {
        while (true) {
            this.checkShutdown();
            if (this.groupSemaphore > 0) {
                --this.groupSemaphore;
                return "Group-" + this.groupCounter++;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized void Vstartgroup() {
        ++this.groupSemaphore;
        this.notifyAll();
    }

    static {
        groupTimeout = Activation.getInt("sun.rmi.activation.groupTimeout", 60000);
        snapshotInterval = Activation.getInt("sun.rmi.activation.snapshotInterval", 200);
        execTimeout = Activation.getInt("sun.rmi.activation.execTimeout", 30000);
        initLock = new Object();
        initDone = false;
        resources = null;
    }

    private static class ActLogHandler
    extends LogHandler {
        ActLogHandler() {
        }

        public Object initialSnapshot() {
            return new Activation();
        }

        public Object applyUpdate(Object object, Object object2) throws Exception {
            return ((LogRecord)object).apply(object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ActivationMonitorImpl
    extends UnicastRemoteObject
    implements ActivationMonitor {
        private static final long serialVersionUID = -6214940464757948867L;

        ActivationMonitorImpl(int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
            super(n, null, rMIServerSocketFactory);
        }

        @Override
        public void inactiveObject(ActivationID activationID) throws UnknownObjectException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("Activator.inactiveObject");
            Activation.this.getGroupEntry(activationID).inactiveObject(activationID);
        }

        @Override
        public void activeObject(ActivationID activationID, MarshalledObject<? extends Remote> marshalledObject) throws UnknownObjectException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("ActivationSystem.activeObject");
            Activation.this.getGroupEntry(activationID).activeObject(activationID, marshalledObject);
        }

        @Override
        public void inactiveGroup(ActivationGroupID activationGroupID, long l) throws UnknownGroupException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("ActivationMonitor.inactiveGroup");
            Activation.this.getGroupEntry(activationGroupID).inactiveGroup(l, false);
        }
    }

    private static class ActivationServerSocketFactory
    implements RMIServerSocketFactory {
        private final ServerSocket serverSocket;

        ActivationServerSocketFactory(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public ServerSocket createServerSocket(int n) throws IOException {
            return new DelayedAcceptServerSocket(this.serverSocket);
        }
    }

    class ActivationSystemImpl
    extends RemoteServer
    implements ActivationSystem {
        private static final long serialVersionUID = 9100152600327688967L;

        ActivationSystemImpl(int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
            LiveRef liveRef = new LiveRef(new ObjID(4), n, null, rMIServerSocketFactory);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            this.ref = unicastServerRef;
            unicastServerRef.exportObject(this, null);
        }

        public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.registerObject");
            ActivationGroupID activationGroupID = activationDesc.getGroupID();
            ActivationID activationID = new ActivationID(Activation.this.activatorStub);
            Activation.this.getGroupEntry(activationGroupID).registerObject(activationID, activationDesc, true);
            return activationID;
        }

        public void unregisterObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.unregisterObject");
            Activation.this.getGroupEntry(activationID).unregisterObject(activationID, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.registerGroup");
            Activation.this.checkArgs(activationGroupDesc, null);
            ActivationGroupID activationGroupID = new ActivationGroupID(Activation.this.systemStub);
            GroupEntry groupEntry = new GroupEntry(activationGroupID, activationGroupDesc);
            Map map = Activation.this.groupTable;
            synchronized (map) {
                Activation.this.groupTable.put(activationGroupID, groupEntry);
            }
            Activation.this.addLogRecord(new LogRegisterGroup(activationGroupID, activationGroupDesc));
            return activationGroupID;
        }

        public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.activeGroup");
            Activation.this.getGroupEntry(activationGroupID).activeGroup(activationInstantiator, l);
            return Activation.this.monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.unregisterGroup");
            Map map = Activation.this.groupTable;
            synchronized (map) {
                GroupEntry groupEntry = Activation.this.getGroupEntry(activationGroupID);
                Activation.this.groupTable.remove(activationGroupID);
                groupEntry.unregisterGroup(true);
            }
        }

        public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.setActivationDesc");
            if (!Activation.this.getGroupID(activationID).equals(activationDesc.getGroupID())) {
                throw new ActivationException("ActivationDesc contains wrong group");
            }
            return Activation.this.getGroupEntry(activationID).setActivationDesc(activationID, activationDesc, true);
        }

        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.setActivationGroupDesc");
            Activation.this.checkArgs(activationGroupDesc, null);
            return Activation.this.getGroupEntry(activationGroupID).setActivationGroupDesc(activationGroupID, activationGroupDesc, true);
        }

        public ActivationDesc getActivationDesc(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.getActivationDesc");
            return Activation.this.getGroupEntry(activationID).getActivationDesc(activationID);
        }

        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.getActivationGroupDesc");
            return ((Activation)Activation.this).getGroupEntry((ActivationGroupID)activationGroupID).desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws AccessException {
            Object object;
            RegistryImpl.checkAccess("ActivationSystem.shutdown");
            Object object2 = Activation.this.startupLock;
            if (object2 != null) {
                object = object2;
                synchronized (object) {
                }
            }
            object = Activation.this;
            synchronized (object) {
                if (!Activation.this.shuttingDown) {
                    Activation.this.shuttingDown = true;
                    new Shutdown().start();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ActivatorImpl
    extends RemoteServer
    implements Activator {
        private static final long serialVersionUID = -3654244726254566136L;

        ActivatorImpl(int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
            LiveRef liveRef = new LiveRef(new ObjID(1), n, null, rMIServerSocketFactory);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            this.ref = unicastServerRef;
            unicastServerRef.exportObject(this, null, false);
        }

        @Override
        public MarshalledObject<? extends Remote> activate(ActivationID activationID, boolean bl) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            return Activation.this.getGroupEntry(activationID).activate(activationID, bl);
        }
    }

    public static class DefaultExecPolicy {
        public void checkExecCommand(ActivationGroupDesc activationGroupDesc, String[] stringArray) throws SecurityException {
            Object object;
            String string;
            Object object2;
            Object object3;
            PermissionCollection permissionCollection = DefaultExecPolicy.getExecPermissions();
            Properties properties = activationGroupDesc.getPropertyOverrides();
            if (properties != null) {
                object3 = properties.propertyNames();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    string = properties.getProperty((String)object2);
                    object = "-D" + (String)object2 + "=" + string;
                    try {
                        DefaultExecPolicy.checkPermission(permissionCollection, new ExecOptionPermission((String)object));
                    }
                    catch (AccessControlException accessControlException) {
                        if (string.equals("")) {
                            DefaultExecPolicy.checkPermission(permissionCollection, new ExecOptionPermission("-D" + (String)object2));
                            continue;
                        }
                        throw accessControlException;
                    }
                }
            }
            if ((object3 = activationGroupDesc.getClassName()) != null && !((String)object3).equals(ActivationGroupImpl.class.getName()) || activationGroupDesc.getLocation() != null || activationGroupDesc.getData() != null) {
                throw new AccessControlException("access denied (custom group implementation not allowed)");
            }
            object2 = activationGroupDesc.getCommandEnvironment();
            if (object2 != null) {
                string = ((ActivationGroupDesc.CommandEnvironment)object2).getCommandPath();
                if (string != null) {
                    DefaultExecPolicy.checkPermission(permissionCollection, new ExecPermission(string));
                }
                if ((object = ((ActivationGroupDesc.CommandEnvironment)object2).getCommandOptions()) != null) {
                    for (String string2 : object) {
                        DefaultExecPolicy.checkPermission(permissionCollection, new ExecOptionPermission(string2));
                    }
                }
            }
        }

        static void checkConfiguration() {
            Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

                @Override
                public Policy run() {
                    return Policy.getPolicy();
                }
            });
            if (!(policy instanceof PolicyFile)) {
                return;
            }
            PermissionCollection permissionCollection = DefaultExecPolicy.getExecPermissions();
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = enumeration.nextElement();
                if (!(permission instanceof AllPermission) && !(permission instanceof ExecPermission) && !(permission instanceof ExecOptionPermission)) continue;
                return;
            }
            System.err.println(Activation.getTextResource("rmid.exec.perms.inadequate"));
        }

        private static PermissionCollection getExecPermissions() {
            PermissionCollection permissionCollection = AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

                @Override
                public PermissionCollection run() {
                    CodeSource codeSource = new CodeSource(null, (Certificate[])null);
                    Policy policy = Policy.getPolicy();
                    if (policy != null) {
                        return policy.getPermissions(codeSource);
                    }
                    return new Permissions();
                }
            });
            return permissionCollection;
        }

        private static void checkPermission(PermissionCollection permissionCollection, Permission permission) throws AccessControlException {
            if (!permissionCollection.implies(permission)) {
                throw new AccessControlException("access denied " + permission.toString());
            }
        }
    }

    private static class DelayedAcceptServerSocket
    extends ServerSocket {
        private final ServerSocket serverSocket;

        DelayedAcceptServerSocket(ServerSocket serverSocket) throws IOException {
            this.serverSocket = serverSocket;
        }

        public void bind(SocketAddress socketAddress) throws IOException {
            this.serverSocket.bind(socketAddress);
        }

        public void bind(SocketAddress socketAddress, int n) throws IOException {
            this.serverSocket.bind(socketAddress, n);
        }

        public InetAddress getInetAddress() {
            return this.serverSocket.getInetAddress();
        }

        public int getLocalPort() {
            return this.serverSocket.getLocalPort();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.serverSocket.getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket accept() throws IOException {
            Object object = initLock;
            synchronized (object) {
                try {
                    while (!initDone) {
                        initLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new AssertionError((Object)interruptedException);
                }
            }
            return this.serverSocket.accept();
        }

        public void close() throws IOException {
            this.serverSocket.close();
        }

        public ServerSocketChannel getChannel() {
            return this.serverSocket.getChannel();
        }

        public boolean isBound() {
            return this.serverSocket.isBound();
        }

        public boolean isClosed() {
            return this.serverSocket.isClosed();
        }

        public void setSoTimeout(int n) throws SocketException {
            this.serverSocket.setSoTimeout(n);
        }

        public int getSoTimeout() throws IOException {
            return this.serverSocket.getSoTimeout();
        }

        public void setReuseAddress(boolean bl) throws SocketException {
            this.serverSocket.setReuseAddress(bl);
        }

        public boolean getReuseAddress() throws SocketException {
            return this.serverSocket.getReuseAddress();
        }

        public String toString() {
            return this.serverSocket.toString();
        }

        public void setReceiveBufferSize(int n) throws SocketException {
            this.serverSocket.setReceiveBufferSize(n);
        }

        public int getReceiveBufferSize() throws SocketException {
            return this.serverSocket.getReceiveBufferSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupEntry
    implements Serializable {
        private static final long serialVersionUID = 7222464070032993304L;
        private static final int MAX_TRIES = 2;
        private static final int NORMAL = 0;
        private static final int CREATING = 1;
        private static final int TERMINATE = 2;
        private static final int TERMINATING = 3;
        ActivationGroupDesc desc = null;
        ActivationGroupID groupID = null;
        long incarnation = 0L;
        Map<ActivationID, ObjectEntry> objects = new HashMap<ActivationID, ObjectEntry>();
        Set<ActivationID> restartSet = new HashSet<ActivationID>();
        transient ActivationInstantiator group = null;
        transient int status = 0;
        transient long waitTime = 0L;
        transient String groupName = null;
        transient Process child = null;
        transient boolean removed = false;
        transient Watchdog watchdog = null;

        GroupEntry(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.groupID = activationGroupID;
            this.desc = activationGroupDesc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restartServices() {
            Iterator<ActivationID> iterator = null;
            Serializable serializable = this;
            synchronized (serializable) {
                if (this.restartSet.isEmpty()) {
                    return;
                }
                iterator = new HashSet<ActivationID>(this.restartSet).iterator();
            }
            while (iterator.hasNext()) {
                serializable = iterator.next();
                try {
                    this.activate((ActivationID)serializable, true);
                }
                catch (Exception exception) {
                    if (Activation.this.shuttingDown) {
                        return;
                    }
                    System.err.println(Activation.getTextResource("rmid.restart.service.warning"));
                    exception.printStackTrace();
                }
            }
        }

        synchronized void activeGroup(ActivationInstantiator activationInstantiator, long l) throws ActivationException, UnknownGroupException {
            if (this.incarnation != l) {
                throw new ActivationException("invalid incarnation");
            }
            if (this.group != null) {
                if (this.group.equals(activationInstantiator)) {
                    return;
                }
                throw new ActivationException("group already active");
            }
            if (this.child != null && this.status != 1) {
                throw new ActivationException("group not being created");
            }
            this.group = activationInstantiator;
            this.status = 0;
            this.notifyAll();
        }

        private void checkRemoved() throws UnknownGroupException {
            if (this.removed) {
                throw new UnknownGroupException("group removed");
            }
        }

        private ObjectEntry getObjectEntry(ActivationID activationID) throws UnknownObjectException {
            if (this.removed) {
                throw new UnknownObjectException("object's group removed");
            }
            ObjectEntry objectEntry = this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            return objectEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void registerObject(ActivationID activationID, ActivationDesc activationDesc, boolean bl) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.objects.put(activationID, new ObjectEntry(activationDesc));
            if (activationDesc.getRestartMode()) {
                this.restartSet.add(activationID);
            }
            Map map = Activation.this.idTable;
            synchronized (map) {
                Activation.this.idTable.put(activationID, this.groupID);
            }
            if (bl) {
                Activation.this.addLogRecord(new LogRegisterObject(activationID, activationDesc));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void unregisterObject(ActivationID activationID, boolean bl) throws UnknownGroupException, ActivationException {
            ObjectEntry objectEntry = this.getObjectEntry(activationID);
            objectEntry.removed = true;
            this.objects.remove(activationID);
            if (objectEntry.desc.getRestartMode()) {
                this.restartSet.remove(activationID);
            }
            Map map = Activation.this.idTable;
            synchronized (map) {
                Activation.this.idTable.remove(activationID);
            }
            if (bl) {
                Activation.this.addLogRecord(new LogUnregisterObject(activationID));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void unregisterGroup(boolean bl) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.removed = true;
            for (Map.Entry<ActivationID, ObjectEntry> entry : this.objects.entrySet()) {
                ActivationID activationID = entry.getKey();
                Object object = Activation.this.idTable;
                synchronized (object) {
                    Activation.this.idTable.remove(activationID);
                }
                object = entry.getValue();
                ((ObjectEntry)object).removed = true;
            }
            this.objects.clear();
            this.restartSet.clear();
            this.reset();
            this.childGone();
            if (bl) {
                Activation.this.addLogRecord(new LogUnregisterGroup(this.groupID));
            }
        }

        synchronized ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc, boolean bl) throws UnknownObjectException, UnknownGroupException, ActivationException {
            ObjectEntry objectEntry = this.getObjectEntry(activationID);
            ActivationDesc activationDesc2 = objectEntry.desc;
            objectEntry.desc = activationDesc;
            if (activationDesc.getRestartMode()) {
                this.restartSet.add(activationID);
            } else {
                this.restartSet.remove(activationID);
            }
            if (bl) {
                Activation.this.addLogRecord(new LogUpdateDesc(activationID, activationDesc));
            }
            return activationDesc2;
        }

        synchronized ActivationDesc getActivationDesc(ActivationID activationID) throws UnknownObjectException, UnknownGroupException {
            return this.getObjectEntry((ActivationID)activationID).desc;
        }

        synchronized ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, boolean bl) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            ActivationGroupDesc activationGroupDesc2 = this.desc;
            this.desc = activationGroupDesc;
            if (bl) {
                Activation.this.addLogRecord(new LogUpdateGroupDesc(activationGroupID, activationGroupDesc));
            }
            return activationGroupDesc2;
        }

        synchronized void inactiveGroup(long l, boolean bl) throws UnknownGroupException {
            this.checkRemoved();
            if (this.incarnation != l) {
                throw new UnknownGroupException("invalid incarnation");
            }
            this.reset();
            if (bl) {
                this.terminate();
            } else if (this.child != null && this.status == 0) {
                this.status = 2;
                this.watchdog.noRestart();
            }
        }

        synchronized void activeObject(ActivationID activationID, MarshalledObject<? extends Remote> marshalledObject) throws UnknownObjectException {
            this.getObjectEntry((ActivationID)activationID).stub = marshalledObject;
        }

        synchronized void inactiveObject(ActivationID activationID) throws UnknownObjectException {
            this.getObjectEntry(activationID).reset();
        }

        private synchronized void reset() {
            this.group = null;
            for (ObjectEntry objectEntry : this.objects.values()) {
                objectEntry.reset();
            }
        }

        private void childGone() {
            if (this.child != null) {
                this.child = null;
                this.watchdog.dispose();
                this.watchdog = null;
                this.status = 0;
                this.notifyAll();
            }
        }

        private void terminate() {
            if (this.child != null && this.status != 3) {
                this.child.destroy();
                this.status = 3;
                this.waitTime = System.currentTimeMillis() + groupTimeout;
                this.notifyAll();
            }
        }

        /*
         * Unable to fully structure code
         */
        private void await() {
            while (true) {
                switch (this.status) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        this.terminate();
                    }
                    case 3: {
                        try {
                            this.child.exitValue();
                        }
                        catch (IllegalThreadStateException var1_2) {
                            var2_4 = System.currentTimeMillis();
                            if (this.waitTime <= var2_4) ** GOTO lbl20
                            try {
                                this.wait(this.waitTime - var2_4);
                            }
                            catch (InterruptedException var4_5) {}
                            break;
                        }
lbl20:
                        // 2 sources

                        this.childGone();
                        return;
                    }
                    case 1: {
                        try {
                            this.wait();
                            break;
                        }
                        catch (InterruptedException var1_3) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        void shutdownFast() {
            Process process = this.child;
            if (process != null) {
                process.destroy();
            }
        }

        synchronized void shutdown() {
            this.reset();
            this.terminate();
            this.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MarshalledObject<? extends Remote> activate(ActivationID activationID, boolean bl) throws ActivationException {
            Exception exception = null;
            for (int i = 2; i > 0; --i) {
                boolean bl2;
                boolean bl3;
                long l;
                block13: {
                    ActivationInstantiator activationInstantiator;
                    ObjectEntry objectEntry;
                    GroupEntry groupEntry = this;
                    synchronized (groupEntry) {
                        objectEntry = this.getObjectEntry(activationID);
                        if (!bl && objectEntry.stub != null) {
                            return objectEntry.stub;
                        }
                        activationInstantiator = this.getInstantiator(this.groupID);
                        l = this.incarnation;
                    }
                    bl3 = false;
                    bl2 = false;
                    try {
                        return objectEntry.activate(activationID, bl, activationInstantiator);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        bl3 = true;
                        exception = noSuchObjectException;
                    }
                    catch (ConnectException connectException) {
                        bl3 = true;
                        bl2 = true;
                        exception = connectException;
                    }
                    catch (ConnectIOException connectIOException) {
                        bl3 = true;
                        bl2 = true;
                        exception = connectIOException;
                    }
                    catch (InactiveGroupException inactiveGroupException) {
                        bl3 = true;
                        exception = inactiveGroupException;
                    }
                    catch (RemoteException remoteException) {
                        if (exception != null) break block13;
                        exception = remoteException;
                    }
                }
                if (!bl3) continue;
                try {
                    System.err.println(MessageFormat.format(Activation.getTextResource("rmid.group.inactive"), exception.toString()));
                    exception.printStackTrace();
                    Activation.this.getGroupEntry(this.groupID).inactiveGroup(l, bl2);
                    continue;
                }
                catch (UnknownGroupException unknownGroupException) {
                    // empty catch block
                }
            }
            throw new ActivationException("object activation failed after 2 tries", exception);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ActivationInstantiator getInstantiator(ActivationGroupID activationGroupID) throws ActivationException {
            assert (Thread.holdsLock(this));
            this.await();
            if (this.group != null) {
                return this.group;
            }
            this.checkRemoved();
            boolean bl = false;
            try {
                String string;
                Object object;
                this.groupName = Activation.this.Pstartgroup();
                bl = true;
                String[] stringArray = Activation.this.activationArgs(this.desc);
                Activation.this.checkArgs(this.desc, stringArray);
                if (debugExec) {
                    object = new StringBuffer(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        ((StringBuffer)object).append(' ');
                        ((StringBuffer)object).append(stringArray[i]);
                    }
                    System.err.println(MessageFormat.format(Activation.getTextResource("rmid.exec.command"), ((StringBuffer)object).toString()));
                }
                try {
                    this.child = Runtime.getRuntime().exec(stringArray);
                    this.status = 1;
                    ++this.incarnation;
                    this.watchdog = new Watchdog();
                    this.watchdog.start();
                    Activation.this.addLogRecord(new LogGroupIncarnation(activationGroupID, this.incarnation));
                    PipeWriter.plugTogetherPair(this.child.getInputStream(), System.out, this.child.getErrorStream(), System.err);
                    object = new MarshalOutputStream(this.child.getOutputStream());
                    ((ObjectOutputStream)object).writeObject(activationGroupID);
                    ((ObjectOutputStream)object).writeObject(this.desc);
                    ((ObjectOutputStream)object).writeLong(this.incarnation);
                    ((ObjectOutputStream)object).flush();
                    ((ObjectOutputStream)object).close();
                }
                catch (IOException iOException) {
                    this.terminate();
                    throw new ActivationException("unable to create activation group", iOException);
                }
                try {
                    long l = System.currentTimeMillis();
                    long l2 = l + execTimeout;
                    do {
                        this.wait(l2 - l);
                        if (this.group != null) {
                            ActivationInstantiator activationInstantiator = this.group;
                            return activationInstantiator;
                        }
                        l = System.currentTimeMillis();
                    } while (this.status == 1 && l < l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.terminate();
                if (this.removed) {
                    string = "activation group unregistered";
                    throw new ActivationException(string);
                }
                string = "timeout creating child process";
                throw new ActivationException(string);
            }
            finally {
                if (bl) {
                    Activation.this.Vstartgroup();
                }
            }
        }

        private class Watchdog
        extends Thread {
            private final Process groupProcess;
            private final long groupIncarnation;
            private boolean canInterrupt;
            private boolean shouldQuit;
            private boolean shouldRestart;

            Watchdog() {
                super("WatchDog-" + GroupEntry.this.groupName + "-" + GroupEntry.this.incarnation);
                this.groupProcess = GroupEntry.this.child;
                this.groupIncarnation = GroupEntry.this.incarnation;
                this.canInterrupt = true;
                this.shouldQuit = false;
                this.shouldRestart = true;
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (this.shouldQuit) {
                    return;
                }
                try {
                    this.groupProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                boolean bl = false;
                GroupEntry groupEntry = GroupEntry.this;
                synchronized (groupEntry) {
                    if (this.shouldQuit) {
                        return;
                    }
                    this.canInterrupt = false;
                    Watchdog.interrupted();
                    if (this.groupIncarnation == GroupEntry.this.incarnation) {
                        bl = this.shouldRestart && !Activation.this.shuttingDown;
                        GroupEntry.this.reset();
                        GroupEntry.this.childGone();
                    }
                }
                if (bl) {
                    GroupEntry.this.restartServices();
                }
            }

            void dispose() {
                this.shouldQuit = true;
                if (this.canInterrupt) {
                    this.interrupt();
                }
            }

            void noRestart() {
                this.shouldRestart = false;
            }
        }
    }

    private static class LogGroupIncarnation
    extends LogRecord {
        private static final long serialVersionUID = 4146872747377631897L;
        private ActivationGroupID id;
        private long inc;

        LogGroupIncarnation(ActivationGroupID activationGroupID, long l) {
            this.id = activationGroupID;
            this.inc = l;
        }

        Object apply(Object object) {
            try {
                GroupEntry groupEntry = ((Activation)object).getGroupEntry(this.id);
                groupEntry.incarnation = this.inc;
            }
            catch (Exception exception) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogGroupIncarnation"));
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static abstract class LogRecord
    implements Serializable {
        private static final long serialVersionUID = 8395140512322687529L;

        private LogRecord() {
        }

        abstract Object apply(Object var1) throws Exception;
    }

    private static class LogRegisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -1966827458515403625L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogRegisterGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }

        Object apply(Object object) {
            Map map = ((Activation)object).groupTable;
            Activation activation = (Activation)object;
            activation.getClass();
            map.put(this.id, activation.new GroupEntry(this.id, this.desc));
            return object;
        }
    }

    private static class LogRegisterObject
    extends LogRecord {
        private static final long serialVersionUID = -6280336276146085143L;
        private ActivationID id;
        private ActivationDesc desc;

        LogRegisterObject(ActivationID activationID, ActivationDesc activationDesc) {
            this.id = activationID;
            this.desc = activationDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.desc.getGroupID()).registerObject(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogRegisterObject"));
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUnregisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -3356306586522147344L;
        private ActivationGroupID id;

        LogUnregisterGroup(ActivationGroupID activationGroupID) {
            this.id = activationGroupID;
        }

        Object apply(Object object) {
            GroupEntry groupEntry = (GroupEntry)((Activation)object).groupTable.remove(this.id);
            try {
                groupEntry.unregisterGroup(false);
            }
            catch (Exception exception) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogUnregisterGroup"));
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUnregisterObject
    extends LogRecord {
        private static final long serialVersionUID = 6269824097396935501L;
        private ActivationID id;

        LogUnregisterObject(ActivationID activationID) {
            this.id = activationID;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).unregisterObject(this.id, false);
            }
            catch (Exception exception) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogUnregisterObject"));
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUpdateDesc
    extends LogRecord {
        private static final long serialVersionUID = 545511539051179885L;
        private ActivationID id;
        private ActivationDesc desc;

        LogUpdateDesc(ActivationID activationID, ActivationDesc activationDesc) {
            this.id = activationID;
            this.desc = activationDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).setActivationDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogUpdateDesc"));
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUpdateGroupDesc
    extends LogRecord {
        private static final long serialVersionUID = -1271300989218424337L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogUpdateGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).setActivationGroupDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogUpdateGroupDesc"));
                exception.printStackTrace();
            }
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectEntry
    implements Serializable {
        private static final long serialVersionUID = -5500114225321357856L;
        ActivationDesc desc;
        volatile transient MarshalledObject<? extends Remote> stub = null;
        volatile transient boolean removed = false;

        ObjectEntry(ActivationDesc activationDesc) {
            this.desc = activationDesc;
        }

        synchronized MarshalledObject<? extends Remote> activate(ActivationID activationID, boolean bl, ActivationInstantiator activationInstantiator) throws RemoteException, ActivationException {
            MarshalledObject<? extends Remote> marshalledObject = this.stub;
            if (this.removed) {
                throw new UnknownObjectException("object removed");
            }
            if (!bl && marshalledObject != null) {
                return marshalledObject;
            }
            this.stub = marshalledObject = activationInstantiator.newInstance(activationID, this.desc);
            return marshalledObject;
        }

        void reset() {
            this.stub = null;
        }
    }

    private class Shutdown
    extends Thread {
        Shutdown() {
            super("rmid Shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                GroupEntry[] groupEntryArray;
                Activation.unexport(Activation.this.activator);
                Activation.unexport(Activation.this.system);
                Map object = Activation.this.groupTable;
                synchronized (object) {
                    groupEntryArray = Activation.this.groupTable.values().toArray(new GroupEntry[Activation.this.groupTable.size()]);
                }
                for (GroupEntry groupEntry : groupEntryArray) {
                    groupEntry.shutdown();
                }
                Runtime.getRuntime().removeShutdownHook(Activation.this.shutdownHook);
                Activation.unexport(Activation.this.monitor);
                try {
                    ReliableLog reliableLog = Activation.this.log;
                    synchronized (reliableLog) {
                        Activation.this.log.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                System.err.println(Activation.getTextResource("rmid.daemon.shutdown"));
                System.exit(0);
            }
        }
    }

    private class ShutdownHook
    extends Thread {
        ShutdownHook() {
            super("rmid ShutdownHook");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = Activation.this;
            synchronized (object) {
                Activation.this.shuttingDown = true;
            }
            object = Activation.this.groupTable;
            synchronized (object) {
                for (GroupEntry groupEntry : Activation.this.groupTable.values()) {
                    groupEntry.shutdownFast();
                }
            }
        }
    }

    private static class SystemRegistryImpl
    extends RegistryImpl {
        private static final String NAME = ActivationSystem.class.getName();
        private final ActivationSystem systemStub;

        SystemRegistryImpl(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory, ActivationSystem activationSystem) throws RemoteException {
            super(n, rMIClientSocketFactory, rMIServerSocketFactory);
            this.systemStub = activationSystem;
        }

        public Remote lookup(String string) throws RemoteException, NotBoundException {
            if (string.equals(NAME)) {
                return this.systemStub;
            }
            return super.lookup(string);
        }

        public String[] list() throws RemoteException {
            String[] stringArray = super.list();
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 1];
            if (n > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
            }
            stringArray2[n] = NAME;
            return stringArray2;
        }

        public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
            if (string.equals(NAME)) {
                throw new AccessException("binding ActivationSystem is disallowed");
            }
            super.bind(string, remote);
        }

        public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
            if (string.equals(NAME)) {
                throw new AccessException("unbinding ActivationSystem is disallowed");
            }
            super.unbind(string);
        }

        public void rebind(String string, Remote remote) throws RemoteException, AccessException {
            if (string.equals(NAME)) {
                throw new AccessException("binding ActivationSystem is disallowed");
            }
            super.rebind(string, remote);
        }
    }
}

