/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ext.EUC_TW;

public abstract class X11CNS11643
extends Charset {
    private final int plane;

    public X11CNS11643(int n, String string) {
        super(string, null);
        switch (n) {
            case 1: {
                this.plane = 0;
                break;
            }
            case 2: 
            case 3: {
                this.plane = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
            }
        }
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this, this.plane);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this, this.plane);
    }

    public boolean contains(Charset charset) {
        return charset instanceof X11CNS11643;
    }

    private class Decoder
    extends EUC_TW.Decoder {
        private String table;

        protected Decoder(Charset charset, int n) {
            super(charset);
            switch (n) {
                case 0: {
                    this.table = unicodeCNS1;
                    break;
                }
                case 2: {
                    this.table = unicodeCNS2;
                    break;
                }
                case 3: {
                    this.table = unicodeCNS3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                for (n = n <= n2 ? n : n2; n < n2; n += 2) {
                    if (n2 - n < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    byte by = byArray[n];
                    byte by2 = byArray[n + 1];
                    char c = this.convToUnicode((byte)(by | 0x80), (byte)(by2 | 0x80), this.table);
                    if (c == this.replacement().charAt(0)) {
                        CoderResult coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = c;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }
    }

    private class Encoder
    extends EUC_TW.Encoder {
        private int plane;

        public Encoder(Charset charset, int n) {
            super(charset);
            this.plane = n;
        }

        public boolean canEncode(char c) {
            if (c <= '\u007f') {
                return false;
            }
            int n = this.getNative(c) >> 16;
            return n == 1 && this.plane == 0 || n == 2 && this.plane == 2 || n == 3 && this.plane == 3;
        }

        public boolean isLegalReplacement(byte[] byArray) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n;
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                    char c = cArray[n];
                    if (c >= '\ufffe' || c <= '\u007f') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    int n5 = this.getNative(c);
                    int n6 = n5 >> 16;
                    if (n6 == 1 && this.plane == 0 || n6 == 2 && this.plane == 2 || n6 == 3 && this.plane == 3) {
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n5 >> 8 & 0x7F);
                        byArray[n3++] = (byte)(n5 & 0x7F);
                        continue;
                    }
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }
    }
}

