/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap.ver1_1;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.DetailImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.FaultElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.FaultImpl;
import com.sun.xml.internal.messaging.saaj.soap.name.NameImpl;
import com.sun.xml.internal.messaging.saaj.soap.ver1_1.Detail1_1Impl;
import com.sun.xml.internal.messaging.saaj.soap.ver1_1.FaultElement1_1Impl;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class Fault1_1Impl
extends FaultImpl {
    protected static final Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap.ver1_1", "com.sun.xml.internal.messaging.saaj.soap.ver1_1.LocalStrings");

    public Fault1_1Impl(SOAPDocumentImpl sOAPDocumentImpl, String string) {
        super(sOAPDocumentImpl, NameImpl.createFault1_1Name(string));
    }

    protected NameImpl getDetailName() {
        return NameImpl.createDetail1_1Name();
    }

    protected NameImpl getFaultCodeName() {
        return NameImpl.createFromUnqualifiedName("faultcode");
    }

    protected NameImpl getFaultStringName() {
        return NameImpl.createFromUnqualifiedName("faultstring");
    }

    protected NameImpl getFaultActorName() {
        return NameImpl.createFromUnqualifiedName("faultactor");
    }

    protected DetailImpl createDetail() {
        return new Detail1_1Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument());
    }

    protected FaultElementImpl createSOAPFaultElement(String string) {
        return new FaultElement1_1Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), string);
    }

    protected void checkIfStandardFaultCode(String string, String string2) throws SOAPException {
    }

    protected void finallySetFaultCode(String string) throws SOAPException {
        this.faultCodeElement.addTextNode(string);
    }

    public String getFaultCode() {
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        return this.faultCodeElement.getValue();
    }

    public Name getFaultCodeAsName() {
        String string = this.getFaultCode();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return NameImpl.createFromUnqualifiedName(string);
        }
        String string2 = string.substring(0, n);
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        String string3 = this.faultCodeElement.getNamespaceURI(string2);
        return NameImpl.createFromQualifiedName(string, string3);
    }

    public QName getFaultCodeAsQName() {
        String string = this.getFaultCode();
        if (string == null) {
            return null;
        }
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        return Fault1_1Impl.convertCodeToQName(string, this.faultCodeElement);
    }

    public void setFaultString(String string) throws SOAPException {
        if (this.faultStringElement == null) {
            this.findFaultStringElement();
        }
        if (this.faultStringElement == null) {
            this.faultStringElement = this.addSOAPFaultElement("faultstring");
        } else {
            this.faultStringElement.removeContents();
            this.faultStringElement.removeAttribute("xml:lang");
        }
        this.faultStringElement.addTextNode(string);
    }

    public String getFaultString() {
        if (this.faultStringElement == null) {
            this.findFaultStringElement();
        }
        return this.faultStringElement.getValue();
    }

    public Locale getFaultStringLocale() {
        String string;
        if (this.faultStringElement == null) {
            this.findFaultStringElement();
        }
        if (this.faultStringElement != null && (string = this.faultStringElement.getAttributeValue(NameImpl.createFromUnqualifiedName("xml:lang"))) != null) {
            return Fault1_1Impl.xmlLangToLocale(string);
        }
        return null;
    }

    public void setFaultString(String string, Locale locale) throws SOAPException {
        this.setFaultString(string);
        this.faultStringElement.addAttribute(NameImpl.createFromTagName("xml:lang"), Fault1_1Impl.localeToXmlLang(locale));
    }

    protected boolean isStandardFaultElement(String string) {
        return string.equalsIgnoreCase("detail") || string.equalsIgnoreCase("faultcode") || string.equalsIgnoreCase("faultstring") || string.equalsIgnoreCase("faultactor");
    }

    public void appendFaultSubcode(QName qName) {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "appendFaultSubcode");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public void removeAllFaultSubcodes() {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "removeAllFaultSubcodes");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public Iterator getFaultSubcodes() {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "getFaultSubcodes");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public String getFaultReasonText(Locale locale) {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "getFaultReasonText");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public Iterator getFaultReasonTexts() {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "getFaultReasonTexts");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public Iterator getFaultReasonLocales() {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "getFaultReasonLocales");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public void addFaultReasonText(String string, Locale locale) throws SOAPException {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "addFaultReasonText");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public String getFaultRole() {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "getFaultRole");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public void setFaultRole(String string) {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "setFaultRole");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public String getFaultNode() {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "getFaultNode");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    public void setFaultNode(String string) {
        log.log(Level.SEVERE, "SAAJ0303.ver1_1.msg.op.unsupported.in.SOAP1.1", "setFaultNode");
        throw new UnsupportedOperationException("Not supported in SOAP 1.1");
    }

    protected QName getDefaultFaultCode() {
        return new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    }

    public SOAPElement addChildElement(SOAPElement sOAPElement) throws SOAPException {
        String string = sOAPElement.getLocalName();
        if ("Detail".equalsIgnoreCase(string) && this.hasDetail()) {
            log.severe("SAAJ0305.ver1_2.detail.exists.error");
            throw new SOAPExceptionImpl("Cannot add Detail, Detail already exists");
        }
        return super.addChildElement(sOAPElement);
    }

    protected FaultElementImpl createSOAPFaultElement(QName qName) {
        return new FaultElement1_1Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), qName);
    }

    protected FaultElementImpl createSOAPFaultElement(Name name) {
        return new FaultElement1_1Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), (NameImpl)name);
    }

    public void setFaultCode(String string, String string2, String string3) throws SOAPException {
        if (!(string2 != null && !string2.equals("") || string3 == null || "".equals(string3) || (string2 = this.getNamespacePrefix(string3)) != null && !string2.equals(""))) {
            string2 = "ns0";
        }
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        if (this.faultCodeElement == null) {
            this.faultCodeElement = this.addFaultCodeElement();
        } else {
            this.faultCodeElement.removeContents();
        }
        if ((string3 == null || string3.equals("")) && string2 != null && !"".equals("prefix")) {
            string3 = this.faultCodeElement.getNamespaceURI(string2);
        }
        if (string3 == null) {
            if (string2 != null && !"".equals(string2)) {
                log.severe("SAAJ0140.impl.no.ns.URI");
                throw new SOAPExceptionImpl("No NamespaceURI, SOAP requires faultcode content to be a QName");
            }
        } else {
            this.checkIfStandardFaultCode(string, string3);
            ((FaultElementImpl)this.faultCodeElement).ensureNamespaceIsDeclared(string2, string3);
        }
        if (string2 == null || "".equals(string2)) {
            this.finallySetFaultCode(string);
        } else {
            this.finallySetFaultCode(string2 + ":" + string);
        }
    }

    private boolean standardFaultCode(String string) {
        if (string.equals("VersionMismatch") || string.equals("MustUnderstand") || string.equals("Client") || string.equals("Server")) {
            return true;
        }
        return string.startsWith("VersionMismatch.") || string.startsWith("MustUnderstand.") || string.startsWith("Client.") || string.startsWith("Server.");
    }
}

