/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.util.Enumeration;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.Installer.InstallerFactory;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.Informer;

public class InstallChangeCtrl {
    private InstallChangeCtrl() {
    }

    private static void setUpdatePackage(PackageDescription packageData, InstallData installData) {
        if (packageData.isUpdatePackage()) {
            installData.setUpdatePackage(packageData);
        } else {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                InstallChangeCtrl.setUpdatePackage(child, installData);
            }
        }
    }

    private static void setChangeInstallDir(InstallData installData, Installer installer) {
        if (installData.isRootInstallation()) {
            String changeInstallDir = "/";
            installData.setInstallDir(changeInstallDir);
        } else {
            String changeInstallDir = installer.getChangeInstallDir(installData.getUpdatePackage());
            installData.setInstallDir(changeInstallDir);
        }
    }

    public static void checkInstallChange(InstallData data) {
        Installer installer = InstallerFactory.getInstance();
        PackageDescription packageData = SetupDataProvider.getPackageDescription();
        if (data.getUpdatePackage() == null) {
            InstallChangeCtrl.setUpdatePackage(packageData, data);
        }
        if (data.getUpdatePackage() != null) {
            data.setOlderVersionExists(false);
            data.setNewerVersionExists(false);
            data.setSameVersionExists(false);
            boolean packageIsInstalled = installer.isPackageInstalled(data.getUpdatePackage(), data);
            if (packageIsInstalled) {
                if (installer.isInstalledPackageOlder(data.getUpdatePackage(), data)) {
                    data.setOlderVersionExists(true);
                    System.err.println("An older product is installed");
                    if (data.getProductMinor() > data.getInstalledProductMinor()) {
                        data.setMajorUpgrade(true);
                        System.err.println("Major Upgrade");
                    }
                } else if (installer.isInstallSetPackageOlder(data.getUpdatePackage(), data)) {
                    data.setNewerVersionExists(true);
                    System.err.println("A newer product is installed");
                } else {
                    data.setSameVersionExists(true);
                    System.err.println("Same product is installed");
                }
                if (data.isRootInstallation()) {
                    InstallChangeCtrl.setChangeInstallDir(data, installer);
                    data.setIsChangeInstallation(true);
                }
                if (data.isRootInstallation() && data.dontUpdate() && data.olderVersionExists()) {
                    System.err.println("Error: An older version is already installed in directory " + data.getInstallDir() + "!");
                    String message1 = ResourceManager.getString("String_Older_Version_Installed_Found") + "\n" + data.getInstallDir() + "\n";
                    String message2 = ResourceManager.getString("String_Older_Version_Installed_Remove");
                    String message = message1 + "\n" + message2;
                    String title = ResourceManager.getString("String_Error");
                    Informer.showErrorMessage(message, title);
                    System.exit(1);
                }
            }
        }
    }
}

