/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class VMSupport {
    private static Properties agentProps = null;

    public static synchronized Properties getAgentProperties() {
        if (agentProps == null) {
            agentProps = new Properties();
            VMSupport.initAgentProperties(agentProps);
        }
        return agentProps;
    }

    private static native Properties initAgentProperties(Properties var0);

    private static byte[] serializePropertiesToByteArray(Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        Properties properties2 = new Properties();
        Set<String> set = properties.stringPropertyNames();
        for (String string : set) {
            String string2 = properties.getProperty(string);
            properties2.put(string, string2);
        }
        properties2.store(byteArrayOutputStream, null);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] serializePropertiesToByteArray() throws IOException {
        return VMSupport.serializePropertiesToByteArray(System.getProperties());
    }

    public static byte[] serializeAgentPropertiesToByteArray() throws IOException {
        return VMSupport.serializePropertiesToByteArray(VMSupport.getAgentProperties());
    }

    public static boolean isClassPathAttributePresent(String string) {
        try {
            Manifest manifest = new JarFile(string).getManifest();
            return manifest != null && manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH) != null;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }
}

