/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.SampleModel;

public class PixelInterleavedSampleModel
extends ComponentSampleModel {
    public PixelInterleavedSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        super(n, n2, n3, n4, n5, nArray);
        int n6 = nArray[0];
        int n7 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n6 = Math.min(n6, nArray[i]);
            n7 = Math.max(n7, nArray[i]);
        }
        if ((n7 -= n6) > n5) {
            throw new IllegalArgumentException("Offsets between bands must be less than the scanline  stride");
        }
        if (n4 * n2 > n5) {
            throw new IllegalArgumentException("Pixel stride times width must be less than or equal to the scanline stride");
        }
        if (n4 < n7) {
            throw new IllegalArgumentException("Pixel stride must be greater than or equal to the offsets between bands");
        }
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray;
        int n3 = this.bandOffsets[0];
        int n4 = this.bandOffsets.length;
        for (int i = 1; i < n4; ++i) {
            if (this.bandOffsets[i] >= n3) continue;
            n3 = this.bandOffsets[i];
        }
        if (n3 > 0) {
            nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = this.bandOffsets[i] - n3;
            }
        } else {
            nArray = this.bandOffsets;
        }
        return new PixelInterleavedSampleModel(this.dataType, n, n2, this.pixelStride, this.pixelStride * n, nArray);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.bandOffsets[nArray[i]];
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2);
    }

    public int hashCode() {
        return super.hashCode() ^ 1;
    }
}

