/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Encoder;
import sun.nio.cs.ext.SJIS;

public class PCK
extends Charset
implements HistoricallyNamedCharset {
    public PCK() {
        super("x-PCK", ExtendedCharsets.aliasesFor("x-PCK"));
    }

    public String historicalName() {
        return "PCK";
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof JIS_X_0201 || charset instanceof PCK;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        byte[] byArray = new byte[]{63};
        return new Encoder(this).replaceWith(byArray);
    }

    private static class Decoder
    extends SJIS.Decoder {
        JIS_X_0208_Solaris_Decoder jis0208;
        private static final char REPLACE_CHAR = '\ufffd';

        private Decoder(Charset charset) {
            super(charset);
            this.jis0208 = new JIS_X_0208_Solaris_Decoder(charset);
        }

        protected char decodeDouble(int n, int n2) {
            int n3;
            char c = super.decodeDouble(n, n2);
            if (c != '\ufffd') {
                return c != '\u2014' ? c : (char)'\u2015';
            }
            int n4 = n2 < 159 ? 1 : 0;
            int n5 = n3 = n < 160 ? 112 : 176;
            int n6 = n4 == 1 ? (n2 > 127 ? 32 : 31) : 126;
            int n7 = (n - n3 << 1) - n4;
            int n8 = n2 - n6;
            char c2 = this.jis0208.decodeDouble(n7, n8);
            return c2;
        }
    }

    private static class Encoder
    extends SJIS.Encoder {
        private JIS_X_0201.Encoder jis0201;
        private JIS_X_0208_Solaris_Encoder jis0208;
        short[] j0208Index1;
        String[] j0208Index2;

        private Encoder(Charset charset) {
            super(charset);
            this.jis0201 = new JIS_X_0201.Encoder(charset);
            this.jis0208 = new JIS_X_0208_Solaris_Encoder(charset);
            Encoder encoder = this;
            this.j0208Index1 = encoder.jis0208.getIndex1();
            Encoder encoder2 = this;
            this.j0208Index2 = encoder2.jis0208.getIndex2();
        }

        protected int encodeDouble(char c) {
            int n = 0;
            switch (c) {
                case '\u2015': {
                    return 33116;
                }
                case '\u2014': {
                    return 0;
                }
            }
            n = super.encodeDouble(c);
            if (n != 0) {
                return n;
            }
            int n2 = this.j0208Index1[c >> 8] << 8;
            char c2 = this.j0208Index2[n2 >> 12].charAt((n2 & 0xFFF) + (c & 0xFF));
            if (c2 != '\u0000') {
                int n3;
                int n4 = c2 >> 8 & 0xFF;
                int n5 = c2 & 0xFF;
                int n6 = n3 = n4 < 95 ? 112 : 176;
                int n7 = n4 % 2 == 1 ? (n5 > 95 ? 32 : 31) : 126;
                n = (n4 + 1 >> 1) + n3 << 8 | n5 + n7;
            }
            return n;
        }
    }
}

