/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

public abstract class AbstractScriptEngine
implements ScriptEngine {
    protected ScriptContext context = new SimpleScriptContext();

    public AbstractScriptEngine() {
    }

    public AbstractScriptEngine(Bindings bindings) {
        this();
        if (bindings == null) {
            throw new NullPointerException("n is null");
        }
        this.context.setBindings(bindings, 100);
    }

    public void setContext(ScriptContext scriptContext) {
        if (scriptContext == null) {
            throw new NullPointerException("null context");
        }
        this.context = scriptContext;
    }

    public ScriptContext getContext() {
        return this.context;
    }

    public Bindings getBindings(int n) {
        if (n == 200) {
            return this.context.getBindings(200);
        }
        if (n == 100) {
            return this.context.getBindings(100);
        }
        throw new IllegalArgumentException("Invalid scope value.");
    }

    public void setBindings(Bindings bindings, int n) {
        if (n == 200) {
            this.context.setBindings(bindings, 200);
        } else if (n == 100) {
            this.context.setBindings(bindings, 100);
        } else {
            throw new IllegalArgumentException("Invalid scope value.");
        }
    }

    public void put(String string, Object object) {
        Bindings bindings = this.getBindings(100);
        if (bindings != null) {
            bindings.put(string, object);
        }
    }

    public Object get(String string) {
        Bindings bindings = this.getBindings(100);
        if (bindings != null) {
            return bindings.get(string);
        }
        return null;
    }

    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        ScriptContext scriptContext = this.getScriptContext(bindings);
        return this.eval(reader, scriptContext);
    }

    public Object eval(String string, Bindings bindings) throws ScriptException {
        ScriptContext scriptContext = this.getScriptContext(bindings);
        return this.eval(string, scriptContext);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context);
    }

    public Object eval(String string) throws ScriptException {
        return this.eval(string, this.context);
    }

    protected ScriptContext getScriptContext(Bindings bindings) {
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        Bindings bindings2 = this.getBindings(200);
        if (bindings2 != null) {
            simpleScriptContext.setBindings(bindings2, 200);
        }
        if (bindings == null) {
            throw new NullPointerException("Engine scope Bindings may not be null.");
        }
        simpleScriptContext.setBindings(bindings, 100);
        simpleScriptContext.setReader(this.context.getReader());
        simpleScriptContext.setWriter(this.context.getWriter());
        simpleScriptContext.setErrorWriter(this.context.getErrorWriter());
        return simpleScriptContext;
    }
}

