/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.schemagen;

import com.sun.xml.internal.bind.v2.schemagen.GroupKind;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ContentModelContainer;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Occurs;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Particle;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.TypeDefParticle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Tree {
    Tree() {
    }

    Tree makeOptional(boolean bl) {
        return bl ? new Optional(this) : this;
    }

    Tree makeRepeated(boolean bl) {
        return bl ? new Repeated(this) : this;
    }

    static Tree makeGroup(GroupKind groupKind, List<Tree> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>(list.size());
        for (Tree tree : list) {
            Group group;
            if (tree instanceof Group && (group = (Group)tree).kind == groupKind) {
                arrayList.addAll(Arrays.asList(group.children));
                continue;
            }
            arrayList.add(tree);
        }
        return new Group(groupKind, arrayList.toArray(new Tree[arrayList.size()]));
    }

    abstract boolean isNullable();

    boolean canBeTopLevel() {
        return false;
    }

    protected abstract void write(ContentModelContainer var1, boolean var2, boolean var3);

    protected void write(TypeDefParticle typeDefParticle) {
        if (this.canBeTopLevel()) {
            this.write(typeDefParticle._cast(ContentModelContainer.class), false, false);
        } else {
            new Group(GroupKind.SEQUENCE, new Tree[]{this}).write(typeDefParticle);
        }
    }

    protected final void writeOccurs(Occurs occurs, boolean bl, boolean bl2) {
        if (bl) {
            occurs.minOccurs(0);
        }
        if (bl2) {
            occurs.maxOccurs("unbounded");
        }
    }

    private static final class Group
    extends Tree {
        private final GroupKind kind;
        private final Tree[] children;

        private Group(GroupKind groupKind, Tree ... treeArray) {
            this.kind = groupKind;
            this.children = treeArray;
        }

        boolean canBeTopLevel() {
            return true;
        }

        boolean isNullable() {
            if (this.kind == GroupKind.CHOICE) {
                for (Tree tree : this.children) {
                    if (!tree.isNullable()) continue;
                    return true;
                }
                return false;
            }
            for (Tree tree : this.children) {
                if (tree.isNullable()) continue;
                return false;
            }
            return true;
        }

        protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
            Particle particle = this.kind.write(contentModelContainer);
            this.writeOccurs(particle, bl, bl2);
            for (Tree tree : this.children) {
                tree.write(particle, false, false);
            }
        }
    }

    private static final class Optional
    extends Tree {
        private final Tree body;

        private Optional(Tree tree) {
            this.body = tree;
        }

        boolean isNullable() {
            return true;
        }

        Tree makeOptional(boolean bl) {
            return this;
        }

        protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
            this.body.write(contentModelContainer, true, bl2);
        }
    }

    private static final class Repeated
    extends Tree {
        private final Tree body;

        private Repeated(Tree tree) {
            this.body = tree;
        }

        boolean isNullable() {
            return this.body.isNullable();
        }

        Tree makeRepeated(boolean bl) {
            return this;
        }

        protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
            this.body.write(contentModelContainer, bl, true);
        }
    }

    static abstract class Term
    extends Tree {
        Term() {
        }

        boolean isNullable() {
            return false;
        }
    }
}

