/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuBarUI;
import javax.swing.plaf.metal.MetalToolBarUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalMenuBarUI
extends BasicMenuBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("Must pass in a non-null component");
        }
        return new MetalMenuBarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        MetalToolBarUI.register(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        MetalToolBarUI.unregister(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        boolean bl = jComponent.isOpaque();
        if (graphics == null) {
            throw new NullPointerException("Graphics must be non-null");
        }
        if (bl && jComponent.getBackground() instanceof UIResource && UIManager.get("MenuBar.gradient") != null) {
            JToolBar jToolBar;
            if (MetalToolBarUI.doesMenuBarBorderToolBar((JMenuBar)jComponent) && (jToolBar = (JToolBar)MetalToolBarUI.findRegisteredComponentOfType(jComponent, JToolBar.class)).isOpaque() && jToolBar.getBackground() instanceof UIResource) {
                MetalUtils.drawGradient(jComponent, graphics, "MenuBar.gradient", 0, 0, jComponent.getWidth(), jComponent.getHeight() + jToolBar.getHeight(), true);
                this.paint(graphics, jComponent);
                return;
            }
            MetalUtils.drawGradient(jComponent, graphics, "MenuBar.gradient", 0, 0, jComponent.getWidth(), jComponent.getHeight(), true);
            this.paint(graphics, jComponent);
        } else {
            super.update(graphics, jComponent);
        }
    }
}

