/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.util.Arrays;

public class EllipticCurve {
    private final ECField field;
    private final BigInteger a;
    private final BigInteger b;
    private final byte[] seed;

    private static void checkValidity(ECField eCField, BigInteger bigInteger, String string) {
        if (eCField instanceof ECFieldFp) {
            BigInteger bigInteger2 = ((ECFieldFp)eCField).getP();
            if (bigInteger2.compareTo(bigInteger) != 1) {
                throw new IllegalArgumentException(string + " is too large");
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(string + " is negative");
            }
        } else if (eCField instanceof ECFieldF2m) {
            int n = ((ECFieldF2m)eCField).getM();
            if (bigInteger.bitLength() > n) {
                throw new IllegalArgumentException(string + " is too large");
            }
        }
    }

    public EllipticCurve(ECField eCField, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCField, bigInteger, bigInteger2, null);
    }

    public EllipticCurve(ECField eCField, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        if (eCField == null) {
            throw new NullPointerException("field is null");
        }
        if (bigInteger == null) {
            throw new NullPointerException("first coefficient is null");
        }
        if (bigInteger2 == null) {
            throw new NullPointerException("second coefficient is null");
        }
        EllipticCurve.checkValidity(eCField, bigInteger, "first coefficient");
        EllipticCurve.checkValidity(eCField, bigInteger2, "second coefficient");
        this.field = eCField;
        this.a = bigInteger;
        this.b = bigInteger2;
        this.seed = (byte[])(byArray != null ? (byte[])byArray.clone() : null);
    }

    public ECField getField() {
        return this.field;
    }

    public BigInteger getA() {
        return this.a;
    }

    public BigInteger getB() {
        return this.b;
    }

    public byte[] getSeed() {
        if (this.seed == null) {
            return null;
        }
        return (byte[])this.seed.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EllipticCurve) {
            EllipticCurve ellipticCurve = (EllipticCurve)object;
            if (this.field.equals(ellipticCurve.field) && this.a.equals(ellipticCurve.a) && this.b.equals(ellipticCurve.b) && Arrays.equals(this.seed, ellipticCurve.seed)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.field.hashCode() << 6 + (this.a.hashCode() << 4) + (this.b.hashCode() << 2) + (this.seed == null ? 0 : this.seed.length);
    }
}

