/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message.helper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import sun.plugin2.message.Serializer;

public final class ProxyHelper {
    private static final int DIRECT_PROXY = 0;
    private static final int HTTP_PROXY = 1;
    private static final int SOCKS_PROXY = 2;

    private static int getProxyTypeID(Proxy.Type type) throws IllegalArgumentException {
        if (type == Proxy.Type.DIRECT) {
            return 0;
        }
        if (type == Proxy.Type.HTTP) {
            return 1;
        }
        if (type == Proxy.Type.SOCKS) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private static Proxy.Type getProxyType(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return Proxy.Type.DIRECT;
            }
            case 1: {
                return Proxy.Type.HTTP;
            }
            case 2: {
                return Proxy.Type.SOCKS;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void write(Serializer serializer, Proxy proxy) throws IOException {
        if (proxy == null) {
            serializer.writeBoolean(false);
            return;
        }
        serializer.writeBoolean(true);
        serializer.writeInt(ProxyHelper.getProxyTypeID(proxy.type()));
        InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
        if (inetSocketAddress != null) {
            serializer.writeBoolean(true);
            serializer.writeUTF(inetSocketAddress.getHostName());
            serializer.writeInt(inetSocketAddress.getPort());
        } else {
            serializer.writeBoolean(false);
        }
    }

    public static Proxy read(Serializer serializer) throws IOException {
        if (!serializer.readBoolean()) {
            return null;
        }
        Proxy.Type type = ProxyHelper.getProxyType(serializer.readInt());
        InetSocketAddress inetSocketAddress = null;
        if (serializer.readBoolean()) {
            inetSocketAddress = new InetSocketAddress(serializer.readUTF(), serializer.readInt());
        }
        if (type == Proxy.Type.DIRECT) {
            return Proxy.NO_PROXY;
        }
        return new Proxy(type, inetSocketAddress);
    }
}

