/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;

public class PackageDesc
implements ResourceType {
    private String _packageName;
    private String _part;
    private boolean _isRecursive;
    private boolean _isExact;

    public PackageDesc(String string, String string2, boolean bl) {
        if (string.endsWith(".*")) {
            this._packageName = string.substring(0, string.length() - 1);
            this._isExact = false;
        } else {
            this._isExact = true;
            this._packageName = string;
        }
        this._part = string2;
        this._isRecursive = bl;
    }

    String getPackageName() {
        return this._packageName;
    }

    String getPart() {
        return this._part;
    }

    boolean isRecursive() {
        return this._isRecursive;
    }

    boolean match(String string) {
        if (this._isExact) {
            return this._packageName.equals(string);
        }
        if (this._isRecursive) {
            return string.startsWith(this._packageName);
        }
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n + 1);
        }
        return string.equals(this._packageName);
    }

    public void visit(ResourceVisitor resourceVisitor) {
        resourceVisitor.visitPackageDesc(this);
    }

    public XMLNode asXML() {
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("name", this.getPackageName());
        xMLAttributeBuilder.add("part", this.getPart());
        xMLAttributeBuilder.add("recursive", this.isRecursive());
        return new XMLNode("package", xMLAttributeBuilder.getAttributeList());
    }
}

