/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.reflect.Reflection;
import sun.security.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessController {
    private AccessController() {
    }

    public static native <T> T doPrivileged(PrivilegedAction<T> var0);

    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> privilegedAction) {
        DomainCombiner domainCombiner = null;
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null || (domainCombiner = accessControlContext.getAssignedCombiner()) == null) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return AccessController.doPrivileged(privilegedAction, AccessController.preserveCombiner(domainCombiner));
    }

    public static native <T> T doPrivileged(PrivilegedAction<T> var0, AccessControlContext var1);

    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0) throws PrivilegedActionException;

    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        DomainCombiner domainCombiner = null;
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null || (domainCombiner = accessControlContext.getAssignedCombiner()) == null) {
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        return AccessController.doPrivileged(privilegedExceptionAction, AccessController.preserveCombiner(domainCombiner));
    }

    private static AccessControlContext preserveCombiner(DomainCombiner domainCombiner) {
        final Class clazz = Reflection.getCallerClass(3);
        ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getProtectionDomain();
            }
        });
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{protectionDomain};
        return new AccessControlContext(domainCombiner.combine(protectionDomainArray, null), domainCombiner);
    }

    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0, AccessControlContext var1) throws PrivilegedActionException;

    private static native AccessControlContext getStackAccessControlContext();

    static native AccessControlContext getInheritedAccessControlContext();

    public static AccessControlContext getContext() {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return new AccessControlContext(null, true);
        }
        return accessControlContext.optimize();
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            Debug debug = AccessControlContext.getDebug();
            boolean bl = false;
            if (debug != null) {
                bl = !Debug.isOn("codebase=");
                bl &= !Debug.isOn("permission=") || Debug.isOn("permission=" + permission.getClass().getCanonicalName());
            }
            if (bl && Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (bl && Debug.isOn("domain")) {
                debug.println("domain (context is null)");
            }
            if (bl) {
                debug.println("access allowed " + permission);
            }
            return;
        }
        AccessControlContext accessControlContext2 = accessControlContext.optimize();
        accessControlContext2.checkPermission(permission);
    }
}

