/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    public int x;
    public int y;
    public int width;
    public int height;
    private static final long serialVersionUID = -4345857070255674764L;

    private static native void initIDs();

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rectangle(int n, int n2) {
        this(0, 0, n, n2);
    }

    public Rectangle(Point point, Dimension dimension) {
        this(point.x, point.y, dimension.width, dimension.height);
    }

    public Rectangle(Point point) {
        this(point.x, point.y, 0, 0);
    }

    public Rectangle(Dimension dimension) {
        this(0, 0, dimension.width, dimension.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void setRect(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        int n4;
        if (d > 4.294967294E9) {
            n4 = Integer.MAX_VALUE;
            n3 = -1;
        } else {
            n4 = Rectangle.clip(d, false);
            if (d3 >= 0.0) {
                d3 += d - (double)n4;
            }
            n3 = Rectangle.clip(d3, d3 >= 0.0);
        }
        if (d2 > 4.294967294E9) {
            n2 = Integer.MAX_VALUE;
            n = -1;
        } else {
            n2 = Rectangle.clip(d2, false);
            if (d4 >= 0.0) {
                d4 += d2 - (double)n2;
            }
            n = Rectangle.clip(d4, d4 >= 0.0);
        }
        this.reshape(n4, n2, n3, n);
    }

    private static int clip(double d, boolean bl) {
        if (d <= -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (d >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)(bl ? Math.ceil(d) : Math.floor(d));
    }

    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    @Deprecated
    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void translate(int n, int n2) {
        int n3 = this.x;
        int n4 = n3 + n;
        if (n < 0) {
            if (n4 > n3) {
                if (this.width >= 0) {
                    this.width += n4 - Integer.MIN_VALUE;
                }
                n4 = Integer.MIN_VALUE;
            }
        } else if (n4 < n3) {
            if (this.width >= 0) {
                this.width += n4 - Integer.MAX_VALUE;
                if (this.width < 0) {
                    this.width = Integer.MAX_VALUE;
                }
            }
            n4 = Integer.MAX_VALUE;
        }
        this.x = n4;
        n3 = this.y;
        n4 = n3 + n2;
        if (n2 < 0) {
            if (n4 > n3) {
                if (this.height >= 0) {
                    this.height += n4 - Integer.MIN_VALUE;
                }
                n4 = Integer.MIN_VALUE;
            }
        } else if (n4 < n3) {
            if (this.height >= 0) {
                this.height += n4 - Integer.MAX_VALUE;
                if (this.height < 0) {
                    this.height = Integer.MAX_VALUE;
                }
            }
            n4 = Integer.MAX_VALUE;
        }
        this.y = n4;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    @Deprecated
    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        int n5 = this.width;
        int n6 = this.height;
        if ((n5 | n6 | n3 | n4) < 0) {
            return false;
        }
        int n7 = this.x;
        int n8 = this.y;
        if (n < n7 || n2 < n8) {
            return false;
        }
        n5 += n7;
        if ((n3 += n) <= n ? n5 >= n7 || n3 > n5 : n5 >= n7 && n3 > n5) {
            return false;
        }
        n6 += n8;
        return !((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6);
    }

    @Deprecated
    public boolean inside(int n, int n2) {
        int n3 = this.width;
        int n4 = this.height;
        if ((n3 | n4) < 0) {
            return false;
        }
        int n5 = this.x;
        int n6 = this.y;
        if (n < n5 || n2 < n6) {
            return false;
        }
        n4 += n6;
        return !((n3 += n5) >= n5 && n3 <= n || n4 >= n6 && n4 <= n2);
    }

    public boolean intersects(Rectangle rectangle) {
        int n = this.width;
        int n2 = this.height;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (n3 <= 0 || n4 <= 0 || n <= 0 || n2 <= 0) {
            return false;
        }
        int n5 = this.x;
        int n6 = this.y;
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        n4 += n8;
        n += n5;
        n2 += n6;
        return !((n3 += n7) >= n7 && n3 <= n5 || n4 >= n8 && n4 <= n6 || n >= n5 && n <= n7 || n2 >= n6 && n2 <= n8);
    }

    public Rectangle intersection(Rectangle rectangle) {
        int n = this.x;
        int n2 = this.y;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        long l = n;
        l += (long)this.width;
        long l2 = n2;
        l2 += (long)this.height;
        long l3 = n3;
        l3 += (long)rectangle.width;
        long l4 = n4;
        l4 += (long)rectangle.height;
        if (n < n3) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (l > l3) {
            l = l3;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) < Integer.MIN_VALUE) {
            l = Integer.MIN_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        return new Rectangle(n, n2, (int)l, (int)l2);
    }

    public Rectangle union(Rectangle rectangle) {
        long l = this.width;
        long l2 = this.height;
        if ((l | l2) < 0L) {
            return new Rectangle(rectangle);
        }
        long l3 = rectangle.width;
        long l4 = rectangle.height;
        if ((l3 | l4) < 0L) {
            return new Rectangle(this);
        }
        int n = this.x;
        int n2 = this.y;
        l += (long)n;
        l2 += (long)n2;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        l3 += (long)n3;
        l4 += (long)n4;
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (l < l3) {
            l = l3;
        }
        if (l2 < l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Rectangle(n, n2, (int)l, (int)l2);
    }

    public void add(int n, int n2) {
        if ((this.width | this.height) < 0) {
            this.x = n;
            this.y = n2;
            this.height = 0;
            this.width = 0;
            return;
        }
        int n3 = this.x;
        int n4 = this.y;
        long l = this.width;
        long l2 = this.height;
        l += (long)n3;
        l2 += (long)n4;
        if (n3 > n) {
            n3 = n;
        }
        if (n4 > n2) {
            n4 = n2;
        }
        if (l < (long)n) {
            l = n;
        }
        if (l2 < (long)n2) {
            l2 = n2;
        }
        l2 -= (long)n4;
        if ((l -= (long)n3) > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        this.reshape(n3, n4, (int)l, (int)l2);
    }

    public void add(Point point) {
        this.add(point.x, point.y);
    }

    public void add(Rectangle rectangle) {
        long l;
        long l2;
        long l3 = this.width;
        long l4 = this.height;
        if ((l3 | l4) < 0L) {
            this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (((l2 = (long)rectangle.width) | (l = (long)rectangle.height)) < 0L) {
            return;
        }
        int n = this.x;
        int n2 = this.y;
        l3 += (long)n;
        l4 += (long)n2;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        l2 += (long)n3;
        l += (long)n4;
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (l3 < l2) {
            l3 = l2;
        }
        if (l4 < l) {
            l4 = l;
        }
        l4 -= (long)n2;
        if ((l3 -= (long)n) > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        if (l4 > Integer.MAX_VALUE) {
            l4 = Integer.MAX_VALUE;
        }
        this.reshape(n, n2, (int)l3, (int)l4);
    }

    public void grow(int n, int n2) {
        long l = this.x;
        long l2 = this.y;
        long l3 = this.width;
        long l4 = this.height;
        l3 += l;
        l4 += l2;
        l2 -= (long)n2;
        l4 += (long)n2;
        if ((l3 += (long)n) < (l -= (long)n)) {
            if ((l3 -= l) < Integer.MIN_VALUE) {
                l3 = Integer.MIN_VALUE;
            }
            if (l < Integer.MIN_VALUE) {
                l = Integer.MIN_VALUE;
            } else if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
        } else {
            if (l < Integer.MIN_VALUE) {
                l = Integer.MIN_VALUE;
            } else if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            if ((l3 -= l) < Integer.MIN_VALUE) {
                l3 = Integer.MIN_VALUE;
            } else if (l3 > Integer.MAX_VALUE) {
                l3 = Integer.MAX_VALUE;
            }
        }
        if (l4 < l2) {
            if ((l4 -= l2) < Integer.MIN_VALUE) {
                l4 = Integer.MIN_VALUE;
            }
            if (l2 < Integer.MIN_VALUE) {
                l2 = Integer.MIN_VALUE;
            } else if (l2 > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
            }
        } else {
            if (l2 < Integer.MIN_VALUE) {
                l2 = Integer.MIN_VALUE;
            } else if (l2 > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
            }
            if ((l4 -= l2) < Integer.MIN_VALUE) {
                l4 = Integer.MIN_VALUE;
            } else if (l4 > Integer.MAX_VALUE) {
                l4 = Integer.MAX_VALUE;
            }
        }
        this.reshape((int)l, (int)l2, (int)l3, (int)l4);
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public int outcode(double d, double d2) {
        int n = 0;
        if (this.width <= 0) {
            n |= 5;
        } else if (d < (double)this.x) {
            n |= 1;
        } else if (d > (double)this.x + (double)this.width) {
            n |= 4;
        }
        if (this.height <= 0) {
            n |= 0xA;
        } else if (d2 < (double)this.y) {
            n |= 2;
        } else if (d2 > (double)this.y + (double)this.height) {
            n |= 8;
        }
        return n;
    }

    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return this.intersection((Rectangle)rectangle2D);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.intersect(this, rectangle2D, double_);
        return double_;
    }

    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return this.union((Rectangle)rectangle2D);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.union(this, rectangle2D, double_);
        return double_;
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Rectangle.initIDs();
        }
    }
}

