/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;
import java.security.AccessController;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.action.GetPropertyAction;

public class Debug {
    private String prefix;
    private static String args = AccessController.doPrivileged(new GetPropertyAction("java.security.debug"));
    private static final char[] hexDigits;

    public static void Help() {
        System.err.println();
        System.err.println("all           turn on all debugging");
        System.err.println("access        print all checkPermission results");
        System.err.println("combiner      SubjectDomainCombiner debugging");
        System.err.println("gssloginconfig");
        System.err.println("              GSS LoginConfigImpl debugging");
        System.err.println("jar           jar verification");
        System.err.println("logincontext  login context results");
        System.err.println("policy        loading and granting");
        System.err.println("provider      security provider debugging");
        System.err.println("scl           permissions SecureClassLoader assigns");
        System.err.println();
        System.err.println("The following can be used with access:");
        System.err.println();
        System.err.println("stack         include stack trace");
        System.err.println("domain        dump all domains in context");
        System.err.println("failure       before throwing exception, dump stack");
        System.err.println("              and domain that didn't have permission");
        System.err.println();
        System.err.println("The following can be used with stack and domain:");
        System.err.println();
        System.err.println("permission=<classname>");
        System.err.println("              only dump output if specified permission");
        System.err.println("              is being checked");
        System.err.println("codebase=<URL>");
        System.err.println("              only dump output if specified codebase");
        System.err.println("              is being checked");
        System.err.println();
        System.err.println("Note: Separate multiple options with a comma");
        System.exit(0);
    }

    public static Debug getInstance(String string) {
        return Debug.getInstance(string, string);
    }

    public static Debug getInstance(String string, String string2) {
        if (Debug.isOn(string)) {
            Debug debug = new Debug();
            debug.prefix = string2;
            return debug;
        }
        return null;
    }

    public static boolean isOn(String string) {
        if (args == null) {
            return false;
        }
        if (args.indexOf("all") != -1) {
            return true;
        }
        return args.indexOf(string) != -1;
    }

    public void println(String string) {
        System.err.println(this.prefix + ": " + string);
    }

    public void println() {
        System.err.println(this.prefix + ":");
    }

    public static void println(String string, String string2) {
        System.err.println(string + ": " + string2);
    }

    public static String toHexString(BigInteger bigInteger) {
        String string = bigInteger.toString(16);
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        if (string.startsWith("-")) {
            stringBuffer.append("   -");
            string = string.substring(1);
        } else {
            stringBuffer.append("    ");
        }
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(string.substring(n, n + 2));
            if ((n += 2) == string.length()) continue;
            if (n % 64 == 0) {
                stringBuffer.append("\n    ");
                continue;
            }
            if (n % 8 != 0) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String marshal(String string) {
        if (string != null) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer(string);
            String string3 = "[Pp][Ee][Rr][Mm][Ii][Ss][Ss][Ii][Oo][Nn]=";
            String string4 = "permission=";
            String string5 = string3 + "[a-zA-Z_$][a-zA-Z0-9_$]*([.][a-zA-Z_$][a-zA-Z0-9_$]*)*";
            Pattern pattern = Pattern.compile(string5);
            Matcher matcher = pattern.matcher(stringBuffer2);
            StringBuffer stringBuffer3 = new StringBuffer();
            while (matcher.find()) {
                string2 = matcher.group();
                stringBuffer.append(string2.replaceFirst(string3, string4));
                stringBuffer.append("  ");
                matcher.appendReplacement(stringBuffer3, "");
            }
            matcher.appendTail(stringBuffer3);
            stringBuffer2 = stringBuffer3;
            string3 = "[Cc][Oo][Dd][Ee][Bb][Aa][Ss][Ee]=";
            string4 = "codebase=";
            string5 = string3 + "[^, ;]*";
            pattern = Pattern.compile(string5);
            matcher = pattern.matcher(stringBuffer2);
            stringBuffer3 = new StringBuffer();
            while (matcher.find()) {
                string2 = matcher.group();
                stringBuffer.append(string2.replaceFirst(string3, string4));
                stringBuffer.append("  ");
                matcher.appendReplacement(stringBuffer3, "");
            }
            matcher.appendTail(stringBuffer3);
            stringBuffer2 = stringBuffer3;
            stringBuffer.append(stringBuffer2.toString().toLowerCase());
            return stringBuffer.toString();
        }
        return null;
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "(null)";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (i != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(hexDigits[n >>> 4]);
            stringBuilder.append(hexDigits[n & 0xF]);
        }
        return stringBuilder.toString();
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.security.auth.debug"));
        if (args == null) {
            args = string;
        } else if (string != null) {
            args = args + "," + string;
        }
        if (args != null && (args = Debug.marshal(args)).equals("help")) {
            Debug.Help();
        }
        hexDigits = "0123456789abcdef".toCharArray();
    }
}

