/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import sun.misc.Unsafe;

public class RenderBuffer {
    protected static final long SIZEOF_BYTE = 1L;
    protected static final long SIZEOF_SHORT = 2L;
    protected static final long SIZEOF_INT = 4L;
    protected static final long SIZEOF_FLOAT = 4L;
    protected static final long SIZEOF_LONG = 8L;
    protected static final long SIZEOF_DOUBLE = 8L;
    private static final int COPY_FROM_ARRAY_THRESHOLD = 28;
    protected final Unsafe unsafe = Unsafe.getUnsafe();
    protected final long baseAddress;
    protected final long endAddress;
    protected long curAddress;
    protected final int capacity;

    protected RenderBuffer(int n) {
        this.curAddress = this.baseAddress = this.unsafe.allocateMemory(n);
        this.endAddress = this.baseAddress + (long)n;
        this.capacity = n;
    }

    public static RenderBuffer allocate(int n) {
        return new RenderBuffer(n);
    }

    public final long getAddress() {
        return this.baseAddress;
    }

    private static native void copyFromArray(Object var0, long var1, long var3, long var5);

    public final int capacity() {
        return this.capacity;
    }

    public final int remaining() {
        return (int)(this.endAddress - this.curAddress);
    }

    public final int position() {
        return (int)(this.curAddress - this.baseAddress);
    }

    public final void position(long l) {
        this.curAddress = this.baseAddress + l;
    }

    public final void clear() {
        this.curAddress = this.baseAddress;
    }

    public final RenderBuffer putByte(byte by) {
        this.unsafe.putByte(this.curAddress, by);
        ++this.curAddress;
        return this;
    }

    public RenderBuffer put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public RenderBuffer put(byte[] byArray, int n, int n2) {
        if (n2 > 28) {
            long l = (long)n * 1L;
            long l2 = (long)n2 * 1L;
            RenderBuffer.copyFromArray(byArray, l, this.curAddress, l2);
            this.position((long)this.position() + l2);
        } else {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.putByte(byArray[i]);
            }
        }
        return this;
    }

    public final RenderBuffer putShort(short s) {
        this.unsafe.putShort(this.curAddress, s);
        this.curAddress += 2L;
        return this;
    }

    public RenderBuffer put(short[] sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    public RenderBuffer put(short[] sArray, int n, int n2) {
        if (n2 > 28) {
            long l = (long)n * 2L;
            long l2 = (long)n2 * 2L;
            RenderBuffer.copyFromArray(sArray, l, this.curAddress, l2);
            this.position((long)this.position() + l2);
        } else {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.putShort(sArray[i]);
            }
        }
        return this;
    }

    public final RenderBuffer putInt(int n, int n2) {
        this.unsafe.putInt(this.baseAddress + (long)n, n2);
        return this;
    }

    public final RenderBuffer putInt(int n) {
        this.unsafe.putInt(this.curAddress, n);
        this.curAddress += 4L;
        return this;
    }

    public RenderBuffer put(int[] nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    public RenderBuffer put(int[] nArray, int n, int n2) {
        if (n2 > 28) {
            long l = (long)n * 4L;
            long l2 = (long)n2 * 4L;
            RenderBuffer.copyFromArray(nArray, l, this.curAddress, l2);
            this.position((long)this.position() + l2);
        } else {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.putInt(nArray[i]);
            }
        }
        return this;
    }

    public final RenderBuffer putFloat(float f) {
        this.unsafe.putFloat(this.curAddress, f);
        this.curAddress += 4L;
        return this;
    }

    public RenderBuffer put(float[] fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    public RenderBuffer put(float[] fArray, int n, int n2) {
        if (n2 > 28) {
            long l = (long)n * 4L;
            long l2 = (long)n2 * 4L;
            RenderBuffer.copyFromArray(fArray, l, this.curAddress, l2);
            this.position((long)this.position() + l2);
        } else {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.putFloat(fArray[i]);
            }
        }
        return this;
    }

    public final RenderBuffer putLong(long l) {
        this.unsafe.putLong(this.curAddress, l);
        this.curAddress += 8L;
        return this;
    }

    public RenderBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    public RenderBuffer put(long[] lArray, int n, int n2) {
        if (n2 > 28) {
            long l = (long)n * 8L;
            long l2 = (long)n2 * 8L;
            RenderBuffer.copyFromArray(lArray, l, this.curAddress, l2);
            this.position((long)this.position() + l2);
        } else {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.putLong(lArray[i]);
            }
        }
        return this;
    }

    public final RenderBuffer putDouble(double d) {
        this.unsafe.putDouble(this.curAddress, d);
        this.curAddress += 8L;
        return this;
    }
}

