/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.output;

import com.sun.xml.internal.bind.DatatypeConverterImpl;
import com.sun.xml.internal.bind.v2.runtime.Name;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.output.Encoded;
import com.sun.xml.internal.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Pcdata;
import com.sun.xml.internal.bind.v2.runtime.output.XmlOutputAbstractImpl;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class UTF8XmlOutput
extends XmlOutputAbstractImpl {
    protected final OutputStream out;
    private Encoded[] prefixes = new Encoded[8];
    private int prefixCount;
    private final Encoded[] localNames;
    private final Encoded textBuffer = new Encoded();
    protected final byte[] octetBuffer = new byte[1024];
    protected int octetBufferIndex;
    protected boolean closeStartTagPending = false;
    private String header;
    private final byte[] XMLNS_EQUALS = (byte[])_XMLNS_EQUALS.clone();
    private final byte[] XMLNS_COLON = (byte[])_XMLNS_COLON.clone();
    private final byte[] EQUALS = (byte[])_EQUALS.clone();
    private final byte[] CLOSE_TAG = (byte[])_CLOSE_TAG.clone();
    private final byte[] EMPTY_TAG = (byte[])_EMPTY_TAG.clone();
    private final byte[] XML_DECL = (byte[])_XML_DECL.clone();
    private static final byte[] _XMLNS_EQUALS = UTF8XmlOutput.toBytes(" xmlns=\"");
    private static final byte[] _XMLNS_COLON = UTF8XmlOutput.toBytes(" xmlns:");
    private static final byte[] _EQUALS = UTF8XmlOutput.toBytes("=\"");
    private static final byte[] _CLOSE_TAG = UTF8XmlOutput.toBytes("</");
    private static final byte[] _EMPTY_TAG = UTF8XmlOutput.toBytes("/>");
    private static final byte[] _XML_DECL = UTF8XmlOutput.toBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public UTF8XmlOutput(OutputStream outputStream, Encoded[] encodedArray) {
        this.out = outputStream;
        this.localNames = encodedArray;
        for (int i = 0; i < this.prefixes.length; ++i) {
            this.prefixes[i] = new Encoded();
        }
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public void startDocument(XMLSerializer xMLSerializer, boolean bl, int[] nArray, NamespaceContextImpl namespaceContextImpl) throws IOException, SAXException, XMLStreamException {
        super.startDocument(xMLSerializer, bl, nArray, namespaceContextImpl);
        this.octetBufferIndex = 0;
        if (!bl) {
            this.write(this.XML_DECL);
        }
        if (this.header != null) {
            this.textBuffer.set(this.header);
            this.textBuffer.write(this);
        }
    }

    public void endDocument(boolean bl) throws IOException, SAXException, XMLStreamException {
        this.flushBuffer();
        super.endDocument(bl);
    }

    protected final void closeStartTag() throws IOException {
        if (this.closeStartTagPending) {
            this.write(62);
            this.closeStartTagPending = false;
        }
    }

    public void beginStartTag(int n, String string) throws IOException {
        this.closeStartTag();
        int n2 = this.pushNsDecls();
        this.write(60);
        this.writeName(n, string);
        this.writeNsDecls(n2);
    }

    public void beginStartTag(Name name) throws IOException {
        this.closeStartTag();
        int n = this.pushNsDecls();
        this.write(60);
        this.writeName(name);
        this.writeNsDecls(n);
    }

    private int pushNsDecls() {
        int n;
        int n2;
        int n3 = this.nsContext.count();
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        if (n3 > this.prefixes.length) {
            n2 = Math.max(n3, this.prefixes.length * 2);
            Encoded[] encodedArray = new Encoded[n2];
            System.arraycopy(this.prefixes, 0, encodedArray, 0, this.prefixes.length);
            for (n = this.prefixes.length; n < encodedArray.length; ++n) {
                encodedArray[n] = new Encoded();
            }
            this.prefixes = encodedArray;
        }
        n2 = Math.min(this.prefixCount, element.getBase());
        int n4 = this.nsContext.count();
        for (n = n2; n < n4; ++n) {
            String string = this.nsContext.getPrefix(n);
            Encoded encoded = this.prefixes[n];
            if (string.length() == 0) {
                encoded.buf = EMPTY_BYTE_ARRAY;
                encoded.len = 0;
                continue;
            }
            encoded.set(string);
            encoded.append(':');
        }
        this.prefixCount = n4;
        return n2;
    }

    protected void writeNsDecls(int n) throws IOException {
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        int n2 = this.nsContext.count();
        for (int i = element.getBase(); i < n2; ++i) {
            this.writeNsDecl(i);
        }
    }

    protected final void writeNsDecl(int n) throws IOException {
        String string = this.nsContext.getPrefix(n);
        if (string.length() == 0) {
            if (this.nsContext.getCurrent().isRootElement() && this.nsContext.getNamespaceURI(n).length() == 0) {
                return;
            }
            this.write(this.XMLNS_EQUALS);
        } else {
            Encoded encoded = this.prefixes[n];
            this.write(this.XMLNS_COLON);
            this.write(encoded.buf, 0, encoded.len - 1);
            this.write(this.EQUALS);
        }
        this.doText(this.nsContext.getNamespaceURI(n), true);
        this.write(34);
    }

    private void writePrefix(int n) throws IOException {
        this.prefixes[n].write(this);
    }

    private void writeName(Name name) throws IOException {
        this.writePrefix(this.nsUriIndex2prefixIndex[name.nsUriIndex]);
        this.localNames[name.localNameIndex].write(this);
    }

    private void writeName(int n, String string) throws IOException {
        this.writePrefix(n);
        this.textBuffer.set(string);
        this.textBuffer.write(this);
    }

    public void attribute(Name name, String string) throws IOException {
        this.write(32);
        if (name.nsUriIndex == -1) {
            this.localNames[name.localNameIndex].write(this);
        } else {
            this.writeName(name);
        }
        this.write(this.EQUALS);
        this.doText(string, true);
        this.write(34);
    }

    public void attribute(int n, String string, String string2) throws IOException {
        this.write(32);
        if (n == -1) {
            this.textBuffer.set(string);
            this.textBuffer.write(this);
        } else {
            this.writeName(n, string);
        }
        this.write(this.EQUALS);
        this.doText(string2, true);
        this.write(34);
    }

    public void endStartTag() throws IOException {
        this.closeStartTagPending = true;
    }

    public void endTag(Name name) throws IOException {
        if (this.closeStartTagPending) {
            this.write(this.EMPTY_TAG);
            this.closeStartTagPending = false;
        } else {
            this.write(this.CLOSE_TAG);
            this.writeName(name);
            this.write(62);
        }
    }

    public void endTag(int n, String string) throws IOException {
        if (this.closeStartTagPending) {
            this.write(this.EMPTY_TAG);
            this.closeStartTagPending = false;
        } else {
            this.write(this.CLOSE_TAG);
            this.writeName(n, string);
            this.write(62);
        }
    }

    public void text(String string, boolean bl) throws IOException {
        this.closeStartTag();
        if (bl) {
            this.write(32);
        }
        this.doText(string, false);
    }

    public void text(Pcdata pcdata, boolean bl) throws IOException {
        this.closeStartTag();
        if (bl) {
            this.write(32);
        }
        pcdata.writeTo(this);
    }

    private void doText(String string, boolean bl) throws IOException {
        this.textBuffer.setEscape(string, bl);
        this.textBuffer.write(this);
    }

    public final void text(int n) throws IOException {
        this.closeStartTag();
        boolean bl = n < 0;
        this.textBuffer.ensureSize(11);
        byte[] byArray = this.textBuffer.buf;
        int n2 = 11;
        do {
            int n3;
            if ((n3 = n % 10) < 0) {
                n3 = -n3;
            }
            byArray[--n2] = (byte)(0x30 | n3);
        } while ((n /= 10) != 0);
        if (bl) {
            byArray[--n2] = 45;
        }
        this.write(byArray, n2, 11 - n2);
    }

    public void text(byte[] byArray, int n) throws IOException {
        this.closeStartTag();
        int n2 = 0;
        while (n > 0) {
            int n3 = Math.min((this.octetBuffer.length - this.octetBufferIndex) / 4 * 3, n);
            this.octetBufferIndex = DatatypeConverterImpl._printBase64Binary(byArray, n2, n3, this.octetBuffer, this.octetBufferIndex);
            if (n3 < n) {
                this.flushBuffer();
            }
            n2 += n3;
            n -= n3;
        }
    }

    public final void write(int n) throws IOException {
        if (this.octetBufferIndex < this.octetBuffer.length) {
            this.octetBuffer[this.octetBufferIndex++] = (byte)n;
        } else {
            this.out.write(this.octetBuffer);
            this.octetBufferIndex = 1;
            this.octetBuffer[0] = (byte)n;
        }
    }

    protected final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    protected final void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.octetBufferIndex + n2 < this.octetBuffer.length) {
            System.arraycopy(byArray, n, this.octetBuffer, this.octetBufferIndex, n2);
            this.octetBufferIndex += n2;
        } else {
            this.out.write(this.octetBuffer, 0, this.octetBufferIndex);
            this.out.write(byArray, n, n2);
            this.octetBufferIndex = 0;
        }
    }

    protected final void flushBuffer() throws IOException {
        this.out.write(this.octetBuffer, 0, this.octetBufferIndex);
        this.octetBufferIndex = 0;
    }

    static byte[] toBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = string.length() - 1; i >= 0; --i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }
}

