/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

public final class TextHitInfo {
    private int charIndex;
    private boolean isLeadingEdge;

    private TextHitInfo(int n, boolean bl) {
        this.charIndex = n;
        this.isLeadingEdge = bl;
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public boolean isLeadingEdge() {
        return this.isLeadingEdge;
    }

    public int getInsertionIndex() {
        return this.isLeadingEdge ? this.charIndex : this.charIndex + 1;
    }

    public int hashCode() {
        return this.charIndex;
    }

    public boolean equals(Object object) {
        return object instanceof TextHitInfo && this.equals((TextHitInfo)object);
    }

    public boolean equals(TextHitInfo textHitInfo) {
        return textHitInfo != null && this.charIndex == textHitInfo.charIndex && this.isLeadingEdge == textHitInfo.isLeadingEdge;
    }

    public String toString() {
        return "TextHitInfo[" + this.charIndex + (this.isLeadingEdge ? "L" : "T") + "]";
    }

    public static TextHitInfo leading(int n) {
        return new TextHitInfo(n, true);
    }

    public static TextHitInfo trailing(int n) {
        return new TextHitInfo(n, false);
    }

    public static TextHitInfo beforeOffset(int n) {
        return new TextHitInfo(n - 1, false);
    }

    public static TextHitInfo afterOffset(int n) {
        return new TextHitInfo(n, true);
    }

    public TextHitInfo getOtherHit() {
        if (this.isLeadingEdge) {
            return TextHitInfo.trailing(this.charIndex - 1);
        }
        return TextHitInfo.leading(this.charIndex + 1);
    }

    public TextHitInfo getOffsetHit(int n) {
        return new TextHitInfo(this.charIndex + n, this.isLeadingEdge);
    }
}

