/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.MutableBoolean;
import java.awt.Window;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerOrderFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    private static final MutableBoolean found = new MutableBoolean();
    private static final Logger log = Logger.getLogger("java.awt.ContainerOrderFocusTraversalPolicy");
    private static final long serialVersionUID = 486933713763926351L;
    private boolean implicitDownCycleTraversal = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentAfter(Container container, Component component) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking for next component in " + container + " for " + component);
        }
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (container.isFocusCycleRoot() && !component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            ContainerOrderFocusTraversalPolicy.found.value = false;
            Component component2 = this.getComponentAfter(container, component, found);
            if (component2 != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("After component is " + component2);
                }
                return component2;
            }
            if (ContainerOrderFocusTraversalPolicy.found.value) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Didn't find next component in " + container + " - falling back to the first ");
                }
                return this.getFirstComponent(container);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("After component is null");
            }
            return null;
        }
    }

    private Component getComponentAfter(Container container, Component component, MutableBoolean mutableBoolean) {
        if (!container.isVisible() || !container.isDisplayable()) {
            return null;
        }
        if (mutableBoolean.value) {
            if (this.accept(container)) {
                return container;
            }
        } else if (container == component) {
            mutableBoolean.value = true;
        }
        for (int i = 0; i < container.countComponents(); ++i) {
            Component component2;
            Component component3;
            Component component4 = container.getComponent(i);
            if (component4 instanceof Container && !((Container)component4).isFocusCycleRoot()) {
                component3 = null;
                if (((Container)component4).isFocusTraversalPolicyProvider()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Entering FTP " + component4);
                    }
                    component2 = (Container)component4;
                    FocusTraversalPolicy focusTraversalPolicy = ((Container)component2).getFocusTraversalPolicy();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("FTP contains " + component + ": " + ((Container)component2).isAncestorOf(component));
                    }
                    if (mutableBoolean.value) {
                        component3 = focusTraversalPolicy.getDefaultComponent((Container)component2);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Used FTP for getting default component: " + component3);
                        }
                    } else {
                        mutableBoolean.value = ((Container)component2).isAncestorOf(component);
                        if (mutableBoolean.value) {
                            if (component == focusTraversalPolicy.getLastComponent((Container)component2)) {
                                component3 = null;
                            } else {
                                component3 = focusTraversalPolicy.getComponentAfter((Container)component2, component);
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("FTP found next for the component : " + component3);
                                }
                            }
                        }
                    }
                } else {
                    component3 = this.getComponentAfter((Container)component4, component, mutableBoolean);
                }
                if (component3 != null) {
                    return component3;
                }
            } else if (mutableBoolean.value) {
                if (this.accept(component4)) {
                    return component4;
                }
            } else if (component4 == component) {
                mutableBoolean.value = true;
            }
            if (!mutableBoolean.value || !this.getImplicitDownCycleTraversal() || !(component4 instanceof Container) || !((Container)component4).isFocusCycleRoot() || (component2 = ((Container)(component3 = (Container)component4)).getFocusTraversalPolicy().getDefaultComponent((Container)component3)) == null) continue;
            return component2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentBefore(Container container, Component component) {
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (container.isFocusCycleRoot() && !component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            ContainerOrderFocusTraversalPolicy.found.value = false;
            Component component2 = this.getComponentBefore(container, component, found);
            if (component2 != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Before component is " + component2);
                }
                return component2;
            }
            if (ContainerOrderFocusTraversalPolicy.found.value) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Didn't find before component in " + container + " - falling back to the first ");
                }
                return this.getLastComponent(container);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Before component is null");
            }
            return null;
        }
    }

    private Component getComponentBefore(Container container, Component component, MutableBoolean mutableBoolean) {
        if (!container.isVisible() || !container.isDisplayable()) {
            return null;
        }
        for (int i = container.countComponents() - 1; i >= 0; --i) {
            Component component2 = container.getComponent(i);
            if (component2 == component) {
                mutableBoolean.value = true;
                continue;
            }
            if (component2 instanceof Container && !((Container)component2).isFocusCycleRoot()) {
                Component component3 = null;
                if (((Container)component2).isFocusTraversalPolicyProvider()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Entering FTP " + component2);
                    }
                    Container container2 = (Container)component2;
                    FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("FTP contains " + component + ": " + container2.isAncestorOf(component));
                    }
                    if (mutableBoolean.value) {
                        component3 = focusTraversalPolicy.getLastComponent(container2);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Used FTP for getting last component: " + component3);
                        }
                    } else {
                        mutableBoolean.value = container2.isAncestorOf(component);
                        if (mutableBoolean.value) {
                            if (component == focusTraversalPolicy.getFirstComponent(container2)) {
                                component3 = null;
                            } else {
                                component3 = focusTraversalPolicy.getComponentBefore(container2, component);
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("FTP found previous for the component : " + component3);
                                }
                            }
                        }
                    }
                } else {
                    component3 = this.getComponentBefore((Container)component2, component, mutableBoolean);
                }
                if (component3 == null) continue;
                return component3;
            }
            if (!mutableBoolean.value || !this.accept(component2)) continue;
            return component2;
        }
        if (mutableBoolean.value) {
            if (this.accept(container)) {
                return container;
            }
        } else if (container == component) {
            mutableBoolean.value = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getFirstComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            if (!container.isVisible() || !container.isDisplayable()) {
                return null;
            }
            if (this.accept(container)) {
                return container;
            }
            for (int i = 0; i < container.countComponents(); ++i) {
                Component component = container.getComponent(i);
                if (component instanceof Container && !((Container)component).isFocusCycleRoot()) {
                    Component component2 = null;
                    Container container2 = (Container)component;
                    if (container2.isFocusTraversalPolicyProvider()) {
                        FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
                        component2 = focusTraversalPolicy.getDefaultComponent(container2);
                    } else {
                        component2 = this.getFirstComponent((Container)component);
                    }
                    if (component2 == null) continue;
                    return component2;
                }
                if (!this.accept(component)) continue;
                return component;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getLastComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking for the last component in " + container);
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            if (!container.isVisible() || !container.isDisplayable()) {
                return null;
            }
            for (int i = container.countComponents() - 1; i >= 0; --i) {
                Component component = container.getComponent(i);
                if (component instanceof Container && !((Container)component).isFocusCycleRoot()) {
                    Component component2 = null;
                    Container container2 = (Container)component;
                    if (container2.isFocusTraversalPolicyProvider()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("\tEntering FTP " + container2);
                        }
                        FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
                        component2 = focusTraversalPolicy.getLastComponent(container2);
                    } else {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("\tEntering sub-container");
                        }
                        component2 = this.getLastComponent((Container)component);
                    }
                    if (component2 == null) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("\tFound last component : " + component2);
                    }
                    return component2;
                }
                if (!this.accept(component)) continue;
                return component;
            }
            if (this.accept(container)) {
                return container;
            }
        }
        return null;
    }

    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    public void setImplicitDownCycleTraversal(boolean bl) {
        this.implicitDownCycleTraversal = bl;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected boolean accept(Component component) {
        if (!(component.isVisible() && component.isDisplayable() && component.isFocusable() && component.isEnabled())) {
            return false;
        }
        if (!(component instanceof Window)) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!container.isEnabled() && !container.isLightweight()) {
                    return false;
                }
                if (container instanceof Window) break;
            }
        }
        return true;
    }
}

