/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Engine;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.internal.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.TubelineAssembler;
import com.sun.xml.internal.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.EndpointAwareCodec;
import com.sun.xml.internal.ws.api.server.EndpointComponent;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.wsdl.WSDLProperties;
import com.sun.xml.internal.ws.resources.HandlerMessages;
import com.sun.xml.internal.ws.server.InvokerTube;
import com.sun.xml.internal.ws.server.JMXAgent;
import com.sun.xml.internal.ws.server.ServiceDefinitionImpl;
import com.sun.xml.internal.ws.util.Pool;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.handler.Handler;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSEndpointImpl<T>
extends WSEndpoint<T> {
    @NotNull
    private final QName serviceName;
    @NotNull
    private final QName portName;
    private final WSBinding binding;
    private final SEIModel seiModel;
    @NotNull
    private final Container container;
    private final WSDLPort port;
    private final Tube masterTubeline;
    private final ServiceDefinitionImpl serviceDef;
    private final SOAPVersion soapVersion;
    private final Engine engine;
    @NotNull
    private final Codec masterCodec;
    private final Pool<Tube> tubePool;
    private boolean disposed;
    private final Class<T> implementationClass;
    @Nullable
    private final WSDLProperties wsdlProperties;
    private final Set<EndpointComponent> componentRegistry = new LinkedHashSet<EndpointComponent>();
    private static final Logger logger;

    WSEndpointImpl(@NotNull QName qName, @NotNull QName qName2, WSBinding wSBinding, Container container, SEIModel sEIModel, WSDLPort wSDLPort, Class<T> clazz, @Nullable ServiceDefinitionImpl serviceDefinitionImpl, InvokerTube invokerTube, boolean bl) {
        this.serviceName = qName;
        this.portName = qName2;
        this.binding = wSBinding;
        this.soapVersion = wSBinding.getSOAPVersion();
        this.container = container;
        this.port = wSDLPort;
        this.implementationClass = clazz;
        this.serviceDef = serviceDefinitionImpl;
        this.seiModel = sEIModel;
        if (serviceDefinitionImpl != null) {
            serviceDefinitionImpl.setOwner(this);
        }
        TubelineAssembler tubelineAssembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), wSBinding.getBindingId(), container);
        assert (tubelineAssembler != null);
        ServerPipeAssemblerContext serverPipeAssemblerContext = new ServerPipeAssemblerContext(sEIModel, wSDLPort, this, invokerTube, bl);
        this.masterTubeline = tubelineAssembler.createServer(serverPipeAssemblerContext);
        Codec codec = serverPipeAssemblerContext.getCodec();
        if (codec instanceof EndpointAwareCodec) {
            codec = codec.copy();
            ((EndpointAwareCodec)codec).setEndpoint(this);
        }
        this.masterCodec = codec;
        this.tubePool = new Pool.TubePool(this.masterTubeline);
        invokerTube.setEndpoint(this);
        this.engine = new Engine(this.toString());
        this.wsdlProperties = wSDLPort == null ? null : new WSDLProperties(wSDLPort);
    }

    @Override
    @NotNull
    public Class<T> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public WSDLPort getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.engine.setExecutor(executor);
    }

    @Override
    public void schedule(final Packet packet, final WSEndpoint.CompletionCallback completionCallback, FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        packet.endpoint = this;
        if (this.wsdlProperties != null) {
            packet.addSatellite(this.wsdlProperties);
        }
        Fiber fiber = this.engine.createFiber();
        if (fiberContextSwitchInterceptor != null) {
            fiber.addInterceptor(fiberContextSwitchInterceptor);
        }
        final Tube tube = this.tubePool.take();
        fiber.start(tube, packet, new Fiber.CompletionCallback(){

            public void onCompletion(@NotNull Packet packet2) {
                WSEndpointImpl.this.tubePool.recycle(tube);
                if (completionCallback != null) {
                    completionCallback.onCompletion(packet2);
                }
            }

            public void onCompletion(@NotNull Throwable throwable) {
                throwable.printStackTrace();
                Message message = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, throwable);
                Packet packet2 = packet.createServerResponse(message, packet.endpoint.getPort(), null, packet.endpoint.getBinding());
                if (completionCallback != null) {
                    completionCallback.onCompletion(packet2);
                }
            }
        });
    }

    @Override
    @NotNull
    public WSEndpoint.PipeHead createPipeHead() {
        return new WSEndpoint.PipeHead(){
            private final Tube tube;
            {
                this.tube = TubeCloner.clone(WSEndpointImpl.this.masterTubeline);
            }

            @NotNull
            public Packet process(Packet packet, WebServiceContextDelegate webServiceContextDelegate, TransportBackChannel transportBackChannel) {
                Packet packet2;
                packet.webServiceContextDelegate = webServiceContextDelegate;
                packet.transportBackChannel = transportBackChannel;
                packet.endpoint = WSEndpointImpl.this;
                if (WSEndpointImpl.this.wsdlProperties != null) {
                    packet.addSatellite(WSEndpointImpl.this.wsdlProperties);
                }
                Fiber fiber = WSEndpointImpl.this.engine.createFiber();
                try {
                    packet2 = fiber.runSync(this.tube, packet);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    Message message = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, runtimeException);
                    packet2 = packet.createServerResponse(message, packet.endpoint.getPort(), null, packet.endpoint.getBinding());
                }
                return packet2;
            }
        };
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.masterTubeline.preDestroy();
        block2: for (Handler handler : this.binding.getHandlerChain()) {
            for (Method method : handler.getClass().getMethods()) {
                if (method.getAnnotation(PreDestroy.class) == null) continue;
                try {
                    method.invoke(handler, new Object[0]);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, HandlerMessages.HANDLER_PREDESTROY_IGNORE(exception.getMessage()), exception);
                }
                continue block2;
            }
        }
    }

    @Override
    public ServiceDefinitionImpl getServiceDefinition() {
        return this.serviceDef;
    }

    @Override
    public Set<EndpointComponent> getComponentRegistry() {
        return this.componentRegistry;
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String string, String string2, Element ... elementArray) {
        AddressingVersion addressingVersion;
        QName qName = null;
        if (this.port != null) {
            qName = this.port.getBinding().getPortTypeName();
        }
        List<Element> list = null;
        if (elementArray != null) {
            list = Arrays.asList(elementArray);
        }
        if ((addressingVersion = AddressingVersion.fromSpecClass(clazz)) == AddressingVersion.W3C) {
            return new WSEndpointReference(AddressingVersion.W3C, string, null, null, null, null, null, list).toSpec(clazz);
        }
        return new WSEndpointReference(AddressingVersion.MEMBER, string, this.serviceName, this.portName, qName, null, string2, list).toSpec(clazz);
    }

    @Override
    @NotNull
    public QName getPortName() {
        return this.portName;
    }

    @Override
    @NotNull
    public Codec createCodec() {
        return this.masterCodec.copy();
    }

    @Override
    @NotNull
    public QName getServiceName() {
        return this.serviceName;
    }

    static {
        try {
            JMXAgent.getDefault();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.endpoint");
    }
}

