/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpMessage;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.SnmpPduRequestType;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTooBigException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpInformHandler;
import com.sun.jmx.snmp.daemon.SnmpRequestCounter;
import com.sun.jmx.snmp.daemon.SnmpSession;
import com.sun.jmx.snmp.daemon.SnmpSocket;
import com.sun.jmx.trace.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;

public class SnmpInformRequest
implements SnmpDefinitions {
    private static SnmpRequestCounter requestCounter = new SnmpRequestCounter();
    private SnmpVarBindList varBindList = null;
    int errorStatus = 0;
    int errorIndex = 0;
    SnmpVarBind[] internalVarBind = null;
    String reason = null;
    private transient SnmpAdaptorServer adaptor;
    private transient SnmpSession informSession;
    private SnmpInformHandler callback = null;
    SnmpPdu requestPdu;
    SnmpPduRequestType responsePdu;
    private static final int stBase = 1;
    public static final int stInProgress = 1;
    public static final int stWaitingToSend = 3;
    public static final int stWaitingForReply = 5;
    public static final int stReceivedReply = 9;
    public static final int stAborted = 16;
    public static final int stTimeout = 32;
    public static final int stInternalError = 64;
    public static final int stResultsAvailable = 128;
    public static final int stNeverUsed = 256;
    private int numTries = 0;
    private int timeout = 3000;
    private int reqState = 256;
    private long prevPollTime = 0L;
    private long nextPollTime = 0L;
    private long waitTimeForResponse;
    private Date debugDate = new Date();
    private int requestId = 0;
    private int port = 0;
    private InetAddress address = null;
    private String communityString = null;
    String dbgTag = "SnmpInformRequest";

    SnmpInformRequest(SnmpSession snmpSession, SnmpAdaptorServer snmpAdaptorServer, InetAddress inetAddress, String string, int n, SnmpInformHandler snmpInformHandler) throws SnmpStatusException {
        this.informSession = snmpSession;
        this.adaptor = snmpAdaptorServer;
        this.address = inetAddress;
        this.communityString = string;
        this.port = n;
        this.callback = snmpInformHandler;
        this.informSession.addInformRequest(this);
        this.setTimeout(this.adaptor.getTimeout());
    }

    public final synchronized int getRequestId() {
        return this.requestId;
    }

    synchronized InetAddress getAddress() {
        return this.address;
    }

    public final synchronized int getRequestStatus() {
        return this.reqState;
    }

    public final synchronized boolean isAborted() {
        return (this.reqState & 0x10) == 16;
    }

    public final synchronized boolean inProgress() {
        return (this.reqState & 1) == 1;
    }

    public final synchronized boolean isResultAvailable() {
        return this.reqState == 128;
    }

    public final synchronized int getErrorStatus() {
        return this.errorStatus;
    }

    public final synchronized int getErrorIndex() {
        return this.errorIndex;
    }

    public final int getMaxTries() {
        return this.adaptor.getMaxTries();
    }

    public final synchronized int getNumTries() {
        return this.numTries;
    }

    final synchronized void setTimeout(int n) {
        this.timeout = n;
    }

    public final synchronized long getAbsNextPollTime() {
        return this.nextPollTime;
    }

    public final synchronized long getAbsMaxTimeToWait() {
        if (this.prevPollTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.waitTimeForResponse;
    }

    public final synchronized SnmpVarBindList getResponseVarBindList() {
        if (this.inProgress()) {
            return null;
        }
        return this.varBindList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCompletion(long l) {
        if (!this.inProgress()) {
            return true;
        }
        if (this.informSession.thisSessionContext()) {
            SnmpInformHandler snmpInformHandler = this.callback;
            this.callback = null;
            this.informSession.waitForResponse(this, l);
            this.callback = snmpInformHandler;
        } else {
            SnmpInformRequest snmpInformRequest = this;
            synchronized (snmpInformRequest) {
                SnmpInformHandler snmpInformHandler = this.callback;
                try {
                    this.callback = null;
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.callback = snmpInformHandler;
            }
        }
        return !this.inProgress();
    }

    public final void cancelRequest() {
        this.errorStatus = 225;
        this.stopRequest();
        this.deleteRequest();
        this.notifyClient();
    }

    public final synchronized void notifyClient() {
        this.notifyAll();
    }

    public void finalize() {
        this.callback = null;
        this.varBindList = null;
        this.internalVarBind = null;
        this.adaptor = null;
        this.informSession = null;
        this.requestPdu = null;
        this.responsePdu = null;
    }

    public static String snmpErrorToString(int n) {
        switch (n) {
            case 0: {
                return "noError";
            }
            case 1: {
                return "tooBig";
            }
            case 2: {
                return "noSuchName";
            }
            case 3: {
                return "badValue";
            }
            case 4: {
                return "readOnly";
            }
            case 5: {
                return "genErr";
            }
            case 6: {
                return "noAccess";
            }
            case 7: {
                return "wrongType";
            }
            case 8: {
                return "wrongLength";
            }
            case 9: {
                return "wrongEncoding";
            }
            case 10: {
                return "wrongValue";
            }
            case 11: {
                return "noCreation";
            }
            case 12: {
                return "inconsistentValue";
            }
            case 13: {
                return "resourceUnavailable";
            }
            case 14: {
                return "commitFailed";
            }
            case 15: {
                return "undoFailed";
            }
            case 16: {
                return "authorizationError";
            }
            case 17: {
                return "notWritable";
            }
            case 18: {
                return "inconsistentName";
            }
            case 224: {
                return "reqTimeout";
            }
            case 225: {
                return "reqAborted";
            }
            case 226: {
                return "rspDecodingError";
            }
            case 227: {
                return "reqEncodingError";
            }
            case 228: {
                return "reqPacketOverflow";
            }
            case 229: {
                return "rspEndOfTable";
            }
            case 230: {
                return "reqRefireAfterVbFix";
            }
            case 231: {
                return "reqHandleTooBig";
            }
            case 232: {
                return "reqTooBigImpossible";
            }
            case 240: {
                return "reqInternalError";
            }
            case 241: {
                return "reqSocketIOError";
            }
            case 242: {
                return "reqUnknownError";
            }
            case 243: {
                return "wrongSnmpVersion";
            }
            case 244: {
                return "snmpUnknownPrincipal";
            }
            case 245: {
                return "snmpAuthNotSupported";
            }
            case 246: {
                return "snmpPrivNotSupported";
            }
            case 249: {
                return "snmpBadSecurityLevel";
            }
            case 247: {
                return "snmpUsmBadEngineId";
            }
            case 248: {
                return "snmpUsmInvalidTimeliness";
            }
        }
        return "Unknown Error = " + n;
    }

    synchronized void start(SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        if (this.inProgress()) {
            throw new SnmpStatusException("Inform request already in progress.");
        }
        this.setVarBindList(snmpVarBindList);
        this.initializeAndFire();
    }

    private synchronized void initializeAndFire() {
        this.requestPdu = null;
        this.responsePdu = null;
        this.reason = null;
        this.startRequest(System.currentTimeMillis());
        this.setErrorStatusAndIndex(0, 0);
    }

    private synchronized void startRequest(long l) {
        this.nextPollTime = l;
        this.prevPollTime = 0L;
        this.schedulePoll();
    }

    private void schedulePoll() {
        this.numTries = 0;
        this.initNewRequest();
        this.setRequestStatus(3);
        this.informSession.getSnmpQManager().addRequest(this);
    }

    void action() {
        if (!this.inProgress()) {
            return;
        }
        while (true) {
            try {
                if (this.numTries == 0) {
                    this.invokeOnReady();
                } else if (this.numTries < this.getMaxTries()) {
                    this.invokeOnRetry();
                } else {
                    this.invokeOnTimeout();
                }
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ++this.numTries;
                if (this.isDebugOn()) {
                    this.debug("action", "Inform request hit out of memory situation...");
                }
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            break;
        }
    }

    private final void invokeOnReady() {
        if (this.requestPdu == null) {
            this.requestPdu = this.constructPduPacket();
        }
        if (this.requestPdu != null && !this.sendPdu()) {
            this.queueResponse();
        }
    }

    private final void invokeOnRetry() {
        this.invokeOnReady();
    }

    private final void invokeOnTimeout() {
        this.errorStatus = 224;
        this.queueResponse();
    }

    private final void queueResponse() {
        this.informSession.addResponse(this);
    }

    synchronized SnmpPdu constructPduPacket() {
        SnmpPduRequest snmpPduRequest = null;
        Exception exception = null;
        try {
            snmpPduRequest = new SnmpPduRequest();
            snmpPduRequest.port = this.port;
            snmpPduRequest.type = 166;
            snmpPduRequest.version = 1;
            snmpPduRequest.community = this.communityString.getBytes("8859_1");
            snmpPduRequest.requestId = this.getRequestId();
            snmpPduRequest.varBindList = this.internalVarBind;
            if (this.isTraceOn()) {
                this.trace("constructPduPacket", "Packet built");
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            this.errorStatus = 242;
            this.reason = exception2.getMessage();
        }
        if (exception != null) {
            if (this.isDebugOn()) {
                this.debug("constructPduPacket", exception);
            }
            snmpPduRequest = null;
            this.queueResponse();
        }
        return snmpPduRequest;
    }

    boolean sendPdu() {
        try {
            this.responsePdu = null;
            SnmpPduFactory snmpPduFactory = this.adaptor.getPduFactory();
            SnmpMessage snmpMessage = (SnmpMessage)snmpPduFactory.encodeSnmpPdu((SnmpPduPacket)this.requestPdu, this.adaptor.getBufferSize());
            if (snmpMessage == null) {
                if (this.isDebugOn()) {
                    this.debug("sendPdu", "pdu factory returned a null value");
                }
                throw new SnmpStatusException(242);
            }
            int n = this.adaptor.getBufferSize();
            byte[] byArray = new byte[n];
            int n2 = snmpMessage.encodeMessage(byArray);
            if (this.isTraceOn()) {
                this.trace("sendPdu", "Dump : \n" + snmpMessage.printMessage());
            }
            this.sendPduPacket(byArray, n2);
            return true;
        }
        catch (SnmpTooBigException snmpTooBigException) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", snmpTooBigException);
            }
            this.setErrorStatusAndIndex(228, snmpTooBigException.getVarBindCount());
            this.requestPdu = null;
            this.reason = snmpTooBigException.getMessage();
            if (this.isDebugOn()) {
                this.debug("sendPdu", "Packet Overflow while building inform request");
            }
        }
        catch (IOException iOException) {
            this.setErrorStatusAndIndex(241, 0);
            this.reason = iOException.getMessage();
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", exception);
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = exception.getMessage();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendPduPacket(byte[] byArray, int n) throws IOException {
        SnmpSocket snmpSocket;
        if (this.isTraceOn()) {
            this.trace("sendPduPacket", "Send to peer. Peer/Port : " + this.address.getHostName() + "/" + this.port + ". Length = " + n + "\nDump : \n" + SnmpMessage.dumpHexBuffer(byArray, 0, n));
        }
        SnmpSocket snmpSocket2 = snmpSocket = this.informSession.getSocket();
        synchronized (snmpSocket2) {
            snmpSocket.sendPacket(byArray, n, this.address, this.port);
            this.setRequestSentTime(System.currentTimeMillis());
        }
    }

    final void processResponse() {
        if (this.isTraceOn()) {
            this.trace("processResponse", "errstatus = " + this.errorStatus);
        }
        if (!this.inProgress()) {
            this.responsePdu = null;
            return;
        }
        if (this.errorStatus >= 240) {
            this.handleInternalError("Internal Error...");
            return;
        }
        try {
            this.parsePduPacket(this.responsePdu);
            switch (this.errorStatus) {
                case 0: {
                    this.handleSuccess();
                    return;
                }
                case 224: {
                    this.handleTimeout();
                    return;
                }
                case 240: {
                    this.handleInternalError("Unknown internal error.  deal with it later!");
                    return;
                }
                case 231: {
                    this.setErrorStatusAndIndex(1, 0);
                    this.handleError("Cannot handle too-big situation...");
                    return;
                }
                case 230: {
                    this.initializeAndFire();
                    return;
                }
            }
            this.handleError("Error status set in packet...!!");
            return;
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("processResponse", exception);
            }
            this.reason = exception.getMessage();
            this.handleInternalError(this.reason);
            return;
        }
    }

    synchronized void parsePduPacket(SnmpPduRequestType snmpPduRequestType) {
        if (snmpPduRequestType == null) {
            return;
        }
        this.errorStatus = snmpPduRequestType.getErrorStatus();
        this.errorIndex = snmpPduRequestType.getErrorIndex();
        if (this.errorStatus == 0) {
            this.updateInternalVarBindWithResult(((SnmpPdu)((Object)snmpPduRequestType)).varBindList);
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        if (this.isTraceOn()) {
            this.trace("parsePduPacket", "received inform response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
    }

    private void handleSuccess() {
        this.setRequestStatus(128);
        if (this.isTraceOn()) {
            this.trace("handleSuccess", "Invoking user defined callback...");
        }
        this.deleteRequest();
        this.notifyClient();
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.errorStatus, this.errorIndex, this.getVarBindList());
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleSuccess", "Exception generated by user callback");
                this.debug("handleSuccess", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleSuccess", "OutOfMemory Error generated by user callback");
                this.debug("handleSuccess", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private void handleTimeout() {
        this.setRequestStatus(32);
        if (this.isDebugOn()) {
            this.debug("handleTimeout", "Snmp error/index = " + SnmpInformRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking timeout user defined callback...");
        }
        this.deleteRequest();
        this.notifyClient();
        this.requestPdu = null;
        this.responsePdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollTimeout(this);
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleTimeout", "Exception generated by user callback");
                this.debug("handleTimeout", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleTimeout", "OutOfMemory Error generated by user callback");
                this.debug("handleTimeout", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private void handleError(String string) {
        this.setRequestStatus(128);
        if (this.isDebugOn()) {
            this.debug("handleError", "Snmp error/index = " + SnmpInformRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking error user defined callback...\n" + this.getVarBindList());
        }
        this.deleteRequest();
        this.notifyClient();
        this.requestPdu = null;
        this.responsePdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.getErrorStatus(), this.getErrorIndex(), this.getVarBindList());
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleError", "Exception generated by user callback");
                this.debug("handleError", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleError", "OutOfMemory Error generated by user callback");
                this.debug("handleError", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private void handleInternalError(String string) {
        this.setRequestStatus(64);
        if (this.reason == null) {
            this.reason = string;
        }
        if (this.isDebugOn()) {
            this.debug("handleInternalError", "Snmp error/index = " + SnmpInformRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking internal error user defined callback...\n" + this.getVarBindList());
        }
        this.deleteRequest();
        this.notifyClient();
        this.requestPdu = null;
        this.responsePdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpInternalError(this, this.reason);
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleInternalError", "Exception generated by user callback");
                this.debug("handleInternalError", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleInternalError", "OutOfMemory Error generated by user callback");
                this.debug("handleInternalError", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    void updateInternalVarBindWithResult(SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null || snmpVarBindArray.length == 0) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.internalVarBind.length && n < snmpVarBindArray.length; ++i) {
            SnmpVarBind snmpVarBind = this.internalVarBind[i];
            if (snmpVarBind == null) continue;
            SnmpVarBind snmpVarBind2 = snmpVarBindArray[n];
            snmpVarBind.setSnmpValue(snmpVarBind2.getSnmpValue());
            ++n;
        }
    }

    final void invokeOnResponse(Object object) {
        if (object != null) {
            if (object instanceof SnmpPduRequestType) {
                this.responsePdu = (SnmpPduRequestType)object;
            } else {
                return;
            }
        }
        this.setRequestStatus(9);
        this.queueResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRequest() {
        SnmpInformRequest snmpInformRequest = this;
        synchronized (snmpInformRequest) {
            this.setRequestStatus(16);
        }
        this.informSession.getSnmpQManager().removeRequest(this);
        snmpInformRequest = this;
        synchronized (snmpInformRequest) {
            this.requestId = 0;
        }
    }

    final synchronized void deleteRequest() {
        this.informSession.removeInformRequest(this);
    }

    final synchronized SnmpVarBindList getVarBindList() {
        return this.varBindList;
    }

    final synchronized void setVarBindList(SnmpVarBindList snmpVarBindList) {
        this.varBindList = snmpVarBindList;
        if (this.internalVarBind == null || this.internalVarBind.length != this.varBindList.size()) {
            this.internalVarBind = new SnmpVarBind[this.varBindList.size()];
        }
        this.varBindList.copyInto(this.internalVarBind);
    }

    final synchronized void setErrorStatusAndIndex(int n, int n2) {
        this.errorStatus = n;
        this.errorIndex = n2;
    }

    final synchronized void setPrevPollTime(long l) {
        this.prevPollTime = l;
    }

    final void setRequestSentTime(long l) {
        ++this.numTries;
        this.setPrevPollTime(l);
        this.waitTimeForResponse = this.prevPollTime + (long)(this.timeout * this.numTries);
        this.setRequestStatus(5);
        if (this.isTraceOn()) {
            this.trace("setRequestSentTime", "Inform request Successfully sent");
        }
        this.informSession.getSnmpQManager().addWaiting(this);
    }

    final synchronized void initNewRequest() {
        this.requestId = requestCounter.getNewId();
    }

    long timeRemainingForAction(long l) {
        switch (this.reqState) {
            case 3: {
                return this.nextPollTime - l;
            }
            case 5: {
                return this.waitTimeForResponse - l;
            }
        }
        return -1L;
    }

    static final String statusDescription(int n) {
        switch (n) {
            case 3: {
                return "Waiting to send.";
            }
            case 5: {
                return "Waiting for reply.";
            }
            case 9: {
                return "Response arrived.";
            }
            case 16: {
                return "Aborted by user.";
            }
            case 32: {
                return "Timeout Occured.";
            }
            case 64: {
                return "Internal error.";
            }
            case 128: {
                return "Results available";
            }
            case 256: {
                return "Inform request in createAndWait state";
            }
        }
        return "Unknown inform request state.";
    }

    final synchronized void setRequestStatus(int n) {
        this.reqState = n;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(this.tostring());
        stringBuffer.append("\nPeer/Port : " + this.address.getHostName() + "/" + this.port);
        return stringBuffer.toString();
    }

    private synchronized String tostring() {
        StringBuffer stringBuffer = new StringBuffer("InformRequestId = " + this.requestId);
        stringBuffer.append("   Status = " + SnmpInformRequest.statusDescription(this.reqState));
        stringBuffer.append("  Timeout/MaxTries/NumTries = " + this.timeout * this.numTries + "/" + this.getMaxTries() + "/" + this.numTries);
        if (this.prevPollTime > 0L) {
            this.debugDate.setTime(this.prevPollTime);
            stringBuffer.append("\nPrevPolled = " + this.debugDate.toString());
        } else {
            stringBuffer.append("\nNeverPolled");
        }
        stringBuffer.append(" / RemainingTime(millis) = " + this.timeRemainingForAction(System.currentTimeMillis()));
        return stringBuffer.toString();
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 256);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 256, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 256, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 256, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

