/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import java.io.IOException;
import java.security.SecureRandom;
import javax.net.ssl.SSLKeyException;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;

final class KerberosPreMasterSecret {
    private ProtocolVersion protocolVersion;
    private byte[] preMaster;
    private byte[] encrypted;

    KerberosPreMasterSecret(ProtocolVersion protocolVersion, SecureRandom secureRandom, EncryptionKey encryptionKey) throws IOException {
        if (encryptionKey.getEType() == 16) {
            throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
        }
        this.protocolVersion = protocolVersion;
        this.preMaster = KerberosPreMasterSecret.generatePreMaster(secureRandom, protocolVersion);
        try {
            EncryptedData encryptedData = new EncryptedData(encryptionKey, this.preMaster, 0);
            this.encrypted = encryptedData.getBytes();
        }
        catch (KrbException krbException) {
            throw (SSLKeyException)new SSLKeyException("Kerberos premaster secret error").initCause(krbException);
        }
    }

    KerberosPreMasterSecret(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, EncryptionKey encryptionKey) throws IOException {
        boolean bl;
        this.encrypted = handshakeInStream.getBytes16();
        if (HandshakeMessage.debug != null && Debug.isOn("handshake") && this.encrypted != null) {
            Debug.println(System.out, "encrypted premaster secret", this.encrypted);
        }
        if (encryptionKey.getEType() == 16) {
            throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
        }
        try {
            EncryptedData encryptedData = new EncryptedData(encryptionKey.getEType(), null, this.encrypted);
            byte[] byArray = encryptedData.decrypt(encryptionKey, 0);
            if (HandshakeMessage.debug != null && Debug.isOn("handshake") && this.encrypted != null) {
                Debug.println(System.out, "decrypted premaster secret", byArray);
            }
            this.preMaster = encryptedData.reset(byArray, false);
            this.protocolVersion = ProtocolVersion.valueOf(this.preMaster[0], this.preMaster[1]);
            if (HandshakeMessage.debug != null && Debug.isOn("handshake")) {
                System.out.println("Kerberos PreMasterSecret version: " + this.protocolVersion);
            }
        }
        catch (Exception exception) {
            this.preMaster = null;
            this.protocolVersion = protocolVersion;
        }
        boolean bl2 = bl = this.protocolVersion != protocolVersion && this.protocolVersion.v != protocolVersion2.v;
        if (this.preMaster == null || this.preMaster.length != 48 || bl) {
            if (HandshakeMessage.debug != null && Debug.isOn("handshake")) {
                System.out.println("Kerberos PreMasterSecret error, generating random secret");
                if (this.preMaster != null) {
                    Debug.println(System.out, "Invalid secret", this.preMaster);
                }
            }
            this.preMaster = KerberosPreMasterSecret.generatePreMaster(secureRandom, protocolVersion);
            this.protocolVersion = protocolVersion;
        }
    }

    KerberosPreMasterSecret(ProtocolVersion protocolVersion, SecureRandom secureRandom) {
        this.protocolVersion = protocolVersion;
        this.preMaster = KerberosPreMasterSecret.generatePreMaster(secureRandom, protocolVersion);
    }

    private static byte[] generatePreMaster(SecureRandom secureRandom, ProtocolVersion protocolVersion) {
        byte[] byArray = new byte[48];
        secureRandom.nextBytes(byArray);
        byArray[0] = protocolVersion.major;
        byArray[1] = protocolVersion.minor;
        return byArray;
    }

    byte[] getUnencrypted() {
        return this.preMaster;
    }

    byte[] getEncrypted() {
        return this.encrypted;
    }
}

