/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.traversers;

import com.sun.org.apache.xerces.internal.impl.validation.ValidationState;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaNamespaceSupport;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaException;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSAnnotationInfo;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSAttributeChecker;
import com.sun.org.apache.xerces.internal.impl.xs.util.XInt;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XSDocumentInfo {
    protected SchemaNamespaceSupport fNamespaceSupport;
    protected SchemaNamespaceSupport fNamespaceSupportRoot;
    protected Stack SchemaNamespaceSupportStack = new Stack();
    protected boolean fAreLocalAttributesQualified;
    protected boolean fAreLocalElementsQualified;
    protected short fBlockDefault;
    protected short fFinalDefault;
    String fTargetNamespace;
    protected boolean fIsChameleonSchema;
    protected Element fSchemaElement;
    Vector fImportedNS = new Vector();
    protected ValidationState fValidationContext = new ValidationState();
    SymbolTable fSymbolTable = null;
    protected XSAttributeChecker fAttrChecker;
    protected Object[] fSchemaAttrs;
    protected XSAnnotationInfo fAnnotations = null;
    private Vector fReportedTNS = null;

    XSDocumentInfo(Element element, XSAttributeChecker xSAttributeChecker, SymbolTable symbolTable) throws XMLSchemaException {
        this.fSchemaElement = element;
        this.initNamespaceSupport(element);
        this.fIsChameleonSchema = false;
        this.fSymbolTable = symbolTable;
        this.fAttrChecker = xSAttributeChecker;
        if (element != null) {
            Element element2 = element;
            this.fSchemaAttrs = xSAttributeChecker.checkAttributes(element2, true, this);
            if (this.fSchemaAttrs == null) {
                throw new XMLSchemaException(null, null);
            }
            this.fAreLocalAttributesQualified = ((XInt)this.fSchemaAttrs[XSAttributeChecker.ATTIDX_AFORMDEFAULT]).intValue() == 1;
            this.fAreLocalElementsQualified = ((XInt)this.fSchemaAttrs[XSAttributeChecker.ATTIDX_EFORMDEFAULT]).intValue() == 1;
            this.fBlockDefault = ((XInt)this.fSchemaAttrs[XSAttributeChecker.ATTIDX_BLOCKDEFAULT]).shortValue();
            this.fFinalDefault = ((XInt)this.fSchemaAttrs[XSAttributeChecker.ATTIDX_FINALDEFAULT]).shortValue();
            this.fTargetNamespace = (String)this.fSchemaAttrs[XSAttributeChecker.ATTIDX_TARGETNAMESPACE];
            if (this.fTargetNamespace != null) {
                this.fTargetNamespace = symbolTable.addSymbol(this.fTargetNamespace);
            }
            this.fNamespaceSupportRoot = new SchemaNamespaceSupport(this.fNamespaceSupport);
            this.fValidationContext.setNamespaceSupport(this.fNamespaceSupport);
            this.fValidationContext.setSymbolTable(symbolTable);
        }
    }

    private void initNamespaceSupport(Element element) {
        this.fNamespaceSupport = new SchemaNamespaceSupport();
        this.fNamespaceSupport.reset();
        for (Node node = element.getParentNode(); node != null && node.getNodeType() == 1 && !node.getNodeName().equals("DOCUMENT_NODE"); node = node.getParentNode()) {
            Element element2 = (Element)node;
            NamedNodeMap namedNodeMap = element2.getAttributes();
            int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getNamespaceURI();
                if (string == null || !string.equals("http://www.w3.org/2000/xmlns/")) continue;
                String string2 = attr.getLocalName().intern();
                if (string2 == "xmlns") {
                    string2 = "";
                }
                if (this.fNamespaceSupport.getURI(string2) != null) continue;
                this.fNamespaceSupport.declarePrefix(string2, attr.getValue().intern());
            }
        }
    }

    void backupNSSupport(SchemaNamespaceSupport schemaNamespaceSupport) {
        this.SchemaNamespaceSupportStack.push(this.fNamespaceSupport);
        if (schemaNamespaceSupport == null) {
            schemaNamespaceSupport = this.fNamespaceSupportRoot;
        }
        this.fNamespaceSupport = new SchemaNamespaceSupport(schemaNamespaceSupport);
        this.fValidationContext.setNamespaceSupport(this.fNamespaceSupport);
    }

    void restoreNSSupport() {
        this.fNamespaceSupport = (SchemaNamespaceSupport)this.SchemaNamespaceSupportStack.pop();
        this.fValidationContext.setNamespaceSupport(this.fNamespaceSupport);
    }

    public String toString() {
        return this.fTargetNamespace == null ? "no targetNamspace" : "targetNamespace is " + this.fTargetNamespace;
    }

    public void addAllowedNS(String string) {
        this.fImportedNS.addElement(string == null ? "" : string);
    }

    public boolean isAllowedNS(String string) {
        return this.fImportedNS.contains(string == null ? "" : string);
    }

    final boolean needReportTNSError(String string) {
        if (this.fReportedTNS == null) {
            this.fReportedTNS = new Vector();
        } else if (this.fReportedTNS.contains(string)) {
            return false;
        }
        this.fReportedTNS.addElement(string);
        return true;
    }

    Object[] getSchemaAttrs() {
        return this.fSchemaAttrs;
    }

    void returnSchemaAttrs() {
        this.fAttrChecker.returnAttrArray(this.fSchemaAttrs, null);
        this.fSchemaAttrs = null;
    }

    void addAnnotation(XSAnnotationInfo xSAnnotationInfo) {
        xSAnnotationInfo.next = this.fAnnotations;
        this.fAnnotations = xSAnnotationInfo;
    }

    XSAnnotationInfo getAnnotations() {
        return this.fAnnotations;
    }

    void removeAnnotations() {
        this.fAnnotations = null;
    }
}

