/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Panel.ChooseUninstallationType;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.ModuleCtrl;

public class ChooseUninstallationTypeCtrl
extends PanelController
implements ActionListener {
    private String helpFile = "String_Helpfile_ChooseUninstallationType";

    public ChooseUninstallationTypeCtrl() {
        super("ChooseUninstallationType", new ChooseUninstallationType());
    }

    public String getNext() {
        InstallData data = InstallData.getInstance();
        if (data.getInstallationType().equals(data.getCustomActionCommand())) {
            return new String("ChooseUninstallationComponents");
        }
        if (data.getInstallationType().equals(data.getTypicalActionCommand())) {
            return new String("UninstallationImminent");
        }
        System.err.println("Error: Unknown uninstallation type!");
        return new String("Error");
    }

    public String getPrevious() {
        return new String("UninstallationPrologue");
    }

    public void beforeShow() {
        InstallData data = InstallData.getInstance();
        ChooseUninstallationType panel = (ChooseUninstallationType)this.getPanel();
        panel.setActionListener(this);
        panel.setCompleteActionCommand(data.getTypicalActionCommand());
        panel.setCustomActionCommand(data.getCustomActionCommand());
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        ChooseUninstallationType panel = (ChooseUninstallationType)this.getPanel();
        panel.removeActionListener(this);
        if (nextButtonPressed) {
            InstallData data = InstallData.getInstance();
            PackageDescription packageData = SetupDataProvider.getPackageDescription();
            if (data.getInstallationType().equals(data.getTypicalActionCommand()) && data.typicalSelectionStateSaved()) {
                ModuleCtrl.restoreTypicalSelectionStates(packageData);
            }
            if (data.getInstallationType().equals(data.getCustomActionCommand())) {
                if (!data.typicalSelectionStateSaved()) {
                    ModuleCtrl.saveTypicalSelectionStates(packageData);
                    data.setTypicalSelectionStateSaved(true);
                }
                if (data.customSelectionStateSaved()) {
                    ModuleCtrl.restoreCustomSelectionStates(packageData);
                }
            }
        }
        return repeatDialog;
    }

    public void actionPerformed(ActionEvent evt) {
        InstallData data = InstallData.getInstance();
        if (evt.getActionCommand().equals(data.getTypicalActionCommand())) {
            data.setInstallationType(data.getTypicalActionCommand());
        } else if (evt.getActionCommand().equals(data.getCustomActionCommand())) {
            data.setInstallationType(data.getCustomActionCommand());
        }
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }
}

