/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.fastinfoset;

import com.sun.xml.internal.fastinfoset.stax.StAXDocumentParser;
import com.sun.xml.internal.fastinfoset.stax.StAXDocumentSerializer;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetCodec;
import com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetStreamReaderFactory;
import com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetStreamSOAP11Codec;
import com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetStreamSOAP12Codec;
import com.sun.xml.internal.ws.message.stream.StreamHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

public abstract class FastInfosetStreamSOAPCodec
implements Codec {
    private static final FastInfosetStreamReaderFactory READER_FACTORY = FastInfosetStreamReaderFactory.getInstance();
    private StAXDocumentParser _statefulParser;
    private StAXDocumentSerializer _serializer;
    private final StreamSOAPCodec _soapCodec;
    private final boolean _retainState;
    protected final ContentType _defaultContentType;

    FastInfosetStreamSOAPCodec(StreamSOAPCodec streamSOAPCodec, SOAPVersion sOAPVersion, boolean bl, String string) {
        this._soapCodec = streamSOAPCodec;
        this._retainState = bl;
        this._defaultContentType = new ContentTypeImpl(string);
    }

    FastInfosetStreamSOAPCodec(FastInfosetStreamSOAPCodec fastInfosetStreamSOAPCodec) {
        this._soapCodec = (StreamSOAPCodec)fastInfosetStreamSOAPCodec._soapCodec.copy();
        this._retainState = fastInfosetStreamSOAPCodec._retainState;
        this._defaultContentType = fastInfosetStreamSOAPCodec._defaultContentType;
    }

    public String getMimeType() {
        return this._defaultContentType.getContentType();
    }

    public ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet.soapAction);
    }

    public ContentType encode(Packet packet, OutputStream outputStream) {
        if (packet.getMessage() != null) {
            XMLStreamWriter xMLStreamWriter = this.getXMLStreamWriter(outputStream);
            try {
                packet.getMessage().writeTo(xMLStreamWriter);
                xMLStreamWriter.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }
        return this.getContentType(packet.soapAction);
    }

    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        packet.setMessage(this._soapCodec.decode(this.getXMLStreamReader(inputStream)));
    }

    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        throw new UnsupportedOperationException();
    }

    protected abstract StreamHeader createHeader(XMLStreamReader var1, XMLStreamBuffer var2);

    protected abstract ContentType getContentType(String var1);

    private XMLStreamWriter getXMLStreamWriter(OutputStream outputStream) {
        if (this._serializer != null) {
            this._serializer.setOutputStream(outputStream);
            return this._serializer;
        }
        this._serializer = FastInfosetCodec.createNewStreamWriter(outputStream, this._retainState);
        return this._serializer;
    }

    private XMLStreamReader getXMLStreamReader(InputStream inputStream) {
        if (this._retainState) {
            if (this._statefulParser != null) {
                this._statefulParser.setInputStream(inputStream);
                return this._statefulParser;
            }
            this._statefulParser = FastInfosetCodec.createNewStreamReader(inputStream, this._retainState);
            return this._statefulParser;
        }
        return READER_FACTORY.doCreate(null, inputStream, false);
    }

    public static FastInfosetStreamSOAPCodec create(StreamSOAPCodec streamSOAPCodec, SOAPVersion sOAPVersion) {
        return FastInfosetStreamSOAPCodec.create(streamSOAPCodec, sOAPVersion, false);
    }

    public static FastInfosetStreamSOAPCodec create(StreamSOAPCodec streamSOAPCodec, SOAPVersion sOAPVersion, boolean bl) {
        if (sOAPVersion == null) {
            throw new IllegalArgumentException();
        }
        switch (sOAPVersion) {
            case SOAP_11: {
                return new FastInfosetStreamSOAP11Codec(streamSOAPCodec, bl);
            }
            case SOAP_12: {
                return new FastInfosetStreamSOAP12Codec(streamSOAPCodec, bl);
            }
        }
        throw new AssertionError();
    }
}

