/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertType;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.ClientCertDialog;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.PasswordCallbackHandler;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;

public final class X509DeployKeyManager
implements X509KeyManager {
    private X509KeyManager myKeyManager = null;
    private X509KeyManager browserKeyManager = null;
    private String userKeyStore = null;
    private String systemKeyStore = null;
    private KeyStore browserKeyStore = null;
    private boolean isWindows = Config.getOSName().indexOf("Windows") != -1;
    private static HashMap clientAuthCertsCachedMap = new HashMap();
    private static ThreadLocal clientCertDialogCancelled = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static ThreadLocal passwdDialogCancelled = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };

    public X509DeployKeyManager() {
        this.userKeyStore = Config.getUserClientAuthCertFile();
        this.systemKeyStore = Config.getSystemClientAuthCertFile();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            this.browserKeyStore = service.getBrowserClientAuthKeyStore();
        }
    }

    private void init() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
                    X509DeployKeyManager.this.do_init();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            if (exception instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)exception;
            }
            if (exception instanceof FileNotFoundException) {
                throw (FileNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
    }

    private void do_init() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        this.browserKeyManager = this.getBrowserKeyManager(this.browserKeyStore);
        this.myKeyManager = Config.isJavaVersionAtLeast16() ? this.getNewMyKeyManager(this.userKeyStore, this.systemKeyStore) : this.getLegacyMyKeyManager(this.userKeyStore);
    }

    public synchronized String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        HashMap<String, X509Certificate[]> hashMap = new HashMap<String, X509Certificate[]>();
        HashMap<String, CertType> hashMap2 = new HashMap<String, CertType>();
        String string = null;
        String string2 = null;
        if (clientCertDialogCancelled.get().equals(Boolean.FALSE)) {
            String string3;
            Object object;
            Object object2;
            block16: {
                try {
                    Class<?> clazz = Class.forName("com.sun.net.ssl.internal.ssl.SSLSocketImpl");
                    boolean bl = clazz.isInstance(socket);
                    if (bl) {
                        object2 = clazz.cast(socket);
                        object = clazz.getDeclaredMethod("getHost", null);
                        AccessController.doPrivileged(new PrivilegedExceptionAction((Method)object){
                            private final /* synthetic */ Method val$privateGetHostMethod;
                            {
                                this.val$privateGetHostMethod = method;
                            }

                            public Object run() throws IOException {
                                this.val$privateGetHostMethod.setAccessible(true);
                                return null;
                            }
                        });
                        string2 = (String)((Method)object).invoke(object2, null);
                    }
                }
                catch (Exception exception) {
                    Trace.msgSecurityPrintln("clientauth.readFromCache.failed");
                    if (exception == null) break block16;
                    Trace.msgSecurityPrintln(exception.toString());
                }
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = this.getClientAliases(stringArray[i], principalArray);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    int n = CertType.PLUGIN.getType().length();
                    string3 = stringArray2[j].substring(n);
                    X509Certificate[] x509CertificateArray = this.getCertificateChain(string3);
                    try {
                        if (!CertUtils.checkTLSClient(x509CertificateArray[0])) continue;
                        hashMap.put(string3, x509CertificateArray);
                        if (stringArray2[j].startsWith(CertType.PLUGIN.getType())) {
                            hashMap2.put(string3, CertType.PLUGIN);
                        }
                        if (!stringArray2[j].startsWith(CertType.BROWSER.getType())) continue;
                        hashMap2.put(string3, CertType.BROWSER);
                        continue;
                    }
                    catch (CertificateException certificateException) {
                        Trace.msgSecurityPrintln("clientauth.checkTLSClient.failed", new Object[]{string3});
                    }
                }
            }
            if (passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                final HashMap<String, X509Certificate[]> hashMap3 = hashMap;
                final HashMap<String, CertType> hashMap4 = hashMap2;
                if (string2 != null && clientAuthCertsCachedMap.size() > 0) {
                    object2 = clientAuthCertsCachedMap.keySet().iterator();
                    object = null;
                    string3 = null;
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        if (((String)object).compareToIgnoreCase(string2) != 0) continue;
                        string3 = (String)clientAuthCertsCachedMap.get(object);
                        Trace.msgSecurityPrintln("clientauth.readFromCache.success", new Object[]{string3});
                        return string3;
                    }
                }
                if (Config.getBooleanProperty("deployment.security.clientauth.keystore.auto") && hashMap3.size() == 1) {
                    object2 = hashMap3.keySet().toArray();
                    string = (String)object2[0];
                } else {
                    object2 = new DeploySysAction(){

                        public Object execute() {
                            return ClientCertDialog.showDialog(hashMap3, hashMap4);
                        }
                    };
                    string = (String)DeploySysRun.executePrivileged((DeploySysAction)object2, null);
                }
            }
            if (string == null) {
                clientCertDialogCancelled.set(Boolean.TRUE);
            }
            if (socket instanceof SSLSocket) {
                MyListener myListener = new MyListener(string2, string);
                ((SSLSocket)socket).addHandshakeCompletedListener(myListener);
            }
            return string;
        }
        return null;
    }

    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseClientAlias(stringArray, principalArray, null);
    }

    public synchronized String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = null;
        if (this.myKeyManager != null) {
            string2 = this.myKeyManager.chooseServerAlias(string, principalArray, socket);
        }
        if (string2 == null && this.browserKeyManager != null) {
            string2 = this.browserKeyManager.chooseServerAlias(string, principalArray, socket);
        }
        return string2;
    }

    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseServerAlias(string, principalArray, null);
    }

    public synchronized X509Certificate[] getCertificateChain(String string) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        X509Certificate[] x509CertificateArray = null;
        if (this.myKeyManager != null && !string.contains("Mozilla") && !string.contains("MSCrypto")) {
            x509CertificateArray = this.myKeyManager.getCertificateChain(string);
        }
        if (x509CertificateArray == null && this.browserKeyManager != null) {
            x509CertificateArray = this.browserKeyManager.getCertificateChain(string);
        }
        return x509CertificateArray;
    }

    public synchronized String[] getClientAliases(String string, Principal[] principalArray) {
        int n;
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.myKeyManager != null) {
            stringArray = this.myKeyManager.getClientAliases(string, principalArray);
        }
        if (this.browserKeyManager != null) {
            stringArray2 = this.browserKeyManager.getClientAliases(string, principalArray);
        }
        if (stringArray == null) {
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = CertType.BROWSER.getType() + stringArray2[i];
                }
            }
            return stringArray2;
        }
        if (stringArray2 == null) {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = CertType.PLUGIN.getType() + stringArray[i];
                }
            }
            return stringArray;
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = CertType.PLUGIN.getType() + stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = CertType.BROWSER.getType() + stringArray2[n];
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public synchronized String[] getServerAliases(String string, Principal[] principalArray) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.myKeyManager != null) {
            stringArray = this.myKeyManager.getServerAliases(string, principalArray);
        }
        if (this.browserKeyManager != null) {
            stringArray2 = this.browserKeyManager.getServerAliases(string, principalArray);
        }
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public PrivateKey getPrivateKey(String string) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PrivateKey privateKey = null;
        if (this.myKeyManager != null && !string.contains("Mozilla") && !string.contains("MSCrypto")) {
            privateKey = this.myKeyManager.getPrivateKey(string);
        }
        if (privateKey == null && this.browserKeyManager != null) {
            privateKey = this.browserKeyManager.getPrivateKey(string);
        }
        return privateKey;
    }

    private X509KeyManager getBrowserKeyManager(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        X509KeyManager x509KeyManager = null;
        if (keyStore != null) {
            keyStore.load(null, new char[0]);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            keyManagerFactory.init(keyStore, new char[0]);
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            for (int i = 0; i < keyManagerArray.length; ++i) {
                if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                x509KeyManager = (X509KeyManager)keyManagerArray[i];
                break;
            }
        }
        return x509KeyManager;
    }

    private X509KeyManager getNewMyKeyManager(String string, String string2) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        X509KeyManager x509KeyManager;
        block6: {
            x509KeyManager = null;
            File file = new File(string);
            File file2 = new File(string2);
            if (file.exists() || file2.exists()) {
                try {
                    PasswordCallbackHandler passwordCallbackHandler = new PasswordCallbackHandler("clientauth.user.password.dialog.text");
                    PasswordCallbackHandler passwordCallbackHandler2 = new PasswordCallbackHandler("clientauth.system.password.dialog.text");
                    KeyStore.Builder builder = null;
                    KeyStore.Builder builder2 = null;
                    if (file.exists()) {
                        builder = KeyStore.Builder.newInstance("JKS", null, file, new KeyStore.CallbackHandlerProtection(passwordCallbackHandler));
                    }
                    if (file2.exists()) {
                        builder2 = KeyStore.Builder.newInstance("JKS", null, file2, new KeyStore.CallbackHandlerProtection(passwordCallbackHandler2));
                    }
                    KeyStoreBuilderParameters keyStoreBuilderParameters = new KeyStoreBuilderParameters(Arrays.asList(builder, builder2));
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("NewSunX509");
                    keyManagerFactory.init(keyStoreBuilderParameters);
                    KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                    for (int i = 0; i < keyManagerArray.length; ++i) {
                        if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                        x509KeyManager = (X509KeyManager)keyManagerArray[i];
                        break;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (Trace.isAutomationEnabled()) break block6;
                    String string3 = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.text");
                    String string4 = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.caption");
                    UIFactory.showExceptionDialog(null, exception, string3, string4);
                }
            }
        }
        return x509KeyManager;
    }

    private X509KeyManager getLegacyMyKeyManager(String string) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        X509KeyManager x509KeyManager = null;
        File file = new File(string);
        if (file.exists()) {
            boolean bl = true;
            while (bl) {
                Object object;
                String string2;
                try {
                    char[] cArray = this.getPasswordDialog("clientauth.user.password.dialog.text");
                    if (passwdDialogCancelled.get().equals(Boolean.TRUE)) break;
                    string2 = System.getProperty("javax.net.ssl.keyStoreType");
                    if (string2 == null) {
                        string2 = "JKS";
                    }
                    object = KeyStore.getInstance(string2);
                    ((KeyStore)object).load(new BufferedInputStream(new FileInputStream(string)), cArray);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
                    keyManagerFactory.init((KeyStore)object, cArray);
                    KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                    for (int i = 0; i < keyManagerArray.length; ++i) {
                        if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                        x509KeyManager = (X509KeyManager)keyManagerArray[i];
                        break;
                    }
                    bl = false;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (Trace.isAutomationEnabled()) continue;
                    string2 = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.text");
                    object = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.caption");
                    UIFactory.showExceptionDialog(null, iOException, string2, (String)object);
                }
            }
        }
        return x509KeyManager;
    }

    private char[] getPasswordDialog(String string) {
        CredentialInfo credentialInfo = UIFactory.showPasswordDialog(null, X509DeployKeyManager.getMessage("password.dialog.title"), X509DeployKeyManager.getMessage(string), false, false, null, false);
        if (credentialInfo == null) {
            passwdDialogCancelled.set(Boolean.TRUE);
            return null;
        }
        return credentialInfo.getPassword();
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }

    static final class MyListener
    implements HandshakeCompletedListener {
        private String hostname;
        private String certName;

        public MyListener(String string, String string2) {
            this.hostname = string;
            this.certName = string2;
        }

        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
            SSLSocket sSLSocket = handshakeCompletedEvent.getSocket();
            if (this.hostname != null) {
                clientAuthCertsCachedMap.put(this.hostname, this.certName);
            }
            sSLSocket.removeHandshakeCompletedListener(this);
        }

        public boolean equals(Object object) {
            if (!(object instanceof MyListener)) {
                return false;
            }
            MyListener myListener = (MyListener)object;
            return myListener.hostname.compareToIgnoreCase(this.hostname) == 0;
        }
    }
}

