/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.image.PNGImageDecoder;

class PNGFilterInputStream
extends FilterInputStream {
    PNGImageDecoder owner;
    public InputStream underlyingInputStream;

    public PNGFilterInputStream(PNGImageDecoder pNGImageDecoder, InputStream inputStream) {
        super(inputStream);
        this.underlyingInputStream = this.in;
        this.owner = pNGImageDecoder;
    }

    public int available() throws IOException {
        return this.owner.limit - this.owner.pos + this.in.available();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.owner.chunkLength <= 0 && !this.owner.getData()) {
            return -1;
        }
        --this.owner.chunkLength;
        return this.owner.inbuf[this.owner.chunkStart++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.owner.chunkLength <= 0 && !this.owner.getData()) {
            return -1;
        }
        if (this.owner.chunkLength < n2) {
            n2 = this.owner.chunkLength;
        }
        System.arraycopy(this.owner.inbuf, this.owner.chunkStart, byArray, n, n2);
        this.owner.chunkLength -= n2;
        this.owner.chunkStart += n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        int n = 0;
        while ((long)n < l && this.read() >= 0) {
            ++n;
        }
        return n;
    }
}

