/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include "autogenerateui/autogenerateinteractionuiviewactionable.h"

class AutoGenerateInteractionUiViewText;
class QPlainTextEdit;
// see ./packages/ui-kit/src/blocks/elements/UsersSelectElement.ts
class LIBRUQOLAWIDGETS_TESTS_EXPORT AutoGenerateInteractionUiViewUserSelectElement : public AutoGenerateInteractionUiViewActionable
{
    Q_OBJECT
public:
    explicit AutoGenerateInteractionUiViewUserSelectElement(QObject *parent = nullptr);
    ~AutoGenerateInteractionUiViewUserSelectElement() override;

    [[nodiscard]] ActionElementWidget *generateWidget(QWidget *parent) override;

    [[nodiscard]] AutoGenerateInteractionUiViewText *placeHolder() const;
    void setPlaceHolder(AutoGenerateInteractionUiViewText *newPlaceHolder);

    [[nodiscard]] bool operator==(const AutoGenerateInteractionUiViewUserSelectElement &other) const;

    [[nodiscard]] QVariant currentValue() const override;
    void setCurrentValue(const QVariant &v) override;

protected:
    void parseElement(const QJsonObject &json) override;
    void serializeElement(QJsonObject &o) const override;

private:
    AutoGenerateInteractionUiViewText *mPlaceHolder = nullptr;
    QPlainTextEdit *mPlainTextEdit = nullptr;
};
Q_DECLARE_METATYPE(AutoGenerateInteractionUiViewUserSelectElement)
LIBRUQOLAWIDGETS_EXPORT QDebug operator<<(QDebug d, const AutoGenerateInteractionUiViewUserSelectElement &t);
