#include <qdragobject.h>

#include "kdropdemo.h"

KDropDemo::KDropDemo (QWidget *parent, const char *name) :
  QLabel (parent, name)
{
  setAcceptDrops(true);
  setText ("---------------No drops yet.---------------");
}

void
KDropDemo::dragEnterEvent (QDragEnterEvent *qdragenterevent)
{
  qdragenterevent->accept (QTextDrag::canDecode (qdragenterevent));
}

void
KDropDemo::dropEvent (QDropEvent *qdropevent)
{
  QString text;
  
  if (QTextDrag::decode (qdropevent, text))
    setText (text);
}
